;Check.asm	10-Dec-2005
;Sudoku output checker
;Original by Chut; modified for 9-line format by Boreal.
;Usage: CHECK < SUDOKU.OUT
;Assemble with Tasm and TLink/t

cseg		segment
		assume	cs:cseg, ds:cseg, ss:cseg, es:cseg
		.386

		ORG	100h

Start:		MOV	CX,81
		MOV	DI,Puzzle

ReadCycle:	MOV	AH,06h			;load 9x9 character
		MOV	DL,0FFh
		INT	21h
		MOV	DX,offset Err1Txt	;checking size of input ( underflow )
		JZ	Exit
		MOV	DX,offset Err2Txt
		SUB	AL,30h

		JA	Okay			;skip if >'0'
		CMP	AL,20h-30h		;check for space
		JE	ReadCycle		;ignore it
		CMP	AL,0Dh-30h		;check for carriage return
		JNE	Exit			;error if not
		MOV	DL,0FFh			;load next character
		INT	21h
		CMP	AL,0Ah			;check for line feed
		JE	ReadCycle
		MOV	DX,offset Err5Txt
		JMP	Exit
Okay:
		CMP	AL,09h
		JA	Exit			;checking illegal characters ( >'9' )
		STOSB
		LOOP	ReadCycle

		MOV	AH,06h			;check for final carriage return
		MOV	DL,0FFh
		INT	21h
		MOV	DX,offset Err2Txt
		CMP	AL,0Dh			;check for carriage return
		JNE	Exit			;error if not
		MOV	DL,0FFh			;check for final line feed
		INT	21h
		MOV	DX,offset Err5Txt
		CMP	AL,0Ah
		JNE	Exit			;error if not

		MOV	AH,06h			;checkint size of input ( overflow )
		MOV	DL,0FFh
		INT	21h
		MOV	DX,offset Err3Txt
		JNZ	Exit

		MOV	SI,Puzzle		;checking rows
		MOV	BP,9
NextRow:	XOR	BX,BX			;counter reset
		MOV	CX,9
RowNumber:	LODSB				;read 9 digits
		BTS	BX,AX
		LOOP	RowNumber
		MOV	DX,offset Err4Txt
		CMP	BX,0000001111111110b	;check all digits ( 1-9 )
		JNE	Exit
		DEC	BP
		JNZ	NextRow

		MOV	SI,Puzzle		;checking columns
		MOV	BP,9
NextCol:	XOR	BX,BX			;counter reset
		MOV	CX,9
ColNumber:	LODSB				;read 9 digits
		ADD	SI,8
		BTS	BX,AX
		LOOP	ColNumber
		MOV	DX,offset Err4Txt
		CMP	BX,0000001111111110b	;check all digits ( 1-9 )
		JNE	Exit
		SUB	SI,80
		DEC	BP
		JNZ	NextCol

		MOV	SI,Puzzle		;checking boxes
		MOV	CX,3
NextBoxV:	PUSH	CX
		MOV	CX,3
NextBoxH:	PUSH	CX
		XOR	BX,BX			;counter reset
		MOV	CX,3
BoxCol: 	PUSH	CX
		MOV	CX,3
BoxRow: 	LODSB
		BTS	BX,AX
		LOOP	BoxRow
		POP	CX
		ADD	SI,6
		LOOP	BoxCol
		MOV	DX,offset Err4Txt
		CMP	BX,0000001111111110b	;check all digits ( 1-9 )
		JNE	Exit
		POP	CX
		SUB	SI,3*9-3
		LOOP	NextBoxH		;next box horizontally
		POP	CX
		ADD	SI,2*9
		LOOP	NextBoxV		;next box vertically

		MOV	DX,offset GoodTxt

Exit:		MOV	AH,09h
		INT	21h			;Print message
		INT	20h			;Return to DOS

Err1Txt 	DB	'ERROR: Input is too short.',10,10,13,'$'
Err2Txt 	DB	'ERROR: Illegal character detected.',10,10,13,'$'
Err3Txt 	DB	'ERROR: Input is too long.',10,10,13,'$'
Err4Txt 	DB	'ERROR: Wrong solution.',10,10,13,'$'
Err5Txt 	DB	'ERROR: Line feed expected.',10,10,13,'$'
GoodTxt 	DB	'MESSAGE: Correct solution.',10,10,13,'$'

Puzzle		dw	?

cseg		ends
		end	Start
