; Hugi Compo #24 -  The Tortoise and the Hare
;
; Entry by Flyke ( ville@heaven.dk )
; 
; Last changed 29.09.2005
;
; This is my second HUGI compo and I'm enjoying this a lot!
; I'm learning ZOUNDS doing this as well!
;
; Fill algorithm sucks .. it's extremely slow and seems to take up lots of bytes!
; But I've left it and spent the time on other optimizations..
; 
; 
; masm 6.14
; ml /c entry.asm
; link /tiny entry.obj,entry.com, , , ,


storedpic			EQU	offset programend+50

.model tiny
.486
.code

	org 100h

start:

	mov		si, storedpic

	call	zeromem

nextfile:
	mov		ax, 3
	int		10h
	
; read filename
	mov		ah, 0Ah
	mov		dx, offset buffer
	int		21h
	
	;Z-terminate string
	inc			dx
	inc			dx	
	mov     bx,dx
	movzx   di,byte ptr [bx-1]
	mov     byte ptr [bx+di],0

; open file	
	mov		ax, 3D00h
	int		21h
	jc		exit
	mov		word ptr [filehandle], ax
	
	mov		ax, 13h
	int		10h
	
	push  0A000h
  pop   es
;restore saved screendump
  pusha
  xor		di, di
  mov		ch, 0FAh			; cx = 0 from loop
  rep		movsb
  popa
	
mainloop:

	call	ReadByte
	jcxz	@F
	
	add		ax,ax           ;entries in cmdRoutineTable are 2 bytes
	xchg	ax, bx
  call	word ptr [bx+cmdTable] ;call command service
	
	jmp		mainloop
	
@@:
	; close file
	mov		ah, 3Eh
	mov		bx, word ptr [filehandle]
	int		21h

; Save picture	
  mov		cx, 320*200
  xor		bx, bx
@@:
  mov		al, byte ptr es:[bx]
  mov		byte ptr ds:[si+bx], al
  inc		bx
  loop	@B

	jmp		nextfile

simple_return:
instr_nop:
exit:
	ret
	;int		20h

readByte	proc
        	mov     bx, word ptr [fileHandle]
		      mov     cx,1
		      mov     ah,3Fh
		      mov     dx,offset command
		      int     21h
		      ; cx = 1 hence ah=0 after xchg
		      xchg    ax,cx
		      ;movzx   ax,byte ptr [command]
		      mov			al, byte ptr [command]
		      ret
readbyte	endp

; instead of instr_nop we call somewhere with a ret instruction (exit: ...)
;instr_nop				proc
;								ret
;instr_nop				endp


; Originally I had implemented Bresenham as described on GameDev
; http://www.gamedev.net/reference/articles/article767.asp
;
; But I ended up using the examples algorithm..
; http://www.cs.umbc.edu/~rheingan/435/pages/res/gen-3.Circles-single-page-0.html

; PutPixel(CenterX + X, Center Y + Y) ;neg x
; PutPixel(CenterX - X, Center Y + Y) ;neg y
; PutPixel(CenterX - X, Center Y - Y) ;neg x
; PutPixel(CenterX + X, Center Y - Y) ;xchg
; PutPixel(CenterX - Y, Center Y + X) ;neg x
; PutPixel(CenterX - Y, Center Y - X) ;neg y
; PutPixel(CenterX + Y, Center Y - X) ;neg x
; PutPixel(CenterX + Y, Center Y + X)

;void MidpointCircle ( int radius, int value )
;{
;   int   x, y;
;   int d;
;
;   x = 0;
;   y = radius;
;   d = 1 - radius;
;   CirclePoints ( x, y, value );
;   
;   while ( y > x ) {
;      if ( d < 0 ) {
;         d += x * 2 + 3;
;	 x ++;
;      }
;      else {
;         d += (x - y) * 2 + 5;
;	 x ++;
;	 y --;
;      }
;      CirclePoints ( x, y, value );
;   }
;}



instr_circle	proc
							call	readByte
							; ax = y = radius
							; dx = d = 1-radius
							xor		dx, dx
							inc		dx
							sub		dx, ax
							xor		bx, bx			; bx = x = 0

instr_circle_loop:

							pusha
							call	halfcircle
							xchg	ax, bx
							call	halfcircle
							popa
							
							test	dx, dx
							jns		instr_circle_d_above0
							add		dx, 3
							add		dx, bx
							add		dx, bx
							
							jmp		instr_circle_d_updated
instr_circle_d_above0:
							add		dx, 5

							add		dx, bx
							add		dx, bx
							sub		dx, ax
							sub		dx, ax
							
							dec		ax
instr_circle_d_updated:

							cmp		bx, ax
							jge		offset simple_return

							inc		bx
							jmp		instr_circle_loop
instr_circle	endp


halfcircle		proc
							call	circle_inner
							neg		bx
							call	circle_inner
							neg		ax
							call	circle_inner
							neg		bx
							call	circle_inner
							ret
halfcircle		endp


; ax = y
; bx = x
circle_inner	proc
							pusha							
							add		ax, [pen.y]
							cmp		ax, 199
							ja		@F
							imul	di, ax, 320
							add		bx, [pen.x]
							cmp		bx, 319
							ja		@F
							add		di, bx
							mov		al, [pen.color]
							stosb
@@:
							popa
							ret
circle_inner	endp



				
instr_moveup		proc
								call	readByte
								xchg	ax, cx
								jcxz	plot
@@:
								call	plot
								cmp		[pen.y], 0
								jle		plot
								dec		[pen.y]
								loop	@B
								jmp		plot
instr_moveup		endp
				
instr_movedown:
								call	readByte
								xchg	ax, cx
								jcxz	plot
@@:
								call	plot
								cmp		[pen.y], 199
								jge		plot
								inc		[pen.y]
								loop	@B
								;jmp		plot

plot:
					mov			ax, word ptr [pen.color]	; ah=pen.on, al=pen.color
					cmp			ah, 0
					je			plot_end
					call		getVideoAddress
	        stosb
plot_end:
					ret
;plot			endp
				
			
instr_moveleft	proc
								call	movehorizontal
								jcxz	plot
@@:
								call	plot
								cmp		[pen.x], 0
								jle		plot
								dec		[pen.x]
								loop	@B
								jmp		plot
instr_moveleft	endp


instr_moveright	proc
								call	movehorizontal
								jcxz	plot
@@:
								call	plot
								cmp		[pen.x], 319
								jge		plot
								inc		[pen.x]
								loop	@B
								jmp		plot
instr_moveright	endp


				
movehorizontal	proc
								call	readByte
								push	ax
								call	readByte
								pop		cx
								mov		ch, al
								ret
movehorizontal	endp
				
instr_movecoord	proc
								xor		bp, bp
@@:
								call	readbyte
								mov		byte ptr [pen.x+bp], al
								inc		bp
								cmp		bp, 4
								jne		@B
								
								ret
instr_movecoord	endp



instr_penon		proc
							;inc			byte ptr [pen.on]			<-- can't use this because we can turn it on 256 times and return to off position!
							;mov			byte ptr [pen.on], 1
							mov			byte ptr [pen.on], cl ; we can use this as CL = number of bytes read = 1
							ret
instr_penon		endp

instr_penoff	proc
							mov     byte ptr [pen.on], 0
							ret
instr_penoff	endp
				
instr_color		proc
							call	readByte
							mov   byte ptr [pen.color], al
							ret
instr_color		endp
				
instr_pause		proc
							xor     ax,ax
							int     16h
							ret
instr_pause		endp
				

; The fill algorithm works like this...
;
; 1. store the fill color
; 2. store the current pixels color ( original color )
; 3. zero an image map
; 4. put a 1 in the location of the current position
; 
; 5. go through image map until a 1 is found
; 6. mark the pixels North, South, West & East in the image map a 1 
;    but only if it is 0 AND the color in the original image = the original color.
;    Remember to check borders!
; 7. Replace color with fill color. Mark position as 2.
; repeat steps 5 through 7 until there are no more 1's in the image map.

instr_fill		proc
							call		readByte
							; store fill color in bl
							xchg		ax, bx
							
							call		zeromem

							call		getVideoAddress
							; store original color in bh !
							mov     bh,byte ptr es:[di]

							mov			bp, di
							inc			byte ptr [bp+si]
							;mov			byte ptr [bp+si], 1
instr_fill_next1:
							mov			bp, -1
; filler loop
instr_fill_loop:
							inc			bp
							cmp			bp, 320*200
							je			instr_fill_end
							cmp			byte ptr [bp+si], 1
							jne			instr_fill_loop
							
							;mov			byte ptr [bp+si], 2
							inc			byte ptr [bp+si]
							mov			di, bp
							mov			al, bl
							stosb
							
							cmp			bp, 320
							jb			@F
							mov			di, -320
							call		instr_fill_inner						
@@:

							cmp			bp, 64000-320-1
							ja			@F
							mov			di, 320
							call		instr_fill_inner
@@:

							mov			di, -1
							xor			ax, ax
							call		instr_fill_horizontal
							
							inc			di
							inc			di
							mov			ax, 319
							call		instr_fill_horizontal
							
							jmp			instr_fill_next1
; end filler loop
instr_fill_end:
							
							ret
instr_fill		endp


instr_fill_inner	proc
							pusha
							add			si, di
							cmp			byte ptr [bp+si], 0
							jne			@F
							cmp			bh, byte ptr es:[bp+di]
							jne			@F
							mov			byte ptr [bp+si], 1
@@:
							popa
							ret
instr_fill_inner	endp

instr_fill_horizontal	proc
							push		ax
							xor			dx, dx
							mov			ax, bp
							mov			cx, 320
							idiv		cx
							pop			ax
							cmp			dx, ax
							je			simple_return2
							jmp			offset instr_fill_inner
							;call		instr_fill_inner
							;ret
instr_fill_horizontal	endp


zeromem			proc
				xor			ecx, ecx
				mov			ch, 0FAh
				pusha
@@:
				mov			byte ptr [si], 0
				inc			si
				loop		@B
				popa
				ret
zeromem			endp


getVideoAddress:
        imul    di,[pen.y],320
        add     di,[pen.x]
simple_return2:
        ret
;getVideoAddress endp <-- compiler won't let me jump to simple_return2 if getVideoAddress is declared as a procedure

_pen 	struct
				x				dw 0
				y				dw 0
				color		db 0
				on			db 0
_pen		ends


cmdTable:
				dw		offset	instr_nop
				dw		offset	instr_moveup
				dw		offset	instr_movedown
				dw		offset	instr_moveleft
				dw		offset	instr_moveright
				dw		offset	instr_movecoord
				dw		offset	instr_penon
				dw		offset	instr_penoff
				dw		offset	instr_color
				dw		offset	instr_pause
				dw		?
; radius uses one byte, so here is 1 byte of storage "to spare"
radius:
				dw		?

; pen takes up exactly 3 Words
pen			_pen {}


;				dw		?
;				dw		?
;				dw		?
filehandle:
				dw		?
				dw		offset	instr_circle
				dw		offset	instr_fill

buffer  db 20,0

command:
programend:

end start