;
; Hugi Compo #24 - The Tortoise and the Hare
; (alternative fill using state and table)
;
; compile with nasm:
;	nasmw -O3 entry.asm -o entry.com
;
; written by Anton Khorev (tony29@yandex.ru)
; based on example by Hannes Uppman
;

SCREEN equ 320*2
VIDEO_SEG equ 0A000h - SCREEN/10h
HANDLE equ 0FFFCh ; handle will be pushed here

%define PEN_OFF PLOT_SKIP-PLOT_ANYWAY ; 8
%define PEN_ON	0

%define _POSX	bp
%define _POSY	si
%define _READ	di

org 100h
segment .text
CMD_BASE:
	xor _POSX,_POSX
	xor _POSY,_POSY
	; ah=0
	mov al,13h
	int 10h
MAIN_LOOP:
; { save screen
	push VIDEO_SEG
	pop ds
	push cs
	pop es
	call COPY
	push es
	push ds
	pop es
	pop ds
; } save screen
	mov al,03h
	int 10h
; { prompt & open
	mov dx,BUFFER
	mov ah,0Ah
	int 21h
	inc dx
	mov bx,dx
	add bl,[bx] ; should not wrap around - filenames are short
	inc bx
	inc dx
	mov ax,3D00h
	mov [bx],al
	int 21h
	jc EXIT
	push ax ; save handle
; } prompt & open
	mov ax,13h
	int 10h
; { restore screen
	call COPY
; } restore screen
; { draw
DRAW:
	mov bx,ax ; no xchg to keep ah=0
	mov cl,[bx+COMMAND_TABLE]
	mov ch,1
	call cx
	mov _READ,READ
	call _READ
	jns DRAW
; } draw
CLOSE:
; { close
	pop bx ; restore handle
	mov ah,3Eh
	int 21h
; } close
	jmp short MAIN_LOOP

;;;; commands ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CMD_DIR_Y:
	call _READ
	xchg ax,cx
	jmp short CMD_DIR_0
CMD_DIR_X:
	call _READ
	call _READ
CMD_DIR_0:
	inc cx
	movsx dx,[(bx+MOVE_TABLE_X-1)+(di-READ)] ; di added to make immediate offset fit in byte
	movsx bx,[(bx+MOVE_TABLE_Y-1)+(di-READ)]
CMD_DIR_1:
	call PLOT
	jnc CMD_DIR_2
	add _POSX,dx
	add _POSY,bx
	loop CMD_DIR_1
CMD_DIR_2:
	sub _POSX,dx
	sub _POSY,bx
CMD_NOP: ; stick it to any ret
EXIT:
	ret

CMD_MOVE:
	call _READ
	call _READ
	mov _POSX,cx
	call _READ
	call _READ
	mov _POSY,cx
	ret

CMD_PEN_ON:  ; ax=6
CMD_PEN_OFF: ; ax=7
	inc ax
	and al,8
	mov [PEN],al
	ret

CMD_COLOR:
	call _READ ; color
	mov [COLOR],al
	ret

CMD_PAUSE:
	;xor ax,ax ; ah=0
	int 16h
	ret

; { circle
; midpoint line circle algorithm (without deltaE and deltaSE)
CMD_CIRCLE:

%define _X dx
%define _Y ax
%define _D bx

	call _READ ; Y = radius
	cwd ;xor _X,_X
	mov _D,_Y

	; { use symmetry in order to print a circle
CMD_CIRCLE_1:
	;mov cx,4	; uncomment for fast circles
			; any number divisible by 4 (including 0) will do
			; cx=xx10h at first iteration and 0 at later	    
CMD_CIRCLE_SYMMETRY:
	pusha
	add _POSX,_X
	add _POSY,_Y
	call PLOT_ANYWAY
	popa
	neg _Y
	xchg _X,_Y
	loop CMD_CIRCLE_SYMMETRY
	neg _Y
	jl CMD_CIRCLE_1
	; } use symmetry in order to print a circle

	sub _D,_X
	inc _X
	sub _D,_X
	jg CMD_CIRCLE_2
	dec _Y
	add _D,_Y
	add _D,_Y
CMD_CIRCLE_2:
	jg CMD_CIRCLE_1

CMD_FILL_EXIT: ; stick it to any nearby ret
	ret

; } circle

; this function is highly recursive and requires a lot of stack, worst
; case senario is that the levels of recursion equals the number of
; pixels available; a little less then 64k. Hence one can only afford
; one byte to be pushed on the stack per level of recusrion.
CMD_FILL:
%define _use al
%define _target dh
	call _READ
	call CLIP ;VIDEO_ADDR
	mov _target,[es:di]
	cmp _use,_target
	je CMD_FILL_EXIT
	;mov ah,0 ; done by READ

CMD_FILL_DO:
	push ax ;
	inc sp	; "push ah"
	mov bx,5

CMD_FILL_LOOP:
	movsx di,[REL_TABLE_X+bx-1]
	add _POSX,di
	movsx di,[REL_TABLE_Y+bx-1]
	add _POSY,di

	dec bx
	jnz CMD_FILL_OK
	dec sp
	pop bx
	shr bx,8
	jz CMD_FILL_EXIT

CMD_FILL_OK:
	call CLIP ; on screen?
	jnc CMD_FILL_LOOP
	cmp [es:di],_target
	jne CMD_FILL_LOOP ; dont plot if color on pixel isnt target color
	stosb

	mov ah,bl
	jmp CMD_FILL_DO

REL_TABLE_X db 0
REL_TABLE_Y db -1,+1,+1,-1,0

;;;; functions ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

COPY:
	push si
	mov si,SCREEN
	mov di,si
	mov cx,320*200
	rep movsb
	pop si
	xchg ax,cx ; ax=0
	ret

; ax = byte read
; cx = word read (call READ twice)
; s flag = eof
READ:
	push bx
	push ax
	mov bx,[HANDLE]
	mov cx,1
	push cx ; prepare buffer - something w/ high byte = zero
	mov ah,3Fh
	mov dx,sp
	int 21h
	dec ax ; set s flag on error
	pop ax ; get result from buffer
	pop cx
	mov ch,al
	pop bx
	ret

; plot at current position
PLOT:
	db 0EBh ; jmp short
PEN:	db PEN_OFF
PLOT_ANYWAY: ; plot even if pen is off
	call CLIP
	jnc PLOT_SKIP
	db 0B0h ;
COLOR	db 0	; mov al,color
	stosb
PLOT_SKIP:
	; run CLIP again to set/clear carry flag

; called from PLOT, CMD_FILL
; carry flag is clear if clipping has occured
CLIP:
	imul di,_POSY,320
	lea di,[di+_POSX+SCREEN]

	cmp _POSX,320
	jnb CLIP_1
	cmp _POSY,200
CLIP_1:
	ret

;;;; data ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

COMMAND_TABLE:
	db CMD_NOP	-CMD_BASE
	db CMD_DIR_Y	-CMD_BASE
	db CMD_DIR_Y	-CMD_BASE
	db CMD_DIR_X	-CMD_BASE
	db CMD_DIR_X	-CMD_BASE
	db CMD_MOVE	-CMD_BASE
	db CMD_PEN_ON	-CMD_BASE
	db CMD_PEN_OFF	-CMD_BASE
	db CMD_COLOR	-CMD_BASE
	db CMD_PAUSE	-CMD_BASE
MOVE_TABLE_X db 0,0	      ;
MOVE_TABLE_Y db     -1,+1,0,0 ; 6 bytes
	db CMD_CIRCLE	-CMD_BASE
BUFFER: db CMD_FILL	-CMD_BASE ; something big enough to be key buffer length

;SCREEN:
