	page	240, 132
;TESTER.ASM	20-MAY-2003		Boreal		loren_blaney@idcomm.com
;Test suite for Hugi Compo #22 -- The Unmentionable Game
;This is not your usual run-of-the-mill program. It uses coroutines and a little
; bit of magic. It borrows code written by Ruud, TAD and possibly others that
; was used in Compo #10. (Thanx guys, I learned a lot!)

;Assemble with:
; tasm tester
; tlink /t tester

	.386
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h
Start:
;Shrink memory to 128K to provide space for ENTRY.COM child program
	mov	ah, 4Ah
	mov	bx, 2000h
	int	21h
	
	;; Ben
	;; I wouldn't trust this on all DOS versions, especially a DOS session
	;;  But I haven't done much work with it, so who knows.
	;; mov  ax,cs
	mov	[wCs1], ax		;completely undocumented trick: ax = es
	mov	[wCs2], ax		; unless error code is returned instead
	mov	[wCs3], ax

;Reference example's screen segment := cs + 64K
	mov	ax, cs
	add	ax, 1000h
	mov	ScnSeg, ax

;Set up stack to look like a suspend occurred (see Suspnd routine)
	push	offset Example		;push entry loc for alternate coroutine
	pusha				;save current coroutine's registers
	push	ds
	push	es
  ; cli  ;; Ben (just incase it is an older CPU)
	mov	spsave, sp		;save alternate coroutine's stack
	mov	sssave, ss		; pointer and segment
  ; nop  ;; Ben  <-- this instruction executes with interrupts off also
  ; sti  ;; Ben  <--  again, just to make sure.

;Hook in new keyboard interrupt (16h) handler
	mov	ax, 3516h		;copy interrupt vector into es:bx
	int	21h
	mov	wOld16, bx		;save it in Old16
	mov	wOld16+2, es

	mov	ax, 2516h		;set interrupt vector 16h to ds:dx
	mov	dx, offset Int16Hook
	int	21h

;Hook in new system clock tick interrupt (1Ah) handler
	mov	ax, 351Ah		;copy interrupt vector into es:bx
	int	21h
	mov	wOld1A, bx		;save it in Old1A
	mov	wOld1A+2, es

	mov	ax, 251Ah		;set interrupt vector 1Ah to ds:dx
	mov	dx, offset Int1AHook
	int	21h

;Execute entry.com
  ; it is documented that DOS 2.0 doesn't save any of the registers.
  ; to make sure, lets save them anyway.
  ; pusha    ;; Ben
  ; push ds  ;; Ben
  ; push es  ;; Ben
  ; push fs  ;; Ben
  ; push gs  ;; Ben
  ; push ss  ;; Ben  <- of course you will need another memory operand :-)
  ; push sp  ;; Ben  <- of course you will need another memory operand :-)

	mov	ax, 4B00h		;load and execute program
	mov	bx, offset bEpb		;es:bx = parameter block
	push	ds
	pop	es
	mov	dx, offset EntryCom	;ds:dx = file name (entry.com)
	int	21h

  ; pop  sp  ;; Ben  <- of course you will need another memory operand :-)
  ; pop  ss  ;; Ben  <- of course you will need another memory operand :-)
  ; pop  gs  ;; Ben
  ; pop  fs  ;; Ben
  ; pop  es  ;; Ben
  ; pop  ds  ;; Ben
  ; popa     ;; Ben
  ; sti      ;; Ben  Just in case

	jnc	err00
	or	ErrFlag, 10h		;entry.com not found
err00:
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	push	cs			;another undocumented "feature" of DOS:
	pop	ds			; ds is not necessarily preserved

;Unhook keyboard interrupt (16h) handler (restore vector)
	push	ds
	lds	dx, dword ptr cs:wOld16	;get original interrupt vector
	mov	ax, 2516h		;restore it
	int	21h
	pop	ds

;Unhook system clock interrupt (1Ah) handler (restore vector)
	push	ds
	lds	dx, dword ptr cs:wOld1A	;get original interrupt vector
	mov	ax, 251Ah		;restore it
	int	21h
	pop	ds

;Display error messages
	mov	ah, 0Fh			;if not video mode 3 then error
	int	10h
	cmp	al, 3
	je	err20
	or	ErrFlag, 01h		;text mode 3 not restored at termination

	mov	ax, 0003h		;set mode 3
	int	10h
err20:
	mov	ah, 03h			;get cursor position
	mov	bh, 0
	int	10h
	cmp	dx, 0000h		;must be in upper-left corner
	je	err22
	or	ErrFlag, 08h
err22:
	mov	dx, offset msgNo	;assume no errors
	cmp	ErrFlag, 0		;return error code to DOS
	je	err30
	mov	dx, offset msgErr
err30:
	mov	ah, 09h
	int	21h

	mov	ah, 09h
	test	ErrFlag, 01h
	je	err32
	mov	dx, offset msg0
	int	21h
err32:
	test	ErrFlag, 02h
	je	err34
	mov	dx, offset msg1
	int	21h
err34:
	test	ErrFlag, 04h
	je	err36
	mov	dx, offset msg2
	int	21h
err36:
	test	ErrFlag, 08h
	je	err38
	mov	dx, offset msg3
	int	21h
err38:
	test	ErrFlag, 10h
	je	err40
	mov	dx, offset msg4
	int	21h
err40:
	mov	ax, ErrFlag
	or	al, ah
	mov	ah, 4Ch			;return to DOS
	int	21h			; (stack can be imbalanced)

;-------------------------------------------------------------------------------
;New keyboard handler. (Called by entry.com.)
;
Int16Hook:
	pushf				;save flags in case Old16 is executed

	cmp	ah, 1			;intercept function 1 (key status)
	je	IntStat

	cmp	ah, 0			;only intercept function 0 (read key)
	jne	Old16

	popf
	sti				;re-enable interrupts
	cld				;tester's example code may expect this

	call	Suspnd			;run example program & check for errors
	mov	ax, cs:KeyCode		;return key code in ax
	iret


IntStat:popf
	sti				;re-enable interrupts
	cld				;tester's example code may expect this

	call	Suspnd			;run example program & check for errors

;if key is waiting to be input (al#'.') then clear Z flag and return ASCII
; code and scan code in ax.

	push	bp
	push	ax
	mov	bp, sp

	mov	al, [bp+8]		;get flag bits
	or	al, 40h			;set Z flag--assume no key waiting
	mov	[bp+8], al

	mov	ax, cs:KeyCode
	cmp	al, '.'			;key waiting?
	je	IntS2			;jump if not

	mov	al, [bp+8]		;a key is waiting to be read in
	and	al, not 40h		;clear Z flag
	mov	[bp+8], al
	pop	ax			;return key code in ax
	mov	ax, cs:KeyCode
	push	ax
IntS2:
	pop	ax
	pop	bp
	iret


Old16:	popf
	db	0EAh			;jmp far ptr
wOld16	dw	?, ?			;original int 16h vector

;-------------------------------------------------------------------------------
;New system clock tick handler. (Called by entry.com.)
;
Int1AHook:
	pushf				;save flags in case Old1A is executed

	cmp	ah, 0			;only intercept function 0 (get ticks)
	jne	Old1A

	popf
	sti				;re-enable interrupts
	cld				;tester's example code may expect this

	call	Suspnd			;run example program & check for errors

	mov	al, 0			;clear rolled-over flag
	mov	cx, 12			;around high noon
	mov	dx, cs:TickCnt		;return tick count /4
	shr	dx, 2			;(1Ah must be called 4x for a change)
	iret

Old1A:	popf
	db	0EAh			;jmp far ptr
wOld1A	dw	?, ?			;original int 1Ah vector

;-------------------------------------------------------------------------------
;Get keystroke and return it in ax. (Called by tester's example code.)
;
KeyIn:	mov	ax, KeyCode
	call	Suspnd			;run the coroutine (entry.com) awhile
	ret

;-------------------------------------------------------------------------------
;See if a keystroke is pending. The Z flag is clear if so and the ASCII code is
; returned in al and the scan code is returned in ah. (Called by example code.)
;
KeyHit:	push	dx
kh10:	mov	ah, 06h			;get command from keyboard
	mov	dl, 0FFh		;(the character actually comes from a
	int	21h			; file redirected on the command line)
	je	kh10			;loop until key
	pop	dx

	call	GetScanCode
	mov	KeyCode, ax		;pass keystroke to entry.com

	call	Suspnd			;run the coroutine (entry.com) awhile

	cmp	al, '.'			;set Z flag if no key waiting
	ret				; (other flags are too, but not used)

;-------------------------------------------------------------------------------
;Get the current TickCnt and return it in cx:dx. The value is returned in dx
; only, and it changes every 4th time this routine is called. Also returns ax=0.
;
GetTick:inc	TickCnt			;bump counter
	mov	ax, TickCnt		;every 4th time check screen
	and	al, 03h
	cmp	al, 02h
	jne	gt10
	 call	Check			;check screen
gt10:
	xor	ax, ax			;clear rolled-over flag and restore ah=0
	mov	cx, 12			;around high noon
	mov	dx, TickCnt		;return tick count /4
	shr	dx, 2

	call	Suspnd			;run the coroutine (entry.com) awhile
	ret

;-------------------------------------------------------------------------------
;Determine the scan code for the character in al and put it into ah.
; This only handles the characters used in the game.
;
GetScanCode:
	cmp	al, 'j'
	jne	gsc10
	mov	ah, 24h
	ret
gsc10:
	cmp	al, 'k'
	jne	gsc20
	mov	ah, 25h
	ret
gsc20:
	cmp	al, 'l'
	jne	gsc30
	mov	ah, 26h
	ret
gsc30:
	cmp	al, 20h			;spacebar
	jne	gsc40
	mov	ah, 39h
	ret
gsc40:
	cmp	al, 1Bh			;Esc
	jne	gsc50
	mov	ah, 01h
	ret
gsc50:
	mov	ah, 0			;any other key gets 0 scan code
	ret

;-------------------------------------------------------------------------------
;Write character in al to ScnSeg. The character's upper left corner is at
; cx,dx (X,Y)
;
;Register usage:
; al = char
; ah = Byte	font byte (8 pixels) MSB = left side of char
; cx = X	pixel coordinates in ScnSeg
; dx = Y
; si = I	index
; di = J
; es = ScnSeg
; fs = 0
; gs = Font Seg

PlotCh:	pusha
	push	es
	push	fs
	push	gs

	mov	es, ScnSeg
	push	0
	pop	fs

	mov	di, 7			;for J:= 0, 8-1 do
	add	dx, di			;start at bottom row of character
dc10:	pusha				;save al, cx, di
;Get byte from BIOS's font table; Byte:= Peek(FtSeg,  FtOff+Ch*8+J)
	cbw
	shl	ax, 3			;* font height
	lgs	bx, fs:[43h*4]		;get font table location
	add	bx, ax
	mov	ah, gs:[bx+di]

	mov	si, 8			;for each bit in the Byte...
dc20:	shl	ah, 1			;MSB is on the left side
	mov	al, 0			;assume black
	jnc	dc30			;if Byte & $80 then
	 mov	al, 7			;white
dc30:	imul	di, dx, 320		;mov	di, Y*320 + X
	add	di, cx			;di points to upper-left corner of tile
	stosb				;plot dot; es:[di++]:= al

	inc	cx			;next X position to the right
	dec	si			;next I
	jne	dc20

	popa				;restore al, cx, di
	dec	dx			;next Y
	dec	di			;next J
	jns	dc10

	pop	gs
	pop	fs
	pop	es
	popa
	ret

;-------------------------------------------------------------------------------
;Check if ScnSeg (es) compares with A000h. Display error message if not.
;
Check:	pusha
	push	es

	mov	ah, 0Fh			;if not video mode 13h then error
	int	10h
	cmp	al, 13h
	je	ck10
	or	ErrFlag, 04h		;'Video mode 13h not set'
	jmp	ck80
ck10:
	push	ScnSeg
	pop	es

	push	0A000h
	pop	ds
	xor	di, di
	xor	si, si

;Do a byte-for-byte compare (2 bytes at a time)
	mov	cx, 32000
	repe cmpsw			;cmp ds:[si++], es:[di++]; cx--
	je	ck90			;jump in no nonmatch is found
                     ; ^---- and you say my spelling is bad :-)
	push	cs
	pop	ds

;Display error screen
	or	ErrFlag, 02h		;'Screen error'

	mov	ah, 02h			;cursor to upper left corner
	xor	bx, bx			;page 0
	xor	dx, dx
	int	10h

	mov	ah, 09h			;display error message
	mov	dx, offset ScnErr
	int	21h

;Unhook keyboard interrupt (16h) handler (restore vector)
	push	ds
	lds	dx, dword ptr cs:wOld16	;get original interrupt vector
	mov	ax, 2516h		;restore it
	int	21h
	pop	ds

;Toggle example and entry displays until keystroke
err10:	mov	cx, 9			;delay about 1/2 second
wait00:	push	es			;wait for next system timer interrupt
	push	0
	pop	es
	mov	al, es:[46Ch]		;read system timer byte
wait10:	cmp	al, es:[46Ch]		;wait for it to change
	je	short wait10
	pop	es
	loop	wait00

; ds:si = B800:0
; es:di = ScnSeg:0
	xor	si, si
	xor	di, di
	push	ds
	push	0A000h
	pop	ds
	mov	cx, 32000		; = 64000 bytes
swap10:	mov	ax, [si]		;swap pixels between simulated screen
	mov	dx, es:[di]		; and hardware screen
	mov	[si], dx
	stosw				;es:[di++]:= ax
	add	si, 2
	loop	swap10
	pop	ds

	mov	ah, 01h			;loop until key press
	int	16h
	je	err10
ck80:
	mov	ax, 0003h		;restore text mode
	int	10h

	mov	ah, 4Ch			;terminate entry.com
	int	21h			;(return to tester)
ck90:
	push	cs
	pop	ds

	pop	es
	popa
	ret

ScnErr	db	'Screen error$'

;-------------------------------------------------------------------------------
;Suspend the current coroutine and resume the alternate coroutine
;
Suspnd:	pusha				;save current coroutine's registers
	push	ds
	push	es

	mov	ax, ss
	xchg	cs:sssave, ax		;save current ss and get alternate ss
	mov	ss, ax			;restore alternate coroutine's registers
	xchg	sp, cs:spsave		;(interrupts are momentarily disabled)

	pop	es
	pop	ds
	popa
	ret

;-------------------------------------------------------------------------------

ErrFlag	dw	0			;flag bits for each type of error

sssave	dw	?			;save stack segment for coroutines
spsave	dw	?			;save stack pointer
KeyCode	dw	?			;low byte = ASCII, high byte = scan code
ScnSeg	dw	?			;segment address for simulated screen
TickCnt	dw	12345			;tick count for interrupt 1Ah

msgNo:	db	'No '
msgErr:	db	'Errors Detected', 0Dh, 0Ah, '$'
msg0	db	'Text mode 3 not restored at termination', 0Dh, 0Ah, '$'
msg1	db	'Screen error', 0Dh, 0Ah, '$'
msg2	db	'Video mode 13h not set', 0Dh, 0Ah, '$'
msg3	db	'Final screen not completely blank', 0Dh, 0Ah, '$'
msg4	db	'ENTRY.COM not found', 0Dh, 0Ah, '$'

EntryCom db	'ENTRY.COM', 0

bEpb	dw	0			;segment pointer to environment block
	dw	80h			;offset of command line tail
wCs1	dw	?			;segment of command line tail
	dw	5Ch			;offset of 1st FCB copied into new PSP
wCs2	dw	?			;segment of 1st FCB
	dw	6Ch			;offset of 2nd FCB copied into new PSP
wCs3	dw	?			;segment of 2nd FCB
	dw	$-bEpb


;###############################################################################

;The following example program has been modified to be compatible with the
; tester code above. Modified lines are marked "*** Tester ***".

;EXAMPLE.ASM	11-May-2003		Boreal		loren_blaney@idcomm.com
;Hugi Compo 22: Falling Tetromino Game (not to be confused with Tetris (tm))
;
;Assemble:
; tasm /m
; tlink /t

fieldHeight	equ	25-1		;Playfield dimensions including border
fieldWidth	equ	10+2		; (in character cells)
fieldX	equ	(40-FieldWidth)/2	;Position to display Field on screen
fieldY	equ	(25-FieldHeight)/2 + 1	; (in character cells)

empty	equ	0			;No tile = black
border	equ	52			;Border tile color = light cyan

;Keyboard commands:
leftCh	equ	'j'			;move piece left
rotCh	equ	'k'			;rotate (counterclockwise)
rightCh	equ	'l'			;move right
dropCh	equ	' '			;drop piece (free fall to get points)
startCh	equ	' '			;start another game
quitCh	equ	1Bh			;quit game

;	.model	tiny			;*** Tester ***
;	.code
;	.486
;	org	100h
;
;start:
Example:				;*** End Tester ***

main10:	mov	ax, 0013h		;set 320x200x256 graphic mode
;	int	10h			; and erase screen	*** Tester ***

;Initialize reference screen for tesster
	mov	es, ScnSeg
	xor	di, di
	mov	al, 0
	mov	cx, 64000
	rep stosb			;es:[di++]:= al;  cx--

	push	ds			;restore es
	pop	es
;							 *** End Tester ***

	mov	score, 0		;initialize score

;Set up empty field with borders
	mov	dx, fieldHeight-1	;Y coord (char cells relative to fieldY)
main12:	mov	cx, fieldWidth-1	;X coord (char cells relative to fieldX)
main14:	imul	di, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	add	di, cx
	add	di, offset field

; if I=0 ! I=FieldWidth-1 ! J=FieldHeight-1 then Border else Empty
	mov	al, border
	cmp	cx, 0
	je	main16
	cmp	cx, fieldWidth-1
	je	main16
	cmp	dx, fieldHeight-1
	je	main16
	mov	al, empty
main16:
	stosb				;es:[di++]:= al
	dec	cx
	jns	main14
	dec	dx
	jns	main12

	call	showScore
	call	drawField

;-------------- Game playing loop ---------------
main20:	call	startPiece
	cmp	gameOver, 0		;if GameOver then quit
	jne	main80

	mov	al, pieceC		;display piece in starting position
	call	drawPiece

	mov	ax, score		;Speed:= 10 - Score/256
	shr	ax, 8
	neg	ax
	add	ax, 10
	mov	speed, ax

	mov	drop, 0			;Drop:= false

main27:	call	movePiece		;repeat MovePiece until Blocked
	cmp	blocked, 0
	je	main27

;Copy Piece into Field
	mov	bx, 3			;for N:= 0, 4-1 do
main34:	movsx	cx, [bx+pieceX]		; Field(PieceX(N), PieceY(N)):= PieceC
	movsx	dx, [bx+pieceY]
	imul	di, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	add	di, cx
	add	di, offset field
	mov	al, pieceC
	stosb				;es:[di++]:= al
	dec	bx
	jns	main34

	call	crunchRow
	jmp	main20

main80:	call	getKey			;wait for start key
	cmp	al, startCh
	jne	main80

	jmp	main10			;loop until quitCh

;-------------------------------------------------------------------------------
;Randomly select a piece to fall down the Field

startPiece:
	pusha

	call	random			;P:= random number 0..6
	mov	di, ax
	shl	di, 2			;* 4 to index groups of 4 bytes in tbls

	shl	al, 1			;Set tile's face color
	add	al, 32			;PieceC:= P*2 + 32
	mov	pieceC, al

	mov	gameOver, 0		;GameOver:= false

;Center the Piece at the top of the Field
	mov	bx, 3			;for N:= 0, 4-1 do
sp10:	mov	al, [bx+di+tblX]	;PieceX(N):= TblX(P, N) + FieldWidth/2
	add	al, fieldWidth/2
	mov	[bx+pieceX], al
	mov	al, [bx+di+tblY]	;PieceY(N):= TblY(P, N)
	mov	[bx+pieceY], al

;Will piece overlap already played pieces?
; if Field(PieceX(N), PieceY(N)) # Empty then GameOver:= true
	movsx	dx, [bx+pieceY]
	imul	si, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	mov	al, [bx+pieceX]
	cbw
	add	ax, offset field
	add	si, ax
	lodsb				;al:= ds:[si++]
	test	al, al
	je	sp30
	 mov	gameOver, -1
sp30:
	dec	bx
	jns	sp10

	popa
	ret

;    0         1          2          3           4            5          6
;  [ ][ ]     [+][ ]  [ ][+][ ]  [ ][+]     [ ][ ][+][ ]  [ ][+][ ]  [ ][+][ ]
;  [ ][ ]  [ ][ ]           [ ]     [ ][ ]                [ ]           [ ]
;   blue    purple     violet      pink         red        orange     yellow
;
;All pieces (except the blue block) rotate about the tile marked [+], which is
; the first entry for each piece in the tables below.
;Relative tile coordinates:
tblX	db	0, -1, -1,  0		;0
	db	0,  1, -1,  0		;1
	db	0, -1,  1,  1		;2
	db	0, -1,  0,  1		;3
	db	0, -2, -1,  1		;4
	db	0, -1,  1, -1		;5
	db	0, -1,  1,  0		;6

tblY	db	0,  0,  1,  1		;0
	db	0,  0,  1,  1		;1
	db	0,  0,  0,  1		;2
	db	0,  0,  1,  1		;3
	db	0,  0,  0,  0		;4
	db	0,  0,  0,  1		;5
	db	0,  0,  0,  1		;6

;-------------------------------------------------------------------------------
;Make piece fall while handling keyboard commands
; Outputs: gameOver

movePiece:
	pusha
	mov	bp, speed		;Cnt:= Speed

mp10:	mov	ah, 1			;if KeyHit then
;	int	16h			;*** Tester ***
	call	KeyHit			;*** Tester ***
	je	mp60			;(jump if not)

	mov	bx, 3			;for N:= 0, 4-1 do
mp20:	mov	al, [bx+pieceY]		; PY(N):= PieceY(N)
	mov	[bx+pY], al
	dec	bx
	jns	mp20

	call	getKey			;case Getkey of

	cmp	al, leftCh		;move left?
	jne	mp30			;(jump if not)
	mov	bx, 3			;for N:= 0, 4-1 do
mp25:	mov	al, [bx+pieceX]		; PX(N):= PieceX(N) - 1
	dec	al
	mov	[bx+pX], al
	dec	bx
	jns	mp25

	call	doMove
	jmp	mp60
mp30:
	cmp	al, rightCh		;move right?
	jne	mp40			;(jump if not)
	mov	bx, 3			;for N:= 0, 4-1 do
mp35:	mov	al, [bx+pieceX]		; PX(N):= PieceX(N) + 1
	inc	al
	mov	[bx+pX], al
	dec	bx
	jns	mp35

	call	doMove
	jmp	mp60
mp40:
	cmp	al, rotCh		;rotate?
	jne	mp50			;(jump if not)
	mov	al, pieceC		;if PieceC # 32 (blue block) then
	cmp	al, 32
	je	mp60			;(jump if blue block)

	mov	bx, 3			;for N:= 0, 4-1 do
	xor	si, si
mp45:	mov	al, [bx+pieceX]		;PY(N):= -(PieceX(N)-PieceX(0))
	sub	al, [si+pieceX]
	neg	al
	add	al, [si+pieceY]		; + PieceY(0)
	mov	[bx+pY], al
	mov	al, [bx+pieceY]		;PX(N):= PieceY(N) - PieceY(0)
	sub	al, [si+pieceY]
	add	al, [si+pieceX]		; + PieceX(0)
	mov	[bx+pX], al
	dec	bx
	jns	mp45

	call	doMove
	jmp	mp60
mp50:
	cmp	al, dropCh 		;free fall?
	jne	mp60			;(jump if not)
	mov	drop, -1		;Drop:= true
	xor	bp, bp			;Cnt:= 0
mp60:
	mov	cx, 1			;Delay(1)
	call	delay

	cmp	drop, 0			;loop until Drop
	jne	mp75
	dec	bp			; or Cnt <= 0
	jg	mp10
mp75:
;Move piece down
	mov	bx, 3			;for N:= 0, 4-1 do...
mp80:	mov	al, [bx+pieceX]		; PX(N):= PieceX(N)
	mov	[bx+pX], al
	mov	al, [bx+pieceY]		; PY(N):= PieceY(N) + 1
	inc	al
	mov	[bx+pY], al
	dec	bx
	jns	mp80

	call	doMove

	cmp	drop, 0			;if Drop & not Blocked then
	je	mp90
	cmp	blocked, 0
	jne	mp90
	inc	score			; Score:= Score + 1
	call	showScore
mp90:
	popa
	ret

;-------------------------------------------------------------------------------
;If tenative move is legal (not blocked) then actually do it
; Outputs: blocked

doMove:	pusha

	xor	bp, bp			;Blocked:= false
	mov	bx, 3			;for N:= 0, 4-1 do...
dm10:	mov	al, [bx+pY]		; if PY(N) < 0
	test	al, al			;  or Field(PX(N), PY(N)) # Empty then..
	js	dm15
	cbw
	imul	si, ax, fieldWidth	;si:= field + dx*fieldWidth+cx
	mov	al, [bx+pX]
	cbw
	add	si, ax
	add	si, offset field
	lodsb				;al:= ds:[si++]
	test	al, al
	je	dm20
dm15:	 mov	bp, -1			;Blocked:= true
	 jmp	dm90
dm20:	dec	bx
	jns	dm10

;If not blocked then remove piece from screen
	mov	al, empty		; DrawTile(PieceX(N), PieceY(N), Empty)
	call	drawPiece

; get piece's new position
	mov	bx, 3			;for N:= 0, 4-1 do...
dm40:	mov	al, [bx+pX]		; PieceX(N):= PX(N)
	mov	[bx+pieceX], al
	mov	al, [bx+pY]		; PieceY(N):= PY(N)
	mov	[bx+pieceY], al
	dec	bx
	jns	dm40

; and draw piece at new position
	mov	al, pieceC		;DrawTile(PieceX(N), PieceY(N), PieceC)
	call	drawPiece

dm90:	mov	blocked, bp
	popa
	ret

;-------------------------------------------------------------------------------
;If a horizontal row is full then remove it, and move everything above it down

crunchRow:
	pusha
	mov	bp, 20			;Points:= 20; (pb = points)

	mov	bx, 1			;from the top row+1 to the bottom row...
cr00:					;for J:= 0, FieldHeight-2 do
	imul	si, bx, fieldWidth	;for I:= 1, FieldWidth-2 do
	add	si, offset field+1	; if Field(I, J) = Empty then forget it
	mov	cx, fieldWidth-2
cr05:	lodsb				;al:= ds:[si++]
	test	al, al			;= Empty?
	je	cr80			;jump if a position is empty--forget row
	loop	cr05			;cx--

;Move all tiles above row J down one row
	mov	dx, bx			;for J1:= J downto 1 do
cr10:	imul	di, dx, fieldWidth
	add	di, offset field+1	;(+1 skips left border)
	mov	si, di
	sub	si, fieldWidth		;point to row above
					;  for I:= 1, FieldWidth-2 do
	mov	cx, FieldWidth-2	;    Field(I, J1):= Field(I, J1-1)
	rep movsb			;es:[di++]:= ds:[si++]; cx--
	dec	dx
	jne	cr10

;Clear top row
	mov	al, empty		;for I:= 1, FieldWidth-2 do
	mov	cx, fieldWidth-2	; Field(I, 0):= Empty
	mov	di, offset field+1
	rep stosb			;es:[di++]:= al; cx--

	call	drawField		;show the result

	add	score, bp		;Score:= Score + Points
					;20 + 40 + 80 + 160 => 20, 60, 140, 300
	shl	bp, 1			;Points:= Points << 1
	call	showScore

	mov	cx, speed		;Delay(Speed)
	call	delay
cr80:
	inc	bx
	cmp	bx, fieldHeight-2
	jna	cr00

	popa
	ret

;-------------------------------------------------------------------------------
;Draw all the tiles in the field (which includes the borders)
; Register usage:
;  cx = X coordinate (in character cells) relative to fieldX, fieldY
;  dx = Y coordinate

drawField:
	pusha

	mov	dx, FieldHeight-1
df10:	mov	cx, FieldWidth-1
df20:	imul	si, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	add	si, cx
	add	si, offset field
	lodsb				;al:= ds:[si++]
	call	drawTile		;DrawTile(I, J, Field(I,J))
	dec	cx
	jns	df20
	dec	dx
	jns	df10

	popa
	ret

;-------------------------------------------------------------------------------
;Draw a piece
; Inputs: al = tile face color (pieceC or empty)

drawPiece:
	pusha

	mov	bx, 3			;for N:= 0, 4-1 do
dp10:	movsx	cx, [bx+pieceX]
	movsx	dx, [bx+pieceY]
	call	drawTile		; DrawTile(PieceX(N), PieceY(N), PieceC)
	dec	bx
	jns	dp10

	popa
	ret

;-------------------------------------------------------------------------------
;Draw a tile
; Inputs:
;  al = tile face color
;  cx = X coordinate (in character cells) relative to fieldX, fieldY
;  dx = Y coordinate

drawTile:
	pusha
;Get coordinates (in pixels) relative to upper-left corner of screen
	add	cx, fieldX		;X0:= (X+FieldX)*8
	shl	cx, 3
	add	dx, fieldY		;Y0:= (Y+FieldY)*8
	shl	dx, 3

	mov	bx, 8			;length of side of square
	test	al, al			;if C = Empty then
	jne	dt10
	 call	drawSquare		;DrawSquare(X0, Y0, Empty, 8); Erase
	 jmp	dt30
dt10:					;else
	add	al, 3*24		;dark shadow
	call	drawSquare		;DrawSquare(X0, Y0, C+3*24, 8)

	add	al, 2*24 - 3*24		;light highlight
	dec	bx
	call	drawSquare		;DrawSquare(X0, Y0, C+2*24, 7)

	add	al, -2*24		;regular face color
	dec	bx
	inc	cx
	inc	dx
	call	drawSquare		;DrawSquare(X0+1, Y0+1, C, 6)
dt30:
	popa
	ret

;-------------------------------------------------------------------------------
;Draw a filled square
; Inputs:
;  al = color
;  bx = length of side (in pixels)
;  cx = X coordinate of upper-left corner (in pixels)
;  dx = Y coord

drawSquare:
	pusha
	push	es
;	push	0A000h			;provides access to graphic screen  ***
	push	ScnSeg			;*** Tester ***
	pop	es

	imul	di, dx, 320		;point to upper-left corner of square
	add	di, cx			;di:= Y*320 + X

	mov	dx, bx
ds10:	mov	cx, bx
	rep stosb			;es:[di++]:= al; cx--
	add	di, 320			;move to start of next scan line
	sub	di, bx
	dec	dx
	jne	ds10

	pop	es
	popa
	ret

;-------------------------------------------------------------------------------
;Show 4-digit 'score' with leading zeros centered above playfield

showScore:
	pusha

	mov	ax, score
	mov	bx, 10			;set up divisor
	mov	cx, 4			;for 4 digits...
ss10:	cwd				;dx:= 0
	idiv	bx			;ax:= dx:ax / 10;  dx:= remainder
	add	dx, 0730h		;Screen(di):= Rem(0) + '0' + White<<8
	push	dx
	loop	ss10			;cx--

;*** Tester ***
;	mov	ah, 02h			;set cursor position
;	mov	bh, 0
;	mov	dx, (fieldY-1)*100h + (fieldX+fieldWidth/2)-2
;	int	10h
;
;	mov	cl, 4			;for 4 digit characters...
;ss20:	pop	ax
;	mov	ah, 0Eh			;display character
;	mov	bx, 0007h
;	int	10h			;*** tester ***
;	loop	ss20			;cx--

	mov	cx, ((fieldX+fieldWidth/2)-2)*8
	mov	dx, (fieldY-1)*8
	mov	bx, 4
ss20:	pop	ax
	call	PlotCh
	add	cx, 8
	dec	bx
	jne	ss20
;*** Tester End ***

	popa
	ret

;-------------------------------------------------------------------------------
;Get a keystroke and return it in al

getKey:
	mov	ah, 0
;	int	16h			;*** Tester ***
	call	KeyIn			;*** Tester ***
	cmp	al, quitCh		;quit program?
	jne	gk10			;jump if not
;*** Tester *** The following exit code is never executed
	mov	ax, 0003h		;restore standard text mode
	int	10h
	mov	ah, 4Ch			;return to DOS
	int	21h
gk10:	ret

;-------------------------------------------------------------------------------
;Delay cx 1/18ths of a second

delay:	pusha
	mov	si, cx

	mov	ah, 0			;get tick count
;	int	1Ah			;*** Tester ***
	call	GetTick			;*** Tester ***
del10:	mov	bl, dl			;save LSB in bl
del20:
;	int	1Ah			;wait for tick count to change  ***
	call	GetTick			;*** Tester ***
	cmp	bl, dl
	je	del20
	dec	si
	jne	del10

	popa
	ret

;-------------------------------------------------------------------------------
;Return (predictable) random number 0..6 in ax.

random:	push	dx

	mov	ax, seed		;seed:= seed*9421 + 1
	mul	n9421			;ref: "Master Class Assembly Language"
	inc	ax			; page 840
	mov	seed, ax

	mov	dx, 0	  		;randomNum:= remainder(seed/7)
	div	n7
	mov	ax, dx

	pop	dx
	ret

;-------------------------------------------------------------------------------

seed	dw	12345		;initial seed for random number generator
n9421	dw	9421		;random multiplier
n7	dw	7		;divisor

blocked	dw	?		;flag: piece cannot move in current direction
drop	dw	?		;flag: piece is dropping
gameOver dw	?		;flag: the game is over
score	dw	?		;display accumulated points
speed	dw	?		;speed of play (1/18th of seconds)

field	db	fieldWidth*fieldHeight dup (?)	;playfield, includes the borders

;A piece is an array of 4 tiles, each with an X and Y coordinate
pieceX	db	4 dup (?)	;coordinates of tiles in falling piece
pieceY	db	4 dup (?)	; (in character cells relative to Field)
;Each tile has 3 colors: face, highlighted edge, and shaded edge
pieceC	db	?		;face color of piece
pX	db	4 dup (?)	;tenative new piece position
pY	db	4 dup (?)

cseg	ends
	end	Start
