;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  5.Jul.2003 - 5824 bytes TSR (Terminate and Stay Resident)
;		Falling Tetromino Game
;		 by Asko Vuori		email: askovuori@hotmail.com
;		    Pyh. Katariinantie 14 B 26
;		    20780 Kaarina
;		    Finland
;
; compile:
;	tasm /m tsr_tet
;	tlink /t /x tsr_tet
; hot key:
;	Ctrl+T
; notes:
;	- TSR size is 5824 bytes (code+286 field+4000 old screen+512 stack)
;	- Some programs uses own keyboard handler, which may cause
;	  problems ex. EDIT
;
; Version history:
;   5856 -  9.Jun.2003 by ATV
;   5824 -  5.Jul.2003 by ATV
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;	 Define MSDOS/PCDOS functions.
;
_OUTSTR 	Equ 09h 	;Display string at (Ds:Dx). Dos 1+
_SETIVEC	Equ 25h 	;Set int vector (Al) to Ds:Dx. Dos 1+
_TSR		Equ 31h 	;Terminate and stay resident. Dos 2+
_GETIVEC	Equ 35h 	;Get interupt vector (Es:Bx). Dos 2+
_ALLOC		Equ 48h 	;Allocate memory. Dos 2+
_DEALLOC	Equ 49h 	;Free allocated memory. Dos 2+
_SETBLK 	Equ 4Ah 	;Modify allocated memory blocks. Dos 2+
_EXIT		Equ 4Ch 	;Terminate a process. Dos 2+
KEY_T		Equ 14h
KEY_RSHIFT	Equ 01h
KEY_LSHIFT	Equ 02h
KEY_CTRL	Equ 04h
KEY_ALT 	Equ 08h
SHIFT_FLAG	Equ KEY_CTRL
;
BIOSSeg 	Equ 00040h
BIOSShiftFlag	Equ 00017h	;Keyboard status flag (Db=0040h:0017h)
BIOSVideoMode	Equ 00049h	;Current video mode (Db=0040h:0049h)
BIOSMaxCol	Equ 0004Ah	;Columns on screen (Dw=0040h:004Ah)
BIOSPageOffset	Equ 0004Eh	;Current page start address (Dw=0040h:004Eh)
BIOSMaxRow	Equ 00084h	;Rows on screen -1 (Db=0040h:0084h)
MonoSegment	Equ 0B000h
ColorSegment	Equ 0B800h
IfDef	BigBuf
  ScreenBufSize	Equ 132*43*2	;Big text screen buffer (11k)
Else
  ScreenBufSize	Equ 80*25*2	;Normal text screen buffer (4k)
EndIf

KEYINT		Equ	16h
TIMEINT 	Equ	1Ah

	.Model	Tiny
	.Code
	.186
	.Radix	10

	Org	002Ch
ProgEnv Label	Word
	Org	0100h

EntPt:	Jmp	Init

MultiplexStr	Db  'Tsr_Tet v1.00',0
MultiplexId	Db  00h 		;Multiplex in use (D0h to FFh)
ActiveFlag	Db  00h
TmpSp		Dw  0000h
OldInt2F	Dw  0000h,0000h 	;Old Int 2Fh
OldInt09	Dw  0000h,0000h 	;Old Int 09h
OldStack	Dw  0000h,0000h
OldMode 	Db  00h
VideoPage	Db  00h
OrigCursorPos	Dw  0000h
OldScreenSeg	Dw  0000h
PageOfs 	Dw  0000h
ScreenWords	Dw  0000h

NewInt2F	Proc Far
	Pushf
	Cmp	Ah,Cs:[MultiplexId]	;Is Multiplex call
	Jz	IdCall
	Popf
	Jmp	DWord Ptr Cs:[OldInt2F] ;Jump to original Int 2Fh handler
IdCall: Popf				;Al=function
	Push	Cs			;  00h installation check
	Pop	Es			;    Return: AL = FFh if installed
	Mov	Di,Offset MultiplexStr	;      ES:DI -> ASCIZ "Tsr_Tet v1.00"
	Mov	Al,0FFh 		;  01h to FFh reserved
	IRet
NewInt2F	EndP

NewInt09	Proc Far
	Pushf
	Call	DWord Ptr Cs:[OldInt09] ;Call original Int 09h handler
	Test	Cs:[ActiveFlag],1	;is game active?
	Jnz	I09Exit
	Or	Cs:[ActiveFlag],1
	Mov	Cs:[OldStack+2],Ss	;save current stack frame
	Mov	Cs:[OldStack],Sp
	Cli
	Push	Cs			;stack seg is code seg
	Pop	Ss
	Mov	Sp,Offset TopOfStack-2
	Sti				;Enable interupts.
	Pusha
	Push	Ds
	Push	Es
	Mov	Ax,BIOSSeg
	Mov	Ds,Ax
	Mov	Al,Ds:[BIOSShiftFlag]
	And	Al,SHIFT_FLAG
	Cmp	Al,SHIFT_FLAG
	Jnz	NoShift
	In	Al,60h
	Cmp	Al,KEY_T
	Jnz	NoShift
	Call	SaveScreen
	Call	StartGame
	Call	RestoreScreen
NoShift:Pop	Es
	Pop	Ds
	Popa
	Cli
	Mov	Ss,Cs:[OldStack+2]
	Mov	Sp,Cs:[OldStack]
	Mov	Cs:[ActiveFlag],0
I09Exit:Iret
NewInt09	EndP

SaveScreen:
	Cld
	Push	Cs
	Pop	Ds
	Push	Cs
	Pop	Es
	Mov	Ah,0Fh			;Video - Get current video mode
	Int	10h
	Mov	Di,Offset MonoSegment
	Cmp	Al,7
	Je	SaSc10
	Mov	Di,Offset ColorSegment
	;Cmp	Al,3
	;Jbe	SaSc10
	;Mov	Al,3
SaSc10: Mov	[OldScreenSeg],Di
	Mov	[OldMode],Al
	Mov	[VideoPage],Bh
	Mov	Ah,03h			;Video - Get cursor position and size
	Int	10h
	Mov	[OrigCursorPos],Dx
	Mov	Ax,BIOSSeg
	Mov	Ds,Ax
	Mov	Dx,Ds:[BIOSMaxCol]
	Xor	Ah,Ah
	Mov	Al,Ds:[BIOSMaxRow]
	Inc	Ax
	Mul	Dx
	Cmp	Ax,ScreenBufSize/2
	Jb	SaSc20
	Mov	Ax,ScreenBufSize/2
SaSc20: Mov	Cs:[ScreenWords],Ax
	Mov	Cx,Ax
	Mov	Si,Ds:[BIOSPageOffset]
	Mov	Cs:[PageOfs],Si
	Mov	Ds,Di
	Mov	Di,Offset OldScreen
	Cld
	Rep	Movsw
	Push	Cs
	Pop	Ds
	Ret

RestoreScreen:
	Mov	Al,[OldMode]
	Mov	Ah,0			;Video - Set video mode
	Int	10h
	Mov	Al,[VideoPage]
	Mov	Ah,5			;Video - Select active display page
	Int	10h
	Mov	Es,[OldScreenSeg]
	Mov	Di,[PageOfs]
	Mov	Si,Offset OldScreen
	Mov	Cx,[ScreenWords]
	Cld
	Rep	Movsw
	Mov	Dx,[OrigCursorPos]
	Mov	Bh,[VideoPage]
	Mov	Ah,02h			;Video - Set cursor position
	Int	10h
	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
fieldHeight	Equ	25-1		;Playfield dimensions including border
fieldWidth	Equ	10+1		; (in character cells)
fieldX		Equ	(40-12)/2	;Position to display Field on screen
fieldY		Equ	(25-fieldHeight)/2 + 1

empty		Equ	0		;No tile = black
border		Equ	52+3*24 	;Border tile color = light cyan

;Keyboard commands:
leftCh		Equ	'j'		;move piece left
rotCh 		Equ	'k'		;rotate (counterclockwise)
rightCh		Equ	'l'		;move right
dropCh		Equ	' '		;drop piece (free fall to get points)
startCh 	Equ	' '		;start another game
quitCh		Equ	1Bh		;quit game

StartGame:
	Mov	[TmpSp],Sp
Start:	Mov	Al,border		;Set up empty field with borders
	Mov	Di,Offset exfield
	Mov	Cx,fieldWidth*(fieldHeight+2)
	Push	Di
	Rep	Stosb
	Pop	Di
	Mov	Ax,(fieldHeight+1)*256+empty
Clear:	Mov	Cl,fieldWidth-1
	Rep	Stosb
	Scasb
	Dec	Ah
	Jnz	Clear
	Mov	Al,13h			;set mode 320x200x256
	Int	10h
	Mov	Bp,Offset field
NewPiece:
	Cwd
	Mov	Di,Offset Seed
	Imul	Ax,[Di],24CDh		;Seed = Seed*9421+1
	Inc	Ax
	Stosw				;Di = Seed -> pieceC
	Mov	Cl,7
	Idiv	Cx
	Xchg	Dx,Ax			;randomNum = remainder(Seed/7)
	Stosb				;Di = pieceC -> pieceXY
	Xchg	Bx,Ax
	Mov	Dh,[Bx+Di+tblX_Y-pieceXY];get 7 upper bits
	Mov	Dl,50h			;set 5 lower bits
NePi10: Shr	Dx,03h			;rotate used bits out
	Je	NePi20
	Mov	Al,07h
	And	Ax,Dx
	Aam	04h			;Ah = row, Al = column
	Add	Al,03h			;add start position
	Stosw
	Aad	fieldWidth
	Xchg	Si,Ax			;Si = y*fieldWidth+x
	Cmp	[Bp+Si],Ch		;is place empty?
	Je	NePi10			;yes. check next tile
EndGame:Call	GetKey
	Jne	EndGame 		;loop until start key (or quit to DOS)
	Jmp	Short Start
NePi20:	Call	PutPiece		;put piece in starting position
	Xchg	Dx,Ax
	Sub	Dl,[Bp+Score-field+1]	;Speed = 10-Score/256
MoveDown:
	Test	Dh,Dh			;if dropped then add_score
	Jns	NoDrop  		;jump if not dropped
	Inc	Word Ptr [Bp+Score-field]	;Score = Score+1
	Db	0B8h			;Dummy: Mov Ax,
NoDrop: Mov	Dh,Dl
KeyLoop:Call	DoKeys
	Call	ShowField		;show move with delay
	Dec	Dh
	Jg	KeyLoop 		;loop until Cnt = 0 or Drop
	Mov	Bx,0100h		;Move piece down
	Call	TestPos
	Jcxz	MoveDown		;loop until down
	Xor	Bx,Bx
Crunch:	Inc	Bx
	Imul	Di,Bx,fieldWidth
	Mov	Cl,fieldWidth-1
Cru10:	Cmp	[Bp+Di],Ch		;is field[di] = Empty?
	Je	Cru40			;jump if a position is empty
	Inc	Di
	Loop	Cru10

Cru20:	Mov	Cl,[Bp+Di-FieldWidth]	;Move all tiles above row J
	Mov	[Bp+Di],Cl		; down one row
	Dec	Di
	Jnz	Cru20
	Shl	Ax,1			;Points = Points<<1
	Add	[Bp+Score-field],Ax	;Score = Score+Points
					;20->40->80->160 => 20->60->140->300
	Mov	Cl,Dl			;speed of play (1/18th of seconds)
Cru30:	Call	ShowField		;show move with delay
	Loop	Cru30

Cru40:	Cmp	Bl,fieldHeight-2	;Is last row
	Jb	Crunch
	Jmp	NewPiece

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoKeys:	Mov	Ah,01h			;Keyboard - Check for keystroke
	Int	KEYINT
	Je	DoRet			;jump if no keypressed
	Call	GetKey			;space key is tested
	Jne	DoKe20  		;free fall? (jump if not)
	Mov	Dh,-1			;It's dropped (Cnt < 0)
DoKe20: Cmp	Al,'6'			;move right?
	Ja	DoKe30
	Sub	Al,'4'-leftCh		;456 -> JKL (+6 bytes)
DoKe30:	Sub	Al,leftCh		;sub left key?
	Cmp	Al,3			;above right key?
	Jnb	DoRet			;jump if not in range 6Ah..6Ch
	Cbw				;need 3 successive ascii chars
	Dec	Ax			;rotate?
	Xchg	Bx,Ax			;Bl = direction
;Test if move is legal (not blocked) then actually do it
TestPos:Call	PutPiece		;remove piece from field
	Mov	Di,Si
	Mov	Cl,4
TePo10: Lodsw
	Test	Bx,Bx			;Is Bx with move info?
	Jnz	TePo20			;jump if not rotate
	Cmp	[Di+pieceC-pieceXY],Ch	;if PieceC # 32 then
	Je	PutPiece		;jump if blue block
	Xchg	Al,Ah			;newX(N)= PieceY(N)+PieceX(0)-PieceY(0)
	Neg	Ah			;newY(N)=-PieceX(N)+PieceX(0)+PieceY(0)
	Add	Ax,[Di]
	Sub	Al,[Di+1]
	Add	Ah,[Di]
TePo20:	Add	Ax,Bx			;newXY(N)= PieceXY(N)+dirXY
	Js	PutPiece		;out of field, can't rotate
	Mov	[Si+06h],Ax		;save newXY(N)
	Push	Di
	Call	fieldPos		;Di = y*fieldWidth+x
	Cmp	[Bp+Di],Ch		;is field[di] = free?
	Pop	Di
	Jne	PutPiece
	Loop	TePo10
	Movsw				;PieceXY(N) = newXY(N)
	Movsw
	Movsw
	Movsw

PutPiece:
	Mov	Si,Offset pieceC-1	;Put a piece at new position
	Lodsw				;Si = pieceC-1 -> pieceXY
	Mov	Al,32+3*24		;set tile's dark color = P*2+32+72
	Aad	02h
	Pusha
	Mov	Cl,4
PutPi10:Xchg	Di,Ax
	Lodsw
	Call	fieldPos		;Di = y*fieldWidth+x
	Xor	[Bp+Di],Al		;field[di] = al
	Loop	PutPi10
	Popa				;if Cx <> 0 then Blocked = true
	Mov	Al,10			;Used: Speed & Score
DoRet:	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
fieldPos:
	Push	Bx
	Mov	Bx,fieldWidth
	Xchg	Bl,Al
	Imul	Ah
	Xchg	Di,Ax
	Add	Di,Bx			;Di = y*fieldWidth+x
	Pop	Bx
	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Draw all the tiles in the field (which includes the borders)
;Show 4-digit 'score' with leading zeros centered above playfield
ShowField:
	Pusha
	Push	0A000h
	Pop	Es
	Mov	Ax,[Bp+Score-field]
	Mov	Si,((fieldX+12/2)+1)*8
	Mov	Bx,10
	Mov	Cl,4
ShFi10: Cwd
	Div	Bx

	Pusha
	Xchg	Dx,Ax
	Add	Al,'0'
	Cwd
	Mov	Ds,Dx
	Lds	Bx,Ds:[43h*4]		;get font table location
	Shl	Ax,3			;* font height
	Add	Bx,Ax
	Mov	Cl,8			;for J:= 0, 8-1 do
dc10:	Mov	Ah,Ds:[Bx]		;Get byte from BIOS's font table
	Imul	Di,Dx,320
	Add	Di,Si			;Di = Y*320+X
	Mov	Ch,8			;for each bit in the Byte...
dc20:	Shl	Ah,1			;MSB is on the left side
	Db	0D6h			;Setalc
	And	Al,7			;if Byte & $80 then white else black
	Stosb				;plot dot; es:[di++]:= al
	Dec	Ch			;next I
	Jnz	dc20
	Inc	Bx			;update char row
	Inc	Dx			;next Y
	Loop	dc10
	Popa

	Sub	Si,8			;update char position
	Loop	ShFi10
	Push	Cs
	Pop	Ds

	Mov	Dx,320
	Mov	Si,Offset field+(fieldHeight-1)*fieldWidth-1
	Mov	Di,((fieldHeight-1+fieldY)*320+fieldX)*8-320
ShFi30: Mov	Cl,12
ShFi40: Lodsb
	Cmp	Al,Es:[Di+327]		;is already displayed?
	Je	ShFi80			;yes. jump over
	Pusha				;drawTile
	Mov	Cl,8
	Mov	Ah,74h
ShFi50: Mov	Bx,Cx			;DrawSquare(Di, Al, Cx)
	Push	Di
ShFi60:	Add	Di,Dx
	Pusha
	Rep	Stosb
	Popa
	Dec	Bx
	Jne	ShFi60
	Pop	Di
	Dec	Cx
	Add	Ah,Ah			;74h -> -24 -> -48 -> -96
	Jnc	ShFi70
	Adc	Di,Dx			;face color position
ShFi70: Add	Al,Ah
	Jc	ShFi50
	Popa
ShFi80: Add	Di,8
	Loop	ShFi40
	Sub	Si,11+12		;move to start of next scan line
	Sub	Di,(320+10+2)*8
	Jnc	ShFi30
	Push	Cs
	Pop	Es

;Delay Cx 1/18ths of a second
	Int	TIMEINT 		;Cx:Dx = ticks
	Mov	Bl,Dl
Del10:	Int	TIMEINT
	Cmp	Bl,Dl
	Je	Del10			;loop until time change
	Popa
TestSpc:Cmp	Al,startCh		;drop piece or start another game
	Ret

GetKey: Mov	Ah,00h			;Keyboard - Get keystroke
	Int	KEYINT
	Dec	Ah			;if ESC quit program?
	Jne	TestSpc			;jump if not
	Mov	Sp,[TmpSp]
	Ret				;Terminate program

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;    0	       1	  2	     3		 4	      5 	 6
;  [ ][ ]     [+][ ]  [ ][+][ ]  [ ][+]     [ ][ ][+][ ]  [ ][+][ ]  [ ][+][ ]
;  [ ][ ]  [ ][ ]	    [ ]     [ ][ ]		  [ ]		[ ]
;   blue    purple     violet	   pink 	red	   orange     yellow
;
;All pieces (except the blue block) rotate about the tile marked [+],
; which is the first entry for each piece in the tables below.
;Relative tile coordinates:
; 4*3bits = tblX_Y[piece]*256 + (low byte is always 50h)
; 3bits group (Ypos = high bit, Xpos = 2 low bits, +bias 2)
;		x3332221,11000xxx
;		    lo_b=01010000
tblX_Y	Db	00011101b	;0 - (0,1),(1,2),(1,1),(0,2)
	Db	00111101b	;1 - (0,3),(1,2),(1,1),(0,2)
	Db	00111110b	;2 - (0,3),(1,3),(0,1),(0,2)
	Db	01101110b	;3 - (1,2),(1,3),(0,1),(0,2)
	Db	00110000b	;4 - (0,3),(0,0),(0,1),(0,2)
	Db	00010111b	;5 - (0,1),(0,3),(1,1),(0,2)
	Db	00111100b	;6 - (0,3),(1,2),(0,1),(0,2)

Seed	Dw	12345		;initial seed for random number generator

;Each tile has 3 colors: face, highlighted edge, and shaded edge
pieceC	Label	Byte		;dark color of piece
;A piece is an array of 4 tiles, each with an X and Y coordinate
pieceXY Equ	pieceC + 1	; (in character cells relative to Field)
newXY	Equ	pieceXY + 8	;coordinates of tiles in falling piece
				;tenative new piece position
exfield Equ	newXY + 8	;extra field for set score to 0
emptyLn Equ	exfield + fieldWidth	;empty line, includes the borders
Score	Equ	emptyLn - 8	;display accumulated points
field	Equ	emptyLn + fieldWidth	;playfield, includes the borders

OldScreen	Equ	field + fieldWidth*fieldHeight ;save screen
StackSize	Equ	512
StartOfStack	Equ	OldScreen + ScreenBufSize
TopOfStack	Equ	StartOfStack + StackSize

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Init	Proc Near
	Mov	Ax,_GETIVEC Shl 8 + 2Fh ;Get interupt vector (ES:BX). Dos 2+
	Int	21h
	Mov	[OldInt2F],Bx
	Mov	[OldInt2F+2],Es
	Mov	Ax,_GETIVEC Shl 8 + 09h ;Get interupt vector (ES:BX). Dos 2+
	Int	21h
	Mov	[OldInt09],Bx
	Mov	[OldInt09+2],Es

	Call	IsAlreadyInMemory
	Jnc	Install
TryUnInstall:
	Mov	Dx,Offset txtNotUnInst
	Mov	Ax,Es
	Cmp	Ax,[OldInt2F+2]
	Jnz	ErrTxt
	Cmp	[OldInt2F],Offset NewInt2F
	Jnz	ErrTxt
	Cmp	Ax,[OldInt09+2]
	Jnz	ErrTxt
	Cmp	[OldInt09],Offset NewInt09
	Jnz	ErrTxt

	Push	Ds
	Lds	Dx,DWord Ptr Es:[OldInt2F]	;Get original Int 2Fh
	Mov	Ax,_SETIVEC Shl 8 + 2Fh ;Set int vector (AL) to DS:DX. Dos 1+
	Int	21h
	Lds	Dx,DWord Ptr Es:[OldInt09]	;Get original Int 09h
	Mov	Ax,_SETIVEC Shl 8 + 09h ;Set int vector (AL) to DS:DX. Dos 1+
	Int	21h
	Pop	Ds
	Mov	Es,[AllocMemSeg]
	Mov	Ah,_DEALLOC		;Free allocated memory. Dos 2+
	Int	21h
	Mov	Dx,Offset txtNotFree
	Jc	ErrTxt
	Mov	Dx,Offset txtUnInstall
	Mov	Ah,_OUTSTR		;Display string at (DS:DX). Dos 1+
	Int	21h
	Mov	Ax,_EXIT Shl 8 + 00h	;Terminate a process. Dos 2+
	Int	21h

ErrTxt: Mov	Ah,_OUTSTR	;Display string at (DS:DX). Dos 1+
	Int	21h
	Mov	Ax,_EXIT Shl 8 + 01h	;Terminate a process. Dos 2+
	Int	21h

Install:
	Mov	Dx,Offset txtNotInstall
	Cmp	[MultiplexId],00h
	Jz	ErrTxt
	Mov	Dx,Offset txtInstalled
	Mov	Ah,_OUTSTR		;Display string at (DS:DX). Dos 1+
	Int	21h
	Mov	Dx,Offset NewInt2F
	Mov	Ax,_SETIVEC Shl 8 + 2Fh ;Set int vector (AL) to DS:DX. Dos 1+
	Int	21h
	Mov	Dx,Offset NewInt09
	Mov	Ax,_SETIVEC Shl 8 + 09h ;Set int vector (AL) to DS:DX. Dos 1+
	Int	21h
	Mov	Es,[ProgEnv]		;Get enveroment segment
	Mov	Ah,_DEALLOC		;Free allocated memory. Dos 2+
	Int	21h
	Mov	Dx,(TopOfStack - EntPt + 010Fh) / 0010h
	Mov	Ax,_TSR Shl 8 + 00h	;Terminate and stay resident. Dos 2+
	Int	21h

IsAlreadyInMemory	Proc Near
	Mov	[MultiplexId],0D0h
IsAl1:	Mov	Al,00h			;Installation check
	Mov	Ah,[MultiplexId]
	Int	2Fh
	Push	Cs			;Set DS segment, just for safe
	Pop	Ds
	Cmp	Al,00h
	Jz	ItsFree
	Cmp	Al,0FFh
	Jnz	NextId
	Mov	Cx,Offset MultiplexId-MultiplexStr-1  ;Check 13 bytes
	Mov	Si,Offset MultiplexStr
	Mov	[AllocMemSeg],Es
	Cld
	Rep	Cmpsb
	Stc				;If found set carry
	Jz	IsAlRet
NextId: Inc	[MultiplexId]
	Jnz	IsAl1			;Set MultiplexId=0
ItsFree:Clc				;If not found clear carry
IsAlRet:Ret
IsAlreadyInMemory	EndP
;
Init	EndP

txtInstalled	Db  'Tsr_Tet is installed.'
		Db  ' To UnInstall type TSR_TET again.',0Dh,0Ah
		Db  'Hot Key: Ctrl+T',0Dh,0Ah,'$'
txtNotUnInst	Db  0Dh,0Ah,'Tsr_Tet: Can',27h,'t UnInstall.',0Dh,0Ah,'$'
txtNotFree	Db  0Dh,0Ah,'Tsr_Tet: Can',27h,'t free memory.',0Dh,0Ah,'$'
txtUnInstall	Db  0Dh,0Ah,'Tsr_Tet UnInstalled.',0Dh,0Ah,'$'
txtNotInstall	Db  0Dh,0Ah,'Tsr_Tet: Can',27h,'t install.',0Dh,0Ah,'$'
		Dw  Offset pieceC-StartGame ;Just to see how big game is
AllocMemSeg	Dw  ?

End	EntPt


--------U-2FD000-----------------------------
INT 2F - Tsr_Tet v1.00+ - INSTALLATION CHECK
	Ax = D000h
Return: Al = FFh If installed
	    Es:Di -> ASCIZ signature "Tsr_Tet v1.00"
Program: TSR_TET.COM is a TSR game - Falling Tetromino Game
Author: Asko Vuori, Finland
HotKey: Ctrl+T
Range:	Ah=D0h to Ah=FFh, selected by scanning for first free multiplex number
