;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 15.Jul.2003 - 363 bytes Entry for the Hugi Size Coding Compo #22
;		 by Asko Vuori		email: askovuori@hotmail.com
;		    Pyh. Katariinantie 14 B 26
;		    20780 Kaarina
;		    Finland
;
; Falling Tetromino Game (not to be confused with Tetris (tm))
;
; compile:
;	tasm /m entry
;	tlink /t /x entry
; tasm options:
;	/dFLICKER	- flicker free display (+7 bytes)
;	/dTESTERX	- Replaced keyboard vector 16h with 60h and system
;			  tick count vector 1Ah with 61h (ONLY FOR TESTERX)
;
; Version history:
;   496 - 23.May.2003 by ATV
;   382 -  4.Jun.2003 by ATV
;   365 -  5.Jul.2003 by ATV
;   363 - 15.Jul.2003 by ATV
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
fieldHeight	Equ	25-1		;Playfield dimensions including border
fieldWidth	Equ	256
fieldX		Equ	(40-12)/2	;Position to display Field on screen
fieldY		Equ	(25-fieldHeight)/2 + 1

empty		Equ	0		;No tile = black
border		Equ	52+3*24 	;Border tile color = light cyan

;Keyboard commands:
IfDef	NUMKEYS				;need 3 successive ascii chars
  leftCh	Equ	'4'		;move piece left
  rotCh 	Equ	'5'		;rotate (counterclockwise)
  rightCh	Equ	'6'		;move right
Else
  leftCh	Equ	'j'		;move piece left
  rotCh 	Equ	'k'		;rotate (counterclockwise)
  rightCh	Equ	'l'		;move right
EndIf
dropCh		Equ	' '		;drop piece (free fall to get points)
startCh 	Equ	' '		;start another game
quitCh		Equ	1Bh		;quit game

IfDef	TESTERX
  KEYINT	Equ	60h
  TIMEINT	Equ	61h
Else
  KEYINT	Equ	16h
  TIMEINT	Equ	1Ah
EndIf

	.Model	Tiny
	.Code
	.186
	.Radix	10
	Org	100h			;Assume: Al=0, Ch=0, Cld

Start:	Mov	Bp,Offset field 	;Also screen segment
	Mov	Di,Offset emptyLn
	Mov	Ah,(fieldHeight*4-1)	;*256+empty
Clear:	Mov	Cl,10			;(10 emptys + 118 borders)*2*height
	Xor	Cl,Al			;10 xor 0 = 10, 10 xor 7Ch = 76h (118)
	Rep	Stosb			;Two 10*24 fields side by side
	Xor	Al,border		;second field has only Score
	Dec	Ah			;in [Bp-78h]
	Jne	Clear
	Mov	Ch,1
	Rep	Stosb			;draw bottom line
	Mov	Al,13h			;set mode 320x200x256
	Int	10h
NewPiece:
	Cwd
	Mov	Di,Offset Seed
	Imul	Ax,[Di],24CDh		;Seed = Seed*9421+1
	Inc	Ax
	Stosw				;Di = Seed -> pieceC
IfDef	FLICKER
	Mov	Cl,7
	Idiv	Cx
Else
	Idiv	Word Ptr [Di+Seven-pieceC]
EndIf
	Xchg	Dx,Ax			;randomNum = remainder(Seed/7)
	Stosb				;Di = pieceC -> pieceXY
	Xchg	Bx,Ax
	Mov	Ah,[Bx+Di+tblX_Y-pieceXY];get 7 upper bits
	Mov	Al,50h			;set 5 lower bits
NePi10: Shr	Ax,03h			;rotate used bits out
	Je	NePi20
	Mov	Si,Ax
	And	Al,7
	Aam	04h			;Ah = row, Al = column
	Add	Al,03h			;add start position
	Stosw
	Xchg	Si,Ax			;Si = y*fieldWidth+x , Al <> 20h
	Mov	Cl,[Bp+Si]		;is place empty?
	Jcxz	NePi10			;yes. check next tile

TestSpc:Sub	Al,startCh		;drop piece or start another game
	Jcxz	DoKe10			;jump if game is running
	Je	Start   		;loop until start key (or quit to DOS)
GetKey: Mov	Ah,00h			;Keyboard - Get keystroke
	Int	KEYINT
	Dec	Ah			;if ESC quit program?
	Jne	TestSpc			;jump if not
	Mov	Al,03h			;Set text mode 3
	Int	10h
	Int	20h			;Terminate program

NePi20:	Call	PutPiece		;put piece in starting position
	Xchg	Dx,Ax
	Sub	Dl,[Bp+Score-field+1]	;Speed = 10-Score/256
DownLoop:
	Test	Dh,Dh			;if dropped then add_score
	Jns	NoDrop  		;jump if not dropped
	Inc	Word Ptr [Bp+Score-field]	;Score = Score+1
	Org	$-1			;Score offset -78h = 88h ;-)
NoDrop: Db	88h,0D6h		;Mov Dh,Dl (+hidden dummy Setalc)
KeyLoop:Call	KeyShowField		;show move with delay
	Dec	Dh
	Jg	KeyLoop 		;loop until Cnt = 0 or Drop
	Mov	Bx,0100h		;Move piece down
	Call	TestPos
	Jcxz	DownLoop		;loop until down
Crunch:	Mov	Di,Bx
	Mov	Cl,0Ah
Cru10:	Cmp	[Bp+Di],Ch		;is field[Di] = Empty?
	Je	Cru40			;jump if a position is empty
	Inc	Di
	Loop	Cru10
Cru20:	Mov	Cl,[Bp+Di-fieldWidth]	;Move all tiles above current row
	Mov	[Bp+Di],Cl		; down one row
	Dec	Di
	Jne	Cru20
	Shl	Ax,1			;Points = Points<<1
	Add	[Bp+Score-field],Ax	;Score = Score+Points
					;20->40->80->160 => 20->60->140->300
	Mov	Cl,Dl			;speed of play (1/18th of seconds)
	Call	ShowField		;show move with delay

Cru40:	Inc	Bh
	Cmp	Bh,fieldHeight-1	;Is last row
	Jnc	NewPiece
	Jmp	Crunch

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoKe10:	Jne	DoKe20  		;free fall? (jump if not)
	Mov	Dh,-1			;It's dropped (Cnt < 0)
DoKe20: Sub	Al,leftCh-startCh	;sub left key?
	Cmp	Al,3			;above right key?
	Jnb	DoRet			;jump if not in range 6Ah..6Ch
	Cbw
	Dec	Ax			;rotate?
	Xchg	Bx,Ax			;Bl = direction
;Test if move is legal (not blocked) then actually do it
TestPos:Call	PutPiece		;remove piece from field
	Mov	Di,Si
	Mov	Cl,4
TePo10: Lodsw
	Test	Bx,Bx			;Is Bx with move info?
	Jnz	TePo20			;jump if not rotate
	Cmp	[Di+pieceC-pieceXY],Ch	;if PieceC # 32 then
	Je	PutPiece		;jump if blue block
	Xchg	Al,Ah			;newX(N)= PieceY(N)+PieceX(0)-PieceY(0)
	Neg	Ah			;newY(N)=-PieceX(N)+PieceX(0)+PieceY(0)
	Add	Ax,[Di]
	Sub	Al,[Di+1]
	Add	Ah,[Di]
	Js	PutPiece		;out of field, can't rotate
TePo20:	Add	Ax,Bx			;newXY(N)= PieceXY(N)+dirXY
	Mov	[Si+06h],Ax		;save newXY(N)
	Xchg	Di,Ax			;Di = y*fieldWidth+x
	Cmp	[Bp+Di],Ch		;is field[Di] = free?
	Xchg	Di,Ax
	Jne	PutPiece
	Loop	TePo10
	Movsw				;PieceXY(N) = newXY(N)
	Movsw
	Movsw
	Movsw

PutPiece:
	Mov	Si,Offset pieceC-1	;Put a piece at new position
	Lodsw				;Si = pieceC-1 -> pieceXY
	Mov	Al,32+3*24		;set tile's dark color = P*2+32+72
	Aad	02h
	Pusha
	Mov	Cl,4
PutPi10:Xchg	Di,Ax
	Lodsw
	Xchg	Di,Ax			;Di = y*fieldWidth+x
	Xor	[Bp+Di],Al		;field[Di] = Al
	Loop	PutPi10
	Popa				;if Cx <> 0 then Blocked = true
	Mov	Al,10			;Used: Speed & Score
DoRet:	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
KeyShowField:
	Mov	Ah,01h			;Keyboard - Check for keystroke
	Int	KEYINT
	Je	KeSh10			;jump if no keypressed
	Call	GetKey			;space key is tested
KeSh10: Mov	Cl,1

;Draw all the tiles in the field (which includes the borders)
;Show 4-digit 'score' with leading zeros centered above playfield
ShowField:				;show move with delay
	Pusha
	Mov	Ax,[Bp+Score-field]
	Mov	Bx,10
	Mov	Cl,4
ShFi10: Cwd
	Div	Bx
	Push	Dx
	Loop	ShFi10
	Mov	Dl,12h
	Mov	Ah,02h			;Video - Set cursor position
	Int	10h
	Mov	Cl,4
ShFi20: Pop	Ax
	;Add	Ax,0E30h		;display character + '0'
	;Mov	Bl,07h			;White
	;Int	10h
	Add	Al,'0'
	Int	29h			;Dos - Fast console output
	Loop	ShFi20

	Mov	Si,Offset field+(fieldHeight-1)*fieldWidth+010Bh
	Mov	Di,((fieldHeight-1)*320+fieldX)*8
ShFi30: Mov	Dx,010Ch
	Sub	Si,Dx			;move to start of next scan line
ShFi40: Lodsb
	Mov	Cl,8
IfDef	FLICKER
	Mov	Es,Bp
	Cmp	Al,Es:[Di+7]		;is already displayed?
	Je	ShFi80			;yes. jump over
EndIf
	Pusha				;drawTile (Ah=0)
	Mov	Dl,40h
	Mov	Ah,74h
ShFi50: Mov	Bx,Cx			;DrawSquare(Di, Al, Cx)
IfNDef	FLICKER
	Mov	Es,Bp
EndIf
	Push	Di
ShFi60: Pusha
	Rep	Stosb
	Popa
	Add	Di,Dx
	Dec	Bx
	Jne	ShFi60
	Pop	Di
	Dec	Cx
IfNDef	FLICKER
	Push	Cs
Seven:	Pop	Es
EndIf
	Db	00h,0E4h		;Add Ah,Ah = 74h -> -24 -> -48 -> -96
	Jnc	ShFi70
	Adc	Di,Dx			;face color position
ShFi70: Add	Al,Ah
	Jc	ShFi50
	Popa
ShFi80: Add	Di,Cx
	Dec	Dl
	Jnz	ShFi40
	Sub	Di,(320+10+2)*8
	Jnc	ShFi30
IfDef	FLICKER
	Push	Cs
	Pop	Es
EndIf

;Delay 1/18ths of a second		;Ah=0 Time - Get system time
	Int	TIMEINT 		;Cx:Dx = ticks
	Mov	Bl,Dl
Del10:	Int	TIMEINT
	Cmp	Bl,Dl
	Je	Del10			;loop until time change
	Popa
	Loop	ShowField
	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;    0	       1	  2	     3		 4	      5 	 6
;  [ ][ ]     [+][ ]  [ ][+][ ]  [ ][+]     [ ][ ][+][ ]  [ ][+][ ]  [ ][+][ ]
;  [ ][ ]  [ ][ ]	    [ ]     [ ][ ]		  [ ]		[ ]
;   blue    purple     violet	   pink 	red	   orange     yellow
;
;All pieces (except the blue block) rotate about the tile marked [+],
; which is the last entry for each piece in the tables below.
;Relative tile coordinates:
; 4*3bits = tblX_Y[piece]*256 + (low byte is always 50h)
; 3bits group (Ypos = high bit, Xpos = 2 low bits, +bias 2)
;		x3332221,11000xxx
;		    lo_b=01010000
tblX_Y	Db	00011101b	;0 - (0,1),(1,2),(1,1),(0,2)
	Db	00111101b	;1 - (0,3),(1,2),(1,1),(0,2)
	Db	00111110b	;2 - (0,3),(1,3),(0,1),(0,2)
	Db	01101110b	;3 - (1,2),(1,3),(0,1),(0,2)
	Db	00110000b	;4 - (0,3),(0,0),(0,1),(0,2)
	Db	00010111b	;5 - (0,1),(0,3),(1,1),(0,2)
	Db	00111100b	;6 - (0,3),(1,2),(0,1),(0,2)

Seed	Dw	12345		;initial seed for random number generator

;Each tile has 3 colors: face, highlighted edge, and shaded edge
pieceC	Db	?		;dark color of piece
;A piece is an array of 4 tiles, each with an X and Y coordinate
pieceXY Dw	4 Dup (?)	; (in character cells relative to Field)
newXY	Dw	4 Dup (?)	;coordinates of tiles in falling piece
				;tenative new piece position
field	Equ	0A000h+(fieldY*8*320)/16	;playfield, includes the borders
Score	Equ	field-120		;display accumulated points score=0
emptyLn Equ	field-fieldWidth	;empty line, includes the borders

End	Start
