{ Tic-tac-toe implementation that evaluates boards with recursion. }

program demo_tictactoe;
{$X+}

uses crt;

type
  player = (Naughts, Crosses, None);
  board = array[Naughts..Crosses] of word;

{------------------------------------}
{ Look on b for three pegs in a line }
{------------------------------------}

function won(var b: board): player;
const
  wins: array[1..8] of word = ($1C0, $38, $7, $124, $92, $49, $111, $54);
var
  i: word;
begin
  won := None;
  for i := 1 to 8 do
    if (b[Naughts] and wins[i]) = wins[i] then
      won := Naughts
    else if (b[Crosses] and wins[i]) = wins[i] then
      won := Crosses;
end;

function value(var b: board; var best_move: word; who: player): integer;
var
  new_board: board;
  position, dummy: word;
  best, recursive: integer;
  them, winner: player;
begin
  {------------------------------------------}
  { Check if somebody placed three in a line }
  {------------------------------------------}

  winner := won(b);
  best_move := 0;
  if winner <> None then
    begin
      if winner = who then value := 100 else value := -100;
      exit;
    end;

  {------------------------------------}
  { Recursively explore the game tree. }
  {------------------------------------}

  value := 0;
  if who = Naughts then
    them := Crosses
  else
    them := Naughts;

  best := -10000;
  position := $100;
  while position > 0 do begin
    if (position and (b[Naughts] or b[Crosses])) = 0 then
      begin
        new_board[who] := b[who] or position;
        new_board[them] := b[them];

        {-----------------------------------------------------------------}
        { Call ourselves recursively to find the other player's best move }
        {-----------------------------------------------------------------}

        recursive := -value (new_board, dummy, them);
    
	{ Subtract the sign, a 3-move victory is worse than a 1-move victory. }
        if recursive < 0 then inc (recursive);
        if recursive > 0 then dec (recursive);

        {------------------------------------------------}
        { Check if the move is better than the last one. }
        {------------------------------------------------}

        if (best < recursive) or (winner = who) then
          begin
            best_move := position;
            best := recursive;
            value := best;
          end

      end;

    position := position shr 1
  end;
end;

procedure field;
  procedure print_line (n: integer; c1, c2: char);
  var
    s: string[11];
    i: integer;
  begin
    s[0] := #11;
    for i := 1 to 11 do
      if (i and 3) = 0 then
        s[i] := c2
      else
        s[i] := c1;

    gotoxy (16,n);
    write (s);
  end;

begin
  clrscr;
  print_line (11, ' ', '');
  print_line (12, '', '');
  print_line (13, ' ', '');
  print_line (14, '', '');
  print_line (15, ' ', '');
end;

procedure put_sign (position: word; who: player);
var
  x,y: integer;
begin
  if position = 0 then exit;

  y := 11;
  x := 17;
  while position < $100 do begin
    if x = 25 then
      begin
        x := 17;
        inc(y, 2)
      end
    else
      inc (x, 4);

    position := position shl 1;
  end;

  gotoxy (x, y);
  if who = Naughts then
    write ('O')
  else
    write ('X')
end;

{------------------------------------------------------}
{ Plays a game and returns whether to continue or not. }
{------------------------------------------------------}

function play_tictactoe: boolean;
var
  b: board;
  position: word;
  ch: char;
  winner: player;

  procedure pick_move;
  const
    moves:array['1'..'9'] of word = ($4,$2,$1,$20,$10,$8,$100,$80,$40);
  begin
    position := 0;
    repeat
      ch := readkey;
      if ch = #0 then
        readkey
      else if (ch in ['1'..'9']) then begin
        position := moves[ch];
        if (position and (b[Naughts] or b[Crosses])) = 0 then exit;
      end else if (ch = '0') and ((b[Naughts] or b[Crosses]) = 0) then
        exit
      else if ch = #27 then begin
        exit;
      end;
    until false;
  end;

  function show_winner: boolean;
  begin
    gotoxy(18,21);
    if winner = None then
      write ('A draw!')
    else if winner = Crosses then
      write ('X wins?')
    else
      write ('O wins!');

    ch := readkey;
    if ch = #0 then readkey;
    asm MOV AX,3; INT 10H; end;
    show_winner := ch <> #27;
  end;

begin
  asm MOV AX,1; INT 10H;
    MOV AX, 100h; MOV CX, 2000H; INT 10H end;
  field;
  b[Naughts] := 0;
  b[Crosses] := 0;
  while (b[Naughts] or b[Crosses]) <> $1FF do begin
    pick_move;
    if ch = #27 then begin
      play_tictactoe := false;
      asm MOV AX,3; INT 10H; end;
      exit;
    end;

    b[Crosses] := b[Crosses] or position;
    put_sign (position, Crosses);
    winner := won(b);
    if winner <> None then begin
      play_tictactoe := show_winner;
      exit;
    end;

    { Make things much faster by not doing the search for the first move,
      which is quite expensive. }
    if b[Crosses] = 0 then
      position := $100
    else
      value (b, position, Naughts);

    b[Naughts] := b[Naughts] or position;
    put_sign (position, Naughts);
    winner := won(b);
    if winner <> None then begin
      play_tictactoe := show_winner;
      exit;
    end;
  end;

  play_tictactoe := show_winner;
end;
    
begin
  repeat until not play_tictactoe;
end.