;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  8.Dec.2002 - 139 bytes Entry for the Hugi Size Coding Compo #20
;               by Asko Vuori
;                  Pyh. Katariinantie 14 B 26
;                  20780 Kaarina
;                  Finland
; compile:
;       tasm entry
;       tlink /t /x entry
;
; Version history:
;   152 bytes - 20.Nov.2002 by ATV
;   139 bytes -  8.Dec.2002 by ATV
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; C=Y/100                                       ;Range: 15..40
; N=Y%19                                        ;Range: 0..18
; K=(C-17)/25                                   ;Range: 0
; I=C-C/4-(C-K)/3+19*N+15                       ;Range: 22..374
; I=I%30                                        ;Range: 0..29
; I=I-(I/28)*(1-(29/(I+1))*((21-N)/11))         ;Range: 0..28
; J=Y+Y/4+I+2-C+C/4                             ;Range: 1968..5095+I
; L=I-J%7                                       ;Range: ?..28
; M=3+(L+40)/44                                 ;Range: 3..4
; D=L+28-31*(M/4)
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
                    .Model    Tiny
                    .Radix    10
                    .186
                    .Code
                    Org       0100h             ;Assume: Bh=0,Ch=0,Cld
Start:
                    Db        0Dh,0Ah,'$'       ;Or Ax,240Ah
NewYear:            Xor       Di,Di             ;Initial year value

STDIN:              Mov       Ah,08h            ;Read line from STDIN
                    Int       21h
                    Cmp       Al,0Dh            ;Loop until 0Dh
                    Jb        STDIN
                    Xchg      Ax,Dx
                    Mov       Ah,02h            ;STDOUT char
                    Ja        STDOUT            ;>> Display char

CalculateDate:      Mov       Ax,Di
                    Mov       Dl,19
                    Div       Dl                ;Y/19
                    Xchg      Ax,Dx             ;N=Y%19
                    Mul       Dh
                    Xchg      Ax,Di             ;N*19

                    Imul      Si,Ax,5
                    Shr       Si,2              ;Y+Y/4
                    Mov       Bl,100
                    Div       Bl                ;Y/100
                    Mov       Bl,Al             ;C=Y/100

                    Aam       4                 ;C/4
                    Sub       Bl,Ah             ;C-C/4
                    Sub       Si,Bx             ;Y+Y/4-C+C/4
                    Aad       4                 ;C
                    Aam       3                 ;(C-K)/3
                    Sub       Bl,Ah             ;C-C/4-(C-K)/3
                    Lea       Ax,[Bx+Di+15]     ;I=C-C/4-(C-K)/3+19*N+15

                    Mov       Bl,30
                    Div       Bl                ;I/30
                    Mov       Al,Dh             ;Ah=I%30, Al=N
                    Dec       Bx                ;If (I=28 and 21-N>=11) or
                    Cmp       Ax,28 Shl 8 + 10  ;   (I<28) do +1
                    Adc       Bl,Ah             ;L+27+2+Carry
                    Lea       Ax,[Bx+Si]        ;J=Y+Y/4+I+2-C+C/4
                    Cwd
                    Mov       Cl,7
                    Div       Cx                ;J/7
                    Mov       Ax,Bx
HiddenRet           Equ       $-1
                    Sub       Ax,Dx             ;L=I-J%7

                    Mov       Si,Offset April   ;Text pointer
                    Mov       Dl,0F7h
                    Mov       Di,Dx
                    Sub       Al,33
                    Ja        IsApril
                    Sub       Si,Cx             ;New text pointer
                    Add       Al,31             ;31*(M/4)
IsApril:            Div       Byte Ptr [Di+0101h-00F7h] ;Div 10 in 0101h
                    Test      Al,Al             ;Al=MSB, Ah=LSB
                    Jne       NoLZ              ;>> Skip leading zero
                    Mov       Al,10h
NoLZ:               Xor       Ax,3030h          ;convert to ascii
                    Rep       Movsb             ;Copy 7 bytes
                    Stosw                       ;Day done

                    Push      Di                ;0100h
                    Mov       Ah,09h            ;Display month (Return Al=24h)
STDOUT:             Int       21h
                    Cbw
                    Sub       Al,'0'            ;Ax=digit
                    Jb        HiddenRet         ;>> Ret >> Start or Terminate
                    Imul      Di,10             ;Di=10*Di
                    Add       Di,Ax             ;Di=year value
                    Jmp       STDIN

March               Db        '-March '
April               Db        '-April '

                    End       Start
