.model tiny
.code
.486

	org	100h

;assume ax=0000, bx=0000, cx = 00xx, si = 0100, bp=09xx

start:
;----------------------------------------------------------
; input number					29 bytes
;----------------------------------------------------------
	mov	di,3031h-4
	push	di
	cwd			;ax<8000h => dx=0
read_key:
	mov	ah, 7		;get symbol
	int	21h
	cmp	al,0Dh
	jb	short read_key	;only 0A
	je	short end_line

	cbw
	stosb
	sub	al,30h
	jb	short exit

	add	ax,dx
	push	ax
	imul	dx,ax,10
	jmp	short read_key

end_line:
;----------------------------------------------------------
; make easter date				51 bytes
;----------------------------------------------------------
	pop	ax		;Y
	mov	cl,19
	div	cl
	xchg	ax,cx
	mul	ch
	xchg	ax,si		;(Y%19)*19

	pop	ax		;Y/10
	pop	ax		;Y/100

	imul	cx,ax,64
	mov	bx,ax
	sub	bl,ch
	pop	cx		;Y/1000
	push	bx		;C - C/4
	aam	3
	sub	bl,ah		;C - C/4 - C/3
	lea	ax,[si+bx+15]
	mov	cl,30
	div	cl

	cmp	ax,1C06h
	adc	cl,ah

	pop	ax
	shr	dx,3		;dx=Y*10
	sub	ax,dx		;C - C/4 - Y*5/4
loop1:
	add	ax,7
	cmp	ax,cx
	jl	short loop1

	sub	al,40
 
;----------------------------------------------------------
; print easter date				;36 bytes
;----------------------------------------------------------
	mov	cl,7
	mov	si,offset April_Str
	jg	short april
	add	si,cx
	add	al,31
april:
	mov	bx,0A0Dh
	div	bh
	dec	ax
	and	al,0EFh
	add	ax,di		;di=3031h

	rep	movsb
	stosw
	xchg	ax,bx
	stosw
exit:
	mov	ax,0924h
	stosw
	pop	dx
	int	21h		;print string
	jnc	start
	retn

;----------------------------------------------------------
; data 						;14 bytes
;----------------------------------------------------------
April_Str	db	'-April '
March_Str	db	'-March '

	end	start
