;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;      SPEW assembler
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;
; Assemble:
;   NBASM spu /o
;     ( http://www.cybertrails.com/~fys/newbasic.htm )
;
; Version: 1.03
;
; Run:
;   SPU demo.sam
;
; This assembler does very little error checking.
;  I will leave it up to you to add error checking
;  if you so desire to improve or create your own
;  assembler from this code.
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

False  equ   0
True   equ  -1
OpCnt  equ  34

.model tiny
.code
.186
           org  100h

; =-=-=-=-=- Get command line
start:     mov  si,0081h                ; command line
sspcs:     lodsb                        ; skip all spaces before name
           cmp  al,20h                  ;
           je   short sspcs             ;
           dec  si                      ; move back on for next 'lodsb'

; =-=-=-=-=- Create valid file names
           mov  di,offset SName         ; di = source
           mov  bx,offset TName         ; bx = target
GetFile:   lodsb                        ;
           cmp  al,13                   ; CR
           je   short GotFile           ;
           cmp  al,46                   ; period
           je   short GotFile           ;
           stosb                        ; save in both source and target
           mov  [bx],al                 ;
           inc  bx                      ;
           jmp  short GetFile           ;
GotFile:   mov  si,offset SAMS          ; make source have .SAM ext
           mov  cx,05                   ;
           rep
           movsb                        ;
           mov  si,offset SPUS          ; make target have .SPU ext
           mov  di,bx                   ;
           mov  cx,05                   ;
           rep
           movsb                        ;

; =-=-=-=-=- Clear the buffers
           mov  cx,38211                ; clear Buffer(s)
           mov  di,offset Line          ;  so the code is null terminated
           xor  al,al                   ;
           rep
           stosb                        ;

; =-=-=-=-=- Open the source file
           mov  dx,offset SName         ; open source file
           mov  ax,3D00h                ;
           int  21h                     ;

; =-=-=-=-=- Read from file
           mov  bx,ax                   ;
           mov  cx,32767                ; read at most 32k
           mov  dx,offset Buffer        ;
           mov  ah,3Fh                  ;
           int  21h                     ;

; =-=-=-=-=- Close File
           mov  ah,3Eh                  ; close file
           int  21h                     ;

; =-=-=-=-=- setup and start Pass 1
           mov  si,offset Buffer
           mov  word SymCnt,00h
           mov  word Loctr,100h
Pass1:     call GetALine                ; get a line from source
           cmp  byte Found,False
           je   short Pass1D
           call Parseit                 ; parse source line
           call IsLabel                 ; see if a label
           call DoPass1                 ; do pass 1
           jmp  short Pass1

; =-=-=-=-=- Setup and do Pass 2
Pass1D:    mov  si,offset Buffer
           mov  di,offset CodeBuff

; =-=-=-=-=- Write our header to .SPU file
           call Header              ; on return, di = offset codebuff + 256
           mov  word Loctr,100h
Pass2:     call GetALine                ; get a line from source
           cmp  byte Found,False
           je   short Pass2D
           call Parseit                 ; parse source line
           call DoPass2                 ; do pass 2
           jmp  short Pass2

; =-=-=-=-=- Set up Register area and write to file
Pass2D:    mov  di,offset CodeBuff
           mov  byte [di+0F00h],00h     ; A
           mov  byte [di+0F01h],00h     ; Status
           mov  word [di+0F02h],0000h   ; Stk
           mov  word [di+0F04h],0100h   ; PC
                      
; =-=-=-=-=- Create Target file (.SPU)
           mov  dx,offset TName         ; create target file
           mov  ah,3Ch                  ;
           mov  cx,20h                  ; normal file
           int  21h                     ;

; =-=-=-=-=- Write to File
           mov  bx,ax                   ;
           mov  ah,40h                  ; write 4k bytes
           mov  dx,offset CodeBuff      ;
           mov  cx,4096                 ;
           int  21h                     ;

; =-=-=-=-=- Close File
           mov  ah,3Eh                  ; close file
           int  21h                     ;

; =-=-=-=-=- 'Return' to DOS
           ret                          ; exit to dos

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Do Pass one stuff
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoPass1    proc near uses si di
           mov  si,offset Opcode
           lodsb
           or   al,al
           jz   short NoOpcode1
           call findOpCode              ; See it is a valid mnemonic
           cmp  byte Found,False        ; returns table pos in ax
           je   short NoOpcode1
           add  word Loctr,02
           
           mov  bx,ax
           mov  si,offset OpVal
           mov  al,[bx+si]
           cmp  al,0FFh
           jne  short NoOpcode1
           mov  di,offset CodeBuff      ; doesn't matter if write to
           call DoDB                    ;  codebuff on pass 1
NoOpcode1: ret
DoPass1    endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Do Pass Two stuff
;   di = current code location (at start 100h) (inc 2 with each opcode)
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoPass2    proc near uses si
           mov  si,offset Opcode
           lodsb
           or   al,al
           jz   short NoOpcode2
           call findOpCode              ; Is it a valid mnemonic
           cmp  byte Found,False        ; returns table pos in ax
           je   short NoOpcode2
           add  word Loctr,02
           mov  bx,ax                   ;
           call GetTargVal              ; returns targ val in ax
           mov  dx,ax                   ; save targ val in dx for subs
           mov  si,offset OpVal         
           mov  al,[bx+si]              ; I probably could have used
           or   al,al                   ;  a lookup table here, instead
           jne  short Not00h            ;  of the jmps.  However, there
           call DoOSCALL                ;  are only a few jmps.  If you
           jmp  short NoOpcode2         ;  add to the opcodes, you should
Not00h:    cmp  al,0Fh                  ;  probably make this a lookup
           jne  short Not0Fh            ;  table.
           call DoJP
           jmp  short NoOpcode2
Not0Fh:    cmp  al,10h
           jne  short Not10h
           call DoRETURN
           jmp  short NoOpcode2
Not10h:    cmp  al,1Fh
           jne  short Not1Fh
           call DoGOSUB
           jmp  short NoOpcode2
Not1Fh:    cmp  al,0FFh
           jne  short NotFFh
           call DoDB
           jmp  short NoOpcode2
NotFFh:    mov  ah,al
           and  ah,0F0h
           cmp  ah,0A0h
           jne  short NotAxh
           call DoJPcc
           jmp  short NoOpcode2
NotAxh:    mov  cl,al    ; should be error if we get anything other
           mov  ax,dx    ;  than 20h though F0h except Axh
           and  ah,0Fh
           or   ah,cl
           stosw
NoOpcode2: ret
DoPass2    endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  writes 00..FF to first 256 bytes of .spu file
;  on entry, di = offset codebuff
;  on return, di = offset codebuff + 256
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Header     proc near uses ax cx si
           mov  si,offset Sig
           mov  cx,(SigEnd-Sig+1)    ; include 1Ah
           mov  ax,cx
           rep
           movsb
           mov  cx,256
           sub  cx,ax
           mov  al,00h
           rep
           stosb                     ;
           ret                       ;
Header     endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Find the opcode in our table
;  if found, (true) and ax = count
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
FindOpCode proc near uses cx si di

           mov  byte Found,False
           mov  si,offset OpCode
           mov  di,offset OpName
           xor  cx,cx
FindIt1:   push cx
           mov  cx,08
           push si
           push di
           rep
           cmpsb
           pop  di
           pop  si
           pop  cx
           je   short FoundIt
           add  di,08
           inc  cx
           cmp  cx,OpCnt
           jbe  short FindIt1
           jmp  short FDone1
FoundIt:   mov  ax,cx
           mov  byte Found,True
FDone1:    ret
FindOpCode endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; returns 'value' of DEST
;   on exit  ax = 'value'
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
GetTargVal proc near uses cx bx dx si di

           mov  si,offset Dest
           lodsb
           cmp  al,'@'            ; is it a label
           je   short GIsLabel
           cmp  al,'#'            ; is it a immed12
           je   short GIsNum  
           cmp  al,'%'            ; is it a const/reg
           je   short GIsConst
             ;; should not reach this unless a string; else, error
           jmp  short GetTValD

GIsLabel:  mov  cx,SymCnt
           mov  di,offset SymTable
           xor  bx,bx                   ; count
GIsLL:     push cx
           push si
           push di
           mov  cx,16
           repe
           cmpsb
           pop  di
           pop  si
           pop  cx
           je   short IsSymb
           add  di,16
           inc  bx
           loop GIsLL
           ;; if we get here, we have an error
           jmp  short GetTValD

IsSymb:    mov  di,offset SymValue      ; save its position
           shl  bx,1
           mov  ax,[bx+di]
           jmp  short GetTValD

GIsNum:    xor  dx,dx
           mov  cx,03
GisNumL:   shl  dx,04
           lodsb
           sub  al,'0'
           cmp  al,09
           jbe  short IsNum
           sub  al,07
IsNum:     or   dl,al
           loop GisNumL
           mov  ax,dx
           jmp  short GetTValD

GIsConst:  mov  ax,0F00h                ; assume %A
           mov  di,offset AStr
           push si
           mov  cx,02
           repe
           cmpsb
           pop  si
           je   short GetTValD

           mov  ax,0F01h                ; assume %STATUS
           mov  di,offset StatusStr
           push si
           mov  cx,07
           repe
           cmpsb
           pop  si
           je   short GetTValD

           mov  ax,0F02h                ; assume %STK
           mov  di,offset StkStr
           push si
           mov  cx,04
           repe
           cmpsb
           pop  si
           je   short GetTValD

           mov  ax,0F04h                ; assume %PC
           mov  di,offset PCStr
           push si
           mov  cx,03
           repe
           cmpsb
           pop  si
           je   short GetTValD
           ;; if we get to here, we have an error
GetTValD:  ret
GetTargVal endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Get a line from the buffer
;   uses si as current source Pos
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
GetALine   proc near uses ax di
           mov  byte Found,False        ; assume no lines left

           mov  di,offset Line          ; clear out line
           mov  cx,256                  ; 
           xor  al,al                   ;
           rep
           stosb                        ;

           mov  di,offset Line
GLoop1:    lodsb
           or   al,al
           jz   short GDone
           cmp  al,13
           je   short GotLine
           cmp  al,09                   ; tab
           je   short GisTab
           cmp  al,32
           jb   short GLoop1
           stosb
           jmp  short GLoop1
GisTab:    mov  al,32                   ; change to a space
           stosb
           jmp  short GLoop1
GotLine:   xor  al,al
           stosb
           mov  byte Found,True
GDone:     ret
GetALine   endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Parse the Line
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Parseit    proc near uses si di

           mov  di,offset Label1        ; clear out (Label1, Opcode, Dest)
           mov  cx,192                  ; 64 * 3
           xor  al,al                   ;
           rep
           stosb                        ;

           mov  si,offset Line
           cmp  byte [si],'@'
           jne  short NoLable
           mov  di,offset Label1
           call copystr
NoLable:   call skipspcs
           mov  di,offset OpCode
           call copystr
           call skipspcs
           mov  di,offset Dest
           call copystr
           ret
Parseit    endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Copies a string from si to di until a space, comma, semi-colon, or EOL
;   is reached.
; returns with si -> to char after delimitor ( sp,comma,sc,eol )
; returns di -> an upper case asciiz string
;  does not uppercase given strings
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
copystr    proc near uses ax cx
Copyit:    lodsb
           or   al,al
           jz   short CopyD
           cmp  al,39                   ; string (single quote)
           jne  short NotString         ;
DoString:  stosb                        ; else allow copy of strings
           lodsb
           cmp  al,39
           jne  short DoString
           stosb
           jmp  short CopyD
NotString: cmp  al,13
           je   short CopyD
           cmp  al,32
           je   short CopyD
           cmp  al,44
           je   short CopyD
           cmp  al,59                   ; semi colon
           je   short CopySC
           cmp  al,'a'
           jb   short NoUpCs
           cmp  al,'z'
           ja   short NoUpCs
           sub  al,32
NoUpCs:    stosb
           jmp  short Copyit
CopySC:    push di
           mov  di,si
           xor  al,al
           mov  cx,256
           repne
           scasb
           mov  si,di
           pop  di
CopyD:     xor  al,al
           stosb
           ret
copystr    endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; skips to first non space in si
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
skipspcs   proc near
skipit:    cmp  byte [si],20h
           jne  short skdone
           inc  si
           jmp  short skipit
skdone:    ret
skipspcs   endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Checks to see if there is a label in the Label1 pos.
;   if so, add to symbol table
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
IsLabel    proc near uses ax bx si di

           mov  si,offset Label1
           lodsb
           cmp  al,'@'
           jne  short IsLabD
           mov  di,offset SymTable
           mov  bx,SymCnt               ; save this symbol
           shl  bx,04                   ; times by 16
           add  di,bx                   ;
           call copystr                 ;

           mov  di,offset SymValue      ; save its position
           mov  bx,SymCnt               ; 
           shl  bx,01                   ; times by 2
           mov  ax,Loctr
           mov  [bx+di],ax

           inc  word SymCnt             ; inc to next symbol space

IsLabD:    ret
IsLabel    endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 00xx    OSCALL xx    Operating System CALL
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoOSCALL   proc near uses ax
           xor  ah,ah
           mov  al,dl
           stosw
           ret
DoOSCALL   endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 0xxx    JP xxx       Jump to new PC address (ie. JMP)
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoJP       proc near uses ax
           mov  ax,dx
           and  ax,0FFFh
           stosw
           ret
DoJP       endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 1000    RETURN       Return from sub-routine (ie. RET)
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoRETURN   proc near uses ax
           mov  ax,1000h
           stosw
           ret
DoRETURN   endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 1xxx    GOSUB xxx    Goto sub-routine (ie. a CALL)
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoGOSUB    proc near uses ax
           mov  ax,dx
           and  ax,0FFFh
           or   ah,10h
           stosw
           ret
DoGOSUB    endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Acpp    JPcc    +pp  Conditional jump instruction (ie. Jcc)
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoJPcc     proc near uses ax bx
           mov  bx,Loctr
           sub  dx,bx
           mov  ah,al
           mov  al,dl
           stosw
           ret
DoJPcc     endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Declare Byte
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoDB       proc near uses si
           sub  word Loctr,02           ; fix Loctr Val
           mov  si,offset Dest
           cmp  byte [si],39
           je   short IsString
           mov  al,dl
           stosb
           inc  word Loctr
           jmp  short DoDBD
IsString:  inc  si
DoDbL:     lodsb
           cmp  al,39                   ; is it the ending quote?
           je   short DoDBD
           stosb
           inc  word Loctr
           jmp  short DoDbL
DoDBD:     ret
DoDB       endp

SName      dup 13,0
TName      dup 13,0
SAMS       db  '.SAM',0
SPUS       db  '.SPU',0

AStr       db  'A',0
StatusStr  db  'STATUS',0
StkStr     db  'STK',0
PCStr      db  'PC',0

Found      db  00h
SymCnt     dw  00h
Loctr      dw  100h

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; mnemonics
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
OpName     db  'OSCALL',0,0
           db  'JP',0,0,0,0,0,0
           db  'RETURN',0,0
           db  'GOSUB',0,0,0
           db  'PUSHB',0,0,0
           db  'POPB',0,0,0,0
           db  'LDA',0,0,0,0,0
           db  'STA',0,0,0,0,0
           db  'RDI',0,0,0,0,0
           db  'WRI',0,0,0,0,0
           db  'RDSYS',0,0,0
           db  'ADDW',0,0,0,0
           db  'JPOV',0,0,0,0
           db  'JPNO',0,0,0,0
           db  'JPC',0,0,0,0,0
           db  'JPNC',0,0,0,0
           db  'JPZ',0,0,0,0,0
           db  'JPNZ',0,0,0,0
           db  'JPBE',0,0,0,0
           db  'JPA',0,0,0,0,0
           db  'JPS',0,0,0,0,0
           db  'JPNS',0,0,0,0
           db  'JPP',0,0,0,0,0
           db  'JPNP',0,0,0,0
           db  'JPL',0,0,0,0,0
           db  'JPGE',0,0,0,0
           db  'JPLE',0,0,0,0
           db  'JPG',0,0,0,0,0
           db  'ADCA',0,0,0,0
           db  'SBBA',0,0,0,0
           db  'ORA',0,0,0,0,0
           db  'ANDA',0,0,0,0
           db  'XORA',0,0,0,0
           db  'DB',0,0,0,0,0,0

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Opcodes
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
OpVal      db   00h         ; OSCALL xx
           db   0Fh         ; JP xxx
           db   10h         ; RETURN
           db   1Fh         ; GOSUB xxx
           db   20h         ; PUSHB [xxx]
           db   30h         ; POPB [xxx]
           db   40h         ; LDA [xxx]
           db   50h         ; STA [xxx]
           db   60h         ; RDI [(xxx)]
           db   70h         ; WRI [(xxx)]
           db   80h         ; RDSYS [0000:0xxx]
           db   90h         ; ADDW [xxx],A
           db  0A0h         ; JPOV +pp
           db  0A1h         ; JPNO +pp
           db  0A2h         ; JPC  +pp
           db  0A3h         ; JPNC +pp
           db  0A4h         ; JPZ  +pp
           db  0A5h         ; JPNZ +pp
           db  0A6h         ; JPBE +pp
           db  0A7h         ; JPA  +pp
           db  0A8h         ; JPS  +pp
           db  0A9h         ; JPNS +pp
           db  0AAh         ; JPP  +pp
           db  0ABh         ; JPNP +pp
           db  0ACh         ; JPL  +pp
           db  0ADh         ; JPGE +pp
           db  0AEh         ; JPLE +pp
           db  0AFh         ; JPG  +pp
           db  0B0h         ; ADCA [xxx]
           db  0C0h         ; SBBA [xxx]
           db  0D0h         ; ORA  [xxx]
           db  0E0h         ; ANDA [xxx]
           db  0F0h         ; XORA [xxx]
           db  0FFh         ; DB

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; This is the signature that is placed in the first
;  part of the .spu file.  This area is overwritten
;  on startup in the EMUlator so we can make this
;  just about anything we want.
; I chose to place some information/advertisment
;  text and the EOF char (ascii 1Ah) so that we
;  can use TYPE and view this text in DOS
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Sig        db  13,10,'Hugi Compo #14...'
SigEnd     db  1Ah            ; 1Ah so that we can "type filename.spu"
                              ;  and print this sig

Line       dup 256,?
Label1     dup 64,?
OpCode     dup 64,?
Dest       dup 64,?
SymTable   dup 800,?          ; allows 50 16-byte symbols
SymValue   dup 100,?          ;  50 words for each
CodeBuff   dup 4096,?
Buffer     dup 32767,?        ; read in data

.end  start
