
; Spew assembler by Aphex for Hugi Compo #14
; Compile: tasm /m entry
;	   tlink /t/x entry

; Thanks go to TAD for the mnemonic table and for aad 0 hint

p286
model tiny
codeseg
startupcode


		DEBUG = 0			; set to 1 for debugging



		spusigaddr	equ	offset spusig

		samfilebufhi	equ 	7Dh	; file will load @ 7D82h
						; must be chosen in such way
						; that label table (bp)
						; can be allocated propery

		fillhi		equ 	samfilebufhi+80h-2
						; fill count

		siglen		equ	offset endofentry-spusigaddr

		bpval		equ 	-(fillhi*100h-0F04h+siglen)
						; label table		

start:

		IF	DEBUG

		cld
		xor	ax, ax
		xor	bx, bx
		mov	cx, 0FFh
		mov	dx, cs
		mov	si, offset fileext
		mov	di, sp
		mov	bp, 91Eh

fileext:
		ENDIF


		
		db	'SPu', 0		; SPU extension
						; sp -= 4
						; still keeping zero on stack
		db	1Ah, 0Fh, 27h		; open file by FCB fct-s
	
						; cl = 32h-CF, large enough

		mov	ax, 3C2Eh		

		mov	dx, 82h                 ; dx -> SAM filename
		mov	di, dx
		
		repne	scasb			; search for extension
		pop	cx                      ; cx = 0

		IF	DEBUG
		push	100h
		ELSE
		push	si
		ENDIF				

		movsw				; overwrite it with 'SPU', 0
		movsw

		int	21h			; create SPU file
		xchg	bx, ax			; bx = file handle

		mov	di, offset endofentry   ; fill memory w/ 0
		mov	ch, fillhi
		rep	stosb

		mov	dh, samfilebufhi

		push	dx
fcbop:
		mov	ch, [si]
		xchg	cx, ax
		int	21h                     ; call a DOS function
						; first set DTA
						; second open FCB
						; third read random block

		mov	dx, 5Ch

		inc	si
		jp	fcbop

		pop	si			; si -> SAM source
		pop	ax			; ax = PC

		mov	bp, bpval		; bp -> label table
		mov	[bp+di], ax		; put PC in memory

		mov 	di, spusigaddr+100h 	; di -> SPU code

		inc	cx			; cx > 1
writebin:
		pusha				; save cx, bp, si, di
		pusha				; save all other regs


parse:
		pop	bx			; bx -> SPU code
		pop	si			; si -> SAM source
		pop	di			; di -> label table

		dw	878Dh			; ax = bx-spusigaddr
		dw	-spusigaddr
		stosw
		
		xor	ah, ah                	; ah = 0
		cwd
get3tok:		

		mov	cl, 42h

copyloop:    			
		lodsb
		cmp	al, 13
		jbe	copystrok		; if end of string then exit
           	cmp     al, 39
           	jne  	countstr		
		lahf                      	; mark string delimiter
countstr:	
		or	ah, ah                  ; test if we're in user string
		jnz	putch 			; (nr of string delims = 2*k+1)

		cmp	al, 3Bh
           	je      copystrok		; if semi-colon then exit

		and	al, 0DFh		; uppercase
						; modifies other chars also!

putch:
		stosb				; copy char		
		loopnz	copyloop

skipsp:
		lodsb
		cmp	al, ' '			; skip spaces
		je	skipsp

copystrok:     	

		dec	si			; adjust si

		xor	ax, ax  		; right pad the string w/ 0s
		rep	stosb	


		inc	dx			; dx ++ (will be 1, 3, 5)
		jp	incdx			; if dx != 1 skip next two lines

		push	di			; save label table pointer
		mov	di, offset opcode	; and start filling strings

incdx:
		inc	dx			; dx ++ (will be 2, 4, 6)
		jnp	get3tok			; for 3 times

getmorechars:	
		lodsb				; move to the end of string
		cmp	al, 0Ah
		jne	getmorechars		

		push	si			; save SAM pointer
		mov	bp, [si]		; get the current character

		mov	si, offset dest		; si -> data
		mov	di, si			; di -> data
		lodsb				; get first char
		cbw				; ah = 0
		cwd				; dx = 0
		
		call	asm			; assemble the opcode
	
		push	di			; save SPU pointer
		dec	bp
		jns	parse			; eof?

popall:

		popa				; pop all regs
						; (bp, si, di are modified!)
		popa				; pop them again :)

		loop	writebin		; minimum 2 loops
						; 1st = building label table
						; 2nd-nth = building SPU

		mov	dx, spusigaddr   	; get SPU file buffer

		mov	ah, 40h
		mov	ch, 10h
		int	21h			; write 4096 bytes



isareg:		
		lodsb				
		cmp	al, 'P'
		js	regready                ; if ~A~ then dl = 0
		mov	dl, 4
		jz	regready		; if ~PC~ then dl = 4
regmore:
		shr	dl, 1			; dl /= 2
		lodsw
		aad	4			; check for ~STATUS~ & ~STK~
		jns	regmore
regready:
		mov	dh, 0Fh			; dh = 0Fh
		jmp	findop


isstr:
		mov	di, bx			
putstrdata:
		movsb                           ; write string
		cmp	[si], cl
		jne	putstrdata
putstrret:
		ret

asm:
		cmp	al, 5
		xchg	cx, ax
		js	isanumber		; al = 0, 3
		jz	isareg			; al = 5
		jp	isstr			; al = 27h
						; al = 40h
isalabel:
		mov	si, bpval-42h
nextlabelentry:
		add	si, cx
		lodsw
		lodsw				; get label value
		pusha
		rep	cmpsb			; scan for label's name
		popa
		jz	labelready		; while label not found
		dec	ax
		jns	nextlabelentry		; and not end of label table
labelready:
		xchg	dx, ax			; dx = label
		jmp	findop

roldigit:
		aam	16                      ; break al's nibbles
		aad	3 			; add them again as a hex digit		
		shl	dx, 4			; rol number
		or	dx, ax			; add digit to it
isanumber:
		lodsb				; get new digit
		sub	al, 10h			; clear high nibble for nr
		jns	roldigit		; loop while digit

findop:
		push	cx			
		mov	di, offset ops          ; di -> mnemonic table
		mov	si, offset opcode+1	; si -> current mnemonic
		mov	cl, 18  		; 18 mnemonic opcodes
		lodsw				
		dec	si
findop1:
		scasw
		loopnz	findop1	                ; scan for mnemonic match
		jnz	findmoreop              
noaddback:
		shl	cl, 4			; the opcode is X0h
		or	cl, dh			; mix it w/ data
		jmp	joinhere				
findmoreop:
		mov	cl, 16			; 16 mnemonic opcodes
		lodsw
findop2:
		scasw
		loopnz	findop2                 ; scan for mnemonic match
		jnz	nomoreop			
		add	cl, 0A0h		; the opcode is AXh
		add	dx, spusigaddr-2	
		sub	dx, bx                  ; transform to relative addr
joinhere:
nomoreop:
		mov	di, bx			; di -> SPU code
		pop	bx			; bx = data type (0 = no data)
		or	bx, ax			
		jz	nodata
		mov	[di], dl                ; write data
		inc	di
nodata:
		aad	0
		jz	noinstr		
		xchg	cx, ax
		stosb
noinstr:
		ret                 
ops:
		db	'ET'	; RETURN
		db	'SC'	; OSCALL
		db	'OR'	; XORA
		db	'ND'	; ANDA
		db	'RA'	; ORA
		db	'BB'	; SBBA
		db	'DC'	; ADCA
		db	'  '	; 
		db	'DD'	; ADDW
		db	'DS'	; RDSYS
		db	'RI'	; WRI
		db	'DI'	; RDI
		db	'TA'	; STA
		db	'DA'	; LDA
		db	'OP'	; POPB
		db	'US'	; PUSHB
		db	'OS'	; GOSUB
		db	'P', 0  ; JP

		db	'G',0	; JPG 
		db	'LE'	; JPLE
		db	'GE'	; JPGE
		db	'L',0	; JPL 
		db	'NP'	; JPNP
		db	'P',0	; JPP 
		db	'NS'	; JPNS
		db	'S',0	; JPS 
		db	'A',0	; JPA 
		db	'BE'	; JPBE
		db	'NZ'	; JPNZ
		db	'Z',0	; JPZ 
		db	'NC'	; JPNC
		db	'C',0	; JPC 
		db	'NO'	; JPNO
		db	'OV'	; JPOV

spusig:		db  	0Dh,0Ah,'Hugi Compo #14...',1Ah
endofentry:


		org	offset spusig+1000h
opcode:		db	66 dup(?)
dest:		db	66 dup(?)

end start
