;
;
;    		UNI-CURSAL maze gen by TAD ( tad.uk@dtn.ntl.com )
;
; compile:
;	TASM new
;	TLINK /t new
;
; usage:
;	NEW	<rndseed>
;
; notes:
;	This is an 'avoid a wall' type of algo. The movement is 2 maze cells
;	so that the PATH_C is surrounded by a 1 cell/byte space.
;
;	( check out: new 5704 - who says the shortest route between 2
;	 points is a straight line ??  not in this maze it ain't... #;oP)
;
;

SLOW		equ	0		; 0=fast maze gen, NZ=slow

MAZE_WIDTH	equ	100
MAZE_HEIGHT	equ	100
MAZE_SIZE	equ	(MAZE_WIDTH * MAZE_HEIGHT)

WALL_C		equ	00h
PATH_C		equ	01h
BEGIN_C		equ	02h
EXIT_C		equ	03h


NORTH		equ	-2*MAZE_WIDTH
EAST		equ	2
SOUTH		equ	2*MAZE_WIDTH
WEST		equ	-2

	.model tiny

	.data
moves		dw	NORTH, EAST, SOUTH, WEST
		dw	NORTH, EAST, SOUTH, WEST	; lazy wrap 0...3

filename	db	'MINO',0
flag	db	1

seedtxt		db	'seed='
seed_inf	db	'00000 decimal'
		db	'$'


	.data?
oldseed		dw	?
rndseed		dw	?

maze		db	MAZE_SIZE dup (?)


	.code
	.286
	org	256
go:
	;; get decimal number from command-line (FCB #1) ;;

	sub	ax, ax
	cwd
	mov	si, 82h
getnum:
	imul	dx, 10
	add	dx, ax
	lodsb
	sub	al, '0'
	cmp	al, 9
	jbe	short getnum
	mov	rndseed, dx
	mov	si,81h
getflg:	lodsb
	cmp	al,'i'
	je	@@l1
	cmp	al,'I'
	jne	@@l2
@@l1:	mov	flag,0
@@l2:	cmp	al,20h
	jae	getflg

	cmp	flag,0
	je	NewMaze
	mov	ax, 0013h
	int	10h

;
; The main maze-gen stuff..
;

NewMaze:
	mov	ax, rndseed
	mov	oldseed, ax

	;; zap the maze with marker (note: 3 cell border!!) ;;

	lea	di, maze
	sub	ax, ax
	mov	cx, MAZE_WIDTH
	rep	stosb
	mov	dx, MAZE_HEIGHT-3
zap:
	stosb
	mov	al, 80h
	mov	cx, (MAZE_WIDTH-3)
	rep	stosb
	sub	ax, ax
	stosw
	dec	dx
	jnz	short zap
	mov	cx, (2*MAZE_WIDTH)
	rep	stosb

	;; random start (BEGIN) location ;;

	call	RandPos

	;; keep start (BEGIN location) ;;

	push	di

	;; random direction ;;

	mov	ax, 4
	call	random
	shl	ax, 1
	xchg	ax, bp

	;; the main maze-gen loop ;;

	sub	bx, bx
forward:
	mov	ax, 8000h + PATH_C
	sar	bx, 1
	add	di, bx
	mov	[di], al
	add	di, bx
turn:
	and	bp, (3*2)		; bp = direction (0,2,4,6)

genloop:
	mov	[di], al

	IF SLOW
		call	drawmaze
	ENDIF

	mov	bx, moves[bp]
	cmp	[di+bx], ah
	jz 	short forward		; ok to move forward ?

	mov	bx, moves[bp+2]
	add	bp, 2
	cmp	[di+bx], ah
	jz	short turn	     	; ok to turn right ?

	sub	bp, 2+2
	mov	bx, moves[bp+8]
	cmp	[di+bx], ah
	jz	short turn	     	; ok to turn left ?

	;; insert BEGIN & EXIT locations ;;

	pop	bx
	cmp	bx, di
	jz	short far_NewMaze	; BEGIN = EXIT location ?

	mov	byte ptr [bx], BEGIN_C
	mov	byte ptr [di], EXIT_C

	;; clear the temporary 80h bytes ;;

	mov	bx, (MAZE_SIZE-1)
clean:
	and	byte ptr maze[bx], 07Fh
	dec	bx
	jns	short clean

	cmp	flag,0
	je	Skip2

	;; show the resulting mess (I mean maze #;o) ;;

	call	DrawMaze

	;; Wait for key

	mov	ah, 0
	int	16h
	cmp	al, 27
	jz	short Done
far_NewMaze:
	jmp	NewMaze

Done:
	mov	ax, 0003h
	int	10h


	;; display seed ;;

	lea	di, seed_inf
	mov	ax, oldseed
	call	outdec5

	lea	dx, seedtxt
	mov	ah, 9
	int	21h

	;; create the "MINO" file ;;

Skip2:	lea	dx, filename
	sub	cx, cx
	mov	ah, 3Ch
	int	21h
	jc	Quit
	xchg	ax, bx
	lea	dx, maze
	mov	cx, MAZE_SIZE
	mov	ah, 40h
	int	21h
	mov	ah, 3Eh
	int	21h
Quit:
	ret

;
; (AX)=Random number 0...(AX)-1
;
Random:
	push	dx
	mul	rndseed
	ror	ax, 1
	add	ax, 1066
	mov	rndseed, ax
	xchg	ax, dx
	pop	dx
	ret


;
; Draw maze on screen (2x2 zoom)
;
DrawMaze:
	push	ES
	pusha
	push	0A000h
	pop	ES
	sub	di, di
	lea	si, maze
	mov	dx, MAZE_HEIGHT
dm_YLOOP:
	mov	cx, MAZE_WIDTH
dm_XLOOP:
	lodsb
	mov	ah, al
	mov	ES:[di+320], ax
	stosw
	loop	dm_XLOOP
	add	di, 640-(2*MAZE_WIDTH)
	dec	dx
	jnz	short dm_YLOOP
	popa
	pop	ES
	ret

;
; Output(AX) into[ES:DI] as 5-digit decimal
;
outdec5:
	mov	bx, 4*2
	mov	cl, 0
od_DIGIT:
	sub	dx, dx
	div	word ptr decimals[bx]
	or	cl, al
	jnz	short od_PRT
	mov	al, 20h-'0'
od_PRT:
	add	al, '0'
	stosb
	xchg	ax, dx
	dec	bx
	dec	bx
	jnz	short od_DIGIT
	add	al, '0'
	stosb
	ret

decimals	dw	0
		dw	10
		dw	100
		dw	1000
		dw	10000


;
; [DS:DI] = Random position on maze
;
RandPos:
	mov	ax, (MAZE_WIDTH/2)-3
	call	random
	inc	ax
	shl	ax, 1
	xchg	ax, di

	mov	ax, (MAZE_HEIGHT/2)-3
	call	random
	inc	ax
	shl	ax, 1
	mov	dx, MAZE_WIDTH
	mul	dx
	add	ax, offset maze
	add	di, ax
	ret


	end	go
