;
;
;               silly "T"-maze by TAD ( tad.uk@dtn.ntl.com )
;                       (see: TMAZE.TXT for more info)
;
; compile:
;       TASM /m9 tmaze
;       TLINK /t tmaze
;
; usage:
;       TMAZE.COM
;
; >>>  modified to add begin and end, and save the maze to file 'MINO'  <<<
;
;

; sorry about the ugly additions to your code TAD, but I needed a maze
; generator I could test my maze solvers with.


MAZE_WIDTH      equ     100             ; = 5 ... 318 (try 5,5 for ASCII chars)
MAZE_HEIGHT     equ     100             ; = 5 ... 198

        .model tiny                     ; yep, it's a .COM program

        .data
flag	db	1
steps           dw      -320, 1, 320, -1

        .data?
wSeg	dw ?
dirs            db      4 dup (?)
backstk         dw      8000 dup (?)    ; should be plenty... (I hope :)
mino            db      MAZE_WIDTH * MAZE_HEIGHT dup (?)


SCAN    macro   dx, dy
        cmp     al, ES:[di+(dx)+((dy)*320)]
        endm

;* Light the blue touch-paper & retire to a safe distance... heheh *

        .386
        .code
        org 256
go:	pusha
	mov	ax,cs
	add	ax,1000h
	mov	wSeg,ax
	push	es
	mov	es,ax
	xor	di,di
	mov	ax,di
	mov	cx,8000h
	rep stosw
	pop	es

        ;; get decimal number from command-line (FCB #1) ;;

	sub	ax, ax
	cwd
	mov	si, 82h
getnum:
	imul	dx, 10
	add	dx, ax
	lodsb
	sub	al, '0'
	cmp	al, 9
	jbe	short getnum
	mov	bp, dx
	mov	si,81h
getflg:	lodsb
	cmp	al,'i'
	je	@@l1
	cmp	al,'I'
	jne	@@l2
@@l1:	mov	flag,0
@@l2:	cmp	al,20h
	jae	getflg
	popa

        ;; switch to mode 00013 hex (320 x 200 x 256 colors) ;;

        mov     al, 0013h
        add     bp, ax
        cmp	flag,0
        je	Skip1
        mov	wSeg,0a000h

        int     10h

        ;; zap the maze rectangle area ;;

Skip1:  mov     ES,wSeg
again:
        mov     di, 0+(0*320)
        mov     al, 7
        mov     dl, MAZE_HEIGHT
zap:
        push    di
        mov     cx, MAZE_WIDTH
        rep     stosb
        pop     di
        add     di, 320
        dec     dl
        jnz     short zap

        ;; the main maze-building routine ;;

        sub     si, si
        mov     di, 3+(3*320)
mainloop:

        ;; zap current maze cell ;;

        mov     al, 0
        mov     ES:[di], al

        sub     bx, bx                  ; cell exit count = 0

        ;; scan up 'T' shape ;;

        SCAN    0, -1                   ; Ŀ
        jz      short up                ;  ?  W  ?   check for 'W' walls
        SCAN    0, -2                   ; Ĵ
        jz      short up                ;  W  W  W   ? = don't care
        SCAN    -1, -1                  ; Ĵ
        jz      short up                ;  ?  x  ?   x = current cell
        SCAN    1, -1                   ; 
        jz      short up                ;

        mov     dirs[bx], 0             ; we can dig up, so push UP direction
        inc     bx                      ; onto the dir-ection list...
up:
        ;; scan right 'T' shape ;;

        SCAN    1, 0                    ; Ŀ
        jz      short right             ;  ?  W  ?   check for 'W' walls
        SCAN    2, 0                    ; Ĵ
        jz      short right             ;  x  W  W   ? = don't care
        SCAN    1, -1                   ; Ĵ
        jz      short right             ;  ?  W  ?   x = current cell
        SCAN    1, 1                    ; 
        jz      short right             ;

        mov     dirs[bx], 1             ; push right direction..
        inc     bx
right:

        ;; scan down 'T' shape ;;

        SCAN    0, 1                    ; Ŀ
        jz      short down              ;  ?  x  ?   check for 'W' walls
        SCAN    0, 2                    ; Ĵ
        jz      short down              ;  W  W  W   ? = don't care
        SCAN    1, 1                    ; Ĵ
        jz      short down              ;  ?  W  ?   x = current cell
        SCAN    -1, 1                   ; 
        jz      short down              ;

        mov     dirs[bx], 2             ; push down direction...
        inc     bx
down:
        ;; scan left 'T' shape ;;

        SCAN    -1, 0                   ; Ŀ
        jz      short left              ;  ?  W  ?   check for 'W' walls
        SCAN    -2, 0                   ; Ĵ
        jz      short left              ;  W  W  x   ? = don't care
        SCAN    -1, -1                  ; Ĵ
        jz      short left              ;  ?  W  ?   x = current cell
        SCAN    -1, 1                   ; 

        mov     dirs[bx], 3             ; push left direction...
        inc     bx
left:

        ;; how many cell exit-paths ?? ;;

        test    bx, bx
        jz      short backtrack         ; dead-end (0 paths) ?

        ;; push current cell onto stack ;;

        mov     backstk[si], di
        add     si, 2

        ;; another lousy rnd-number ;;

        call    zx_rnd

        ;; choose rnd path from direction list ;;

        mov     ah, 0
        div     bl
        mov     bl, ah

        mov     bl, dirs[bx]
        add     bx, bx
        add     di, steps[bx]
        jmp     mainloop

        ;; dead-end, so backtrack ;;

backtrack:
        test    si, si
        jz      short done              ; empty stack ?
        sub     si, 2
        mov     di, backstk[si]
        jmp     mainloop


        ;; WOW... it actually works.. heheh ;;
done:
        call    random_path_pixel
        mov     al, 2
        stosb

        call    random_path_pixel
        mov     al, 3
        stosb

        cmp     flag,0
        je     quit

        mov     ah, 0
        int     16h
        cmp     al, 27
        jz      short quit
        jmp     again

quit:
        ; create file
        mov     ax, 3c00h
        xor     cx, cx
        mov     dx, offset fname
        int     21h
        push    ax

        ; move data into mino buffer
        push    es
        push    ds
        pop     es
        pop     ds
        mov     di, offset mino
        mov     dx, di
        xor     si, si

        mov     bx, MAZE_HEIGHT
loop_m:
        mov     cx, MAZE_WIDTH
inner_loop:
        lodsb
        cmp     al, 0
        je      path
        cmp     al, 7
        jne     col_ok
        mov     al, 0
        jmp     col_ok
path:
        inc     ax
col_ok:
        stosb
        loop    inner_loop

        add     si, (320 - MAZE_WIDTH)

        dec     bx
        jnz     loop_m

        push    es
        pop     ds

        ; write to file
        pop     bx
        mov     ah, 40h
        mov     cx, (MAZE_HEIGHT * MAZE_WIDTH)
        int     21h

        ; close file
        mov     ah, 3eh
        int     21h
        cmp     flag,0
        je     zx_rnd

        mov     ax, 0003h
        int     10h

zx_rnd:
        mov     ax, 75
        mul     bp
        add     ax, di
        ror     ax, 1
        mov     bp, ax
        ret

random_path_pixel:
        call    zx_rnd
        mov     bx, (MAZE_HEIGHT - 2)
        xor     dx, dx
        div     bx
        xchg    ax, dx
        inc     ax
        imul    ax, ax, 320
        xchg    ax, di

        call    zx_rnd
        mov     bx, (MAZE_WIDTH - 2)
        xor     dx, dx
        div     bx
        inc     dx
        add     di, dx

        cmp     byte ptr es:[di], 7
        je      random_path_pixel
        ret


fname:  db 'MINO',0

        end     go
