; Entry for HC #11 by Ruud v Gessel.

by  EQU <BYTE PTR>
off EQU <OFFSET DS:>

                    .MODEL    TINY
                    .386

                    .CODE

                    ORG       100h

S:                  xchg      ax,si               ;si=0
LoadMino:           mov       dx,off szMino       ;Pointer to name
                    mov       bh,3fh              ;Need to read a file
                    call      FileRW              ;Read mino file
                    aad       0beh                ;AX : 2710->2
                    dec       di                  ;Adjust for scasb (or -3)
                    jns       PlotIt              ;Pos --> done, plot path

ExtendPaths:        mov       ch,27h              ;last 100 bytes are 0..
                    inc       ax                  ;Alternate marker
                    mov       di,dx               ;Start of buffer
                    mov       bl,100              ;First neighbour here
ExtendNext:         dec       bx                  ;99, -2, -101, 0.
                    jle       TestNext            ;>> Not next path yet
                    repne scasb                   ;Find a path to extend
                    jne       ExtendPaths         ;>> No more paths, repeat
TestNext:           or        ax,sp               ;al becomes marker (fe/ff)
                    add       ah,[di+bx]          ;Is this neighbour free ??
                    jnz       DontMark            ;>> Nope, wall or used
                    mov       [di+bx+4071h],bl    ;I come from here
                    xor       [di+bx],al          ;Mark used for NEXT scan
DontMark:           xchg      si,bx               ;Swap, x/y direction
                    not       bx                  ;Invert next direction
                    cmp       ah,dh               ;Test for end
                    jne       ExtendNext          ;>> Not at the end yet.
                    db        0d6h                ;SALC = Cheap mov al,0
                    jmp       LoadMino            ;Really hate this one !!

PlotPath:           sub       by [di],bl          ;Jibz's NOP, set CY
                    movsx     si,by [di+bx]       ;Come from here
                    sbb       di,si               ;At previous cel
PlotIt:             mov       bx,4071h            ;Guess why this offset
                    cmp       [di],dh             ;Starting pos ?
                    jz        PlotPath            ;>> Nope path not finished

                    xor       cx,cx               ;Attributes !!
                    mov       dl,off szTour-S     ;Tour name
FileRW:             xor       ah,3ch              ;Open/Create
                    int       21h                 ;Open/Create file
                    xchg      ax,bx               ;BX=handle, ah=R/W
                    mov       dl,off szTour-S+4   ;Buffer starts here
                    mov       cx,10000            ;Need cx = 10000
                    int       21h                 ;Read/Write
                    ret                           ;Done

szMino              db        'mino',0
szTour              db        'tour'              ;First byte of file = 0

                    END       S

