;Hugi Size Coding Competition #11 entry (Maze Solver)
;Ray M. Ransom
;Big Bear City, California, USA
;ray@micosyen.com
;http://www.micosyen.com

	.MODEL	TINY			;03/07/00
	.386
	.CODE
	ORG	100H

START:	MOV	AX,3D82H		;OPEN, PRIVATE, COMPATIBILITY, R/W
	MOV	BH,3FH			;"READ"
	MOV	DX,OFFSET INPNAM	;POINT TO INPUT FILE ASCIIZ
	MOV	BP,DX			;POINT TO MAZE BUFFER BASE
	CALL	RDWRT			;OPEN & READ FILE
	MOV	AX,OFFSET NXTTBL	;POINT TO NEXT EMPTY CELL INDEX TABLE
	MOV	DI,AX			;NEXT EMPTY CELL INDEX TABLE TO DI
	REP	STOSW			;INITIALIZE NEXT CELL INDEX TABLE
	XCHG	AX,BX			;NXT CELL IDX TBL PTR TO BX, HNDL TO AX
	XCHG	AX,SI			;HANDLE TO SI (< 100)
FNSTRT:	INC	SI			;ADJUST SEARCH INDEX
	CMP	[BP+SI],BL		;CELL TYPE IS "START"?
	JNZ	SHORT FNSTRT		;NO
	MOV	AX,SI			;START POSITION INDEX TO AX
CRUISE:	MOV	CL,4			;DIRECTION COUNT
TSTDIR:	MOV	DI,CX			;DIRECTION COUNT TO DI
	MOVSX	DI,BYTE PTR[BP+DI-9]	;GET TEST POSITION DISPLACEMENT
	ADD	DI,SI			;ADJUST TO TEST CELL
	CMP	DI,[BP-15]		;CELL INSIDE MAZE?
	JAE	SHORT NXTDIR		;NO
	TEST	[BP+DI],DH		;CELL TYPE IS "WALL" OR "START"?
	JZ	SHORT NXTDIR		;YES
	ADD	DI,DI			;FORM WORD INDEX
	CMP	[BX+DI],BX		;THIS CELL ALREADY MARKED?
	JNZ	SHORT NXTDIR		;YES
	MOV	[DI+PRVTBL],SI		;STORE CURRENT CELL INDEX IN PREV TABLE
	SHR	DI,1			;FORM BYTE INDEX
	ADD	AX,AX			;FORM WORD INDEX
	XCHG	AX,DI			;NEXT TABLE INDEX TO AX, TBL PTR TO DI
	MOV	[BX+DI],AX		;STORE NEXT EMPTY CELL FOUND INDEX
NXTDIR:	LOOP	TSTDIR
	ADD	SI,SI			;FORM WORD INDEX
	MOV	SI,[BX+SI]		;GET NEXT EMPTY CELL FOUND INDEX
	TEST	[BP+SI],BL		;CELL TYPE IS "END"?
	JZ	SHORT CRUISE		;NO
	DB	0A9H			;"TEST AX,ii" OPCODE (SKIP NXT 2 BYTES)
MRKPTH:	MOV	BYTE PTR[BP+SI],90H	;MARK CELL AS PATH
	ADD	SI,SI			;FORM WORD INDEX
	MOV	SI,[SI+PRVTBL]		;GET PREVIOUS CELL INDEX
	CMP	BYTE PTR[BP+SI],DH	;AT START?
	JZ	SHORT MRKPTH		;NO
	MOV	AH,3CH			;"CREATE"
	MOV	BH,40H			;"WRITE"
	MOV	DL,LOW OFFSET OUTNAM	;POINT TO OUTPUT FILE ASCIIZ
RDWRT:	INT	21H			;OPEN OR CREATE FILE
	XCHG	AX,BX			;HANDLE TO BX, R/W FUNCTION TO AH
	MOV	CX,10000		;R/W BYTE COUNT
	MOV	DX,BP			;POINT TO MAZE BUFFER BASE
	INT	21H			;READ OR WRITE FILE
	RET

DIRDIS:	DB	100,1,-1,-100		;DIRECTION TEST DISPLACEMENTS
OUTNAM:	DB	'TOUR'			;OUTPUT FILE ASCIIZ
INPNAM:	DB	'MINO',0		;INPUT FILE ASCIIZ

CODSIZ	EQU	INPNAM-START+100H
BUFSTR	STRUC
	DB	 CODSIZ DUP(?)
MAZE	DB	  10000 DUP(?)		;MAZE BUFFER
	DB	2902H-$ DUP(?)		;FILL SO THAT TABLE BEGINS AT XX02
NXTTBL	DW	  10000 DUP(?)		;NEXT CELL FOUND INDEX BUFFER
PRVTBL	DW	  10000 DUP(?)		;PREVIOUS CELL INDEX BUFFER
BUFSTR	ENDS
	END	START
