;Maze Pathfinder for HC #11
;
; by Metalbrain (metalb@bart.us.es)
; based on Fabled's example (my 2 own tries were ultra slow...)
;
;Compile with NASM: nasm ENTRY.NAS -o ENTRY.COM
;
; 7/03/99 Start coding!
; 8/03/99 Finish first working version, 126 bytes. Works slow with mazes
;     created with makemaze and veeeeeery slow in those created with unimaze
;     (computer like-hanged, I got tired of waiting for a single one when it
;     was running nearly an hour without solving it). Then I finally took a
;     look at Fabled's example. Started to play with it and left it in 151.
; 9/03/99 Continued playing with Fabled's example and left it in 133.
;23/04/99 At last I start coding again!... The second entry is fast with
;     entries created with unimaze but veeeeery slow with those created with
;     makemaze. Kinda complementing the first one. Anyway size was also 133,
;     so I'll enter the Fabled based one.
;26/04/99 Removed 6 more bytes > 127. First and last entry.

                org     256

                mov     ah,03dh
                mov     dx,maze
                int     33                    ;Open infile
                xchg    bx,ax                 ;Set infile handle
                mov     ah,03fh
                mov     ch,3ch                ;CX>10000
                int     33                    ;Read infile
                xchg    ax,cx                 ;AH=3ch, AL=255, CX=10000
                pusha
                mov     di,queue+1
                rep     stosw                 ;Init table
                mov     si,dx

                mov     dl,outputfile-256
                int     33                    ;Open outfile
                dec     cx                    ;CX=65535
                mov     di,si
                mov     ax,9002h
                repnz   scasb                 ;Search first position
                dec     di
                sub     di,si                 ;Get offset from maze
                mov     bx,di                 ;At start, head=tail
                mov     dl,AddNode-256
                                              ; Do breadth first search
                                              ;  BX = queue head
                                              ;  DI = queue tail
bfs:            lea     bp,[bx-100]
                call    dx                    ;Try up
                dec     bp
                call    dx                    ;Try left
                inc     bp
                call    dx                    ;Try right
                lea     bp,[bx+100]
                call    dx                    ;Try down
                add     bx,bx                 ;Dequeue
                mov     bx,[queue+bx]         ;Next position
                cmp     al,[si+bx]            ;Exit location?
                jnc     bfs                   ;Search until exit is found
find:           add     bx,bx
                mov     bx,[previous+bx]      ;Get previous cell
                cmp     [si+bx],al            ;Beginning of maze?
                jz      done                  ;If yes then the path is marked
                mov     [si+bx],ah            ;Otherwise mark path
                jmp     short find            ;And advance
done:           popa                          ;Restore CX, DX and BX
                mov     ah,40h
                inc     bx                    ;I'm assuming that handle
                                              ; numbers are correlative.
                                              ; Is it dangerous? (Anyway,
                                              ; GENERAL.TXT still doesn't
                                              ; say anything about handles)

                int     21h                   ;Write outfile and fall down
                                              ; till next ret

AddNode:        test    [si+bp],dh
                jz      _ret                  ;If wall or start, exit
                add     bp,bp                 ;Test if it's already in queue
                cmp     byte [queue+1+bp],-1  ;Only test MSByte
                jnz     _ret
                mov     [previous+bp],bx      ;Update travelling table
                shr     bp,1
                add     di,di
                mov     [queue+di],bp         ;Add position BP to end of queue
                mov     di,bp
_ret:           mov     bp,bx                 ;Start preparing next BP
                ret

outputfile      db "TOUR"           ;The first zero of MINO will end this name
maze            db "MINO",0

                section .bss align=1
                resb 9995
queue           resw 10000
previous        resw 10000
