; Standard breadth first search path finding algorithm.
; by Paul Hsieh

.model tiny
.code

        org 100h

start:
        mov     bp, 10000

        call    FACC

        mov     di, dx
        mov     al, 2                ; scan for begin.
        repnz   scasb                ;
        dec     di                   ; *sigh* ...

        ; solve maze

        push    di
        mov     si, sp

BFSloop:
        mov     di, [si]
        dec     si
        dec     si

        mov     bl, 1                ; Assumes that file handle < 256
        call    check
        neg     bx
        call    check
        mov     bl, -100
        call    check
        neg     bx
        push    offset BFSloop

check:                               ; pop return address
        pop cx

        cmp byte ptr [di+bx], 3
        je Finish

        cmp byte ptr [di+bx], 1
        jnz checkend

        mov [di+bx], bl              ; store path back pointer
        dec byte ptr [di+bx]         ; sisambiguate the wall from +1.

        lea ax, [di+bx]
        push ax

checkend:

        jmp cx

Finish:
        mov     sp, -2

        ; reload file to different location.

        mov     si, offset smc_oporcr + 2
        add     [si+8],bp

        call    FACC

        ; set up for save file.

        dec     byte ptr [si]
        inc     byte ptr [si+5]
.486p
        mov     dword ptr [si+15], "RUOT"

        ; reconstruct path

        jmp     step

Floop:
        mov     byte ptr [di+bp],0x90
        inc     bx
        sub     di, bx
step:
        movsx   bx, byte ptr [di]
        cmp     bx, 2
        jnz     Floop

        ; write result

FACC:
        ; SI, DI, BP are left alone.  
        ; returns with DX = &maze[?], CX = BP (=10000)

        mov     dx, offset MINO
        xor     cx, cx

smc_oporcr:
        mov     ax, 03D00h           ; open/create
        int     21h                  ; DOSCALL (open or create)
        xchg    bx, ax               ; file handle

smc_rdorwr:
        mov     ah, 03Fh             ; read/write

smc_adofs:
        db      081h, 0C2h, 05h, 0h  ; add dx,0005

fcont:
        mov     cx, bp
        int     21h                  ; DOSCALL (read or write)

;        mov     ah, 03eh             ; Close file
;        int     21h

        ret

MINO            db "MINO",0

        END start
