        Ideal
        P386
        Model Tiny
        

DEBUG = 0

MACRO salc
        db 0d6h
ENDM

        CODESEG

        Org 100h

Start:

IF DEBUG
        xor     ax, ax
        xor     bx, bx
        mov     cx, 000ffh
        mov     dx, cs
        mov     si, 00100h
        mov     di, 0fffeh
        mov     bp, 00900h
ENDIF

        db      000h, 03dh              ; "add [di],bh"
        lodsw                           ; ax=3d00h, si=0102h
        mov     bh, 03fh
        mov     dx, offset inputfile
        call    FileIO                  ; Read in the MAZE

        xchg    si, ax                  ; SI = 2710h, AX=0102h

        ;; At this point cx = si (so that "previous table" works)

        mov     di, dx
        repne   scasb                   ; Find BEGIN (2)
        mov     bx, di
        dec     bx
        add     di, cx

        pop     ax                      ; Clear AX
        pop     cx                      ; CX = 20CD
        rep     stosw                   ; Clear "previous" table
                                        ; 20CD * 2 is enough... also leaves
                                        ; enough space for queue

        mov     sp, di                  ; Initialize queue

        ; AX = 0000h 
        ; BX = ????h    = BEGIN position (in memory)
        ; CX = 0000h
        ; DX = 01FEh    = MAZE load position, Two separate TEST masks
        ; SI = 2710h    = 10000d
        ; BP = 09??h

        ; DI = ????h = QUEUE TAIL
        ; SP = ????h = QUEUE HEAD

BFS:
        ; BX = Current position in maze

        mov     al, 1

Move:   
        add     bx, ax                  ; BX = New position in maze

        test    [byte bx], dh           ; DH = 01h, test for WALL or BEGIN
        jz      Invalid                 ; (don't go to no-go area)

        cmp     [byte bx+si], ch        ; Do not revisit visited
        jne     Invalid                 ; positions

        sub     [byte bx+si], al        ; Update backtracking tables

        xchg    ax, bx                  ; 
        stosw                           ; Enqueue new position
        xchg    ax, bx                  ;

Invalid:sub     bx, ax                  ; Back to original position

        neg     ax                      ;
        js      Move                    ; Loop for ax={-1,+1,-100,+100}
        add     al, 99                  ;
        jno     Move                    ;

        pop     bx                      ; Dequeue

        test    [byte bx], dl           ; DL = xxxxxx10b, test for BEGIN/EXIT
        jz      BFS                     ;  BEGIN won't be revisited, so this
                                        ;  detects EXIT very effectively

        ; Reconstruction phase

Recon:  mov     al, [byte bx+si]        ; Get backtracking info
        cbw                             ;
        add     bx, ax                  ; Go to previous positon
        xor     [byte bx], 091h         ; Mark position as SOLUTION
        jpe     Recon                   ; Repeat until at BEGIN

        ; The XOR+JPE works since
        ; 1) 01h ^ 91h => 90h (parity even), done until at BEGIN position
        ; 2) 02h ^ 91h => 93h (parity even), backtracking doesn't change
        ;                     position since tables were zeroed
        ; 3) 93h ^ 91h => 02h (parity odd), BEGIN left "unaltered",
        ;                     reconstruction ends


        ; AX = 0000h (from last iteration of prev. loop)
        ; CX = 0000h (from loop above)
        ; DX = 01F2h
        ; SI = 2710h = 10000d

        push    cx              ; Return to zero offset; program termination

        mov     ah, 03ch
        mov     bh, 040h
        mov     dl, low offset outputfile       ; dh already 1
FileIO: int     21h
        xchg    ax, bx
        mov     cx, 10000
        mov     dl, 0FEh                ; Load/write to/from 01FEh ->
        int     21h                     ; offset must be xxxxxx10b

        retn



outputfile      db "tour",0
inputfile       db "MINO",0



        END Start
