	page	240, 132
;ENTRY.ASM	APR-28-00
; by Boreal
; email: loren_blaney@idcomm.com
;
;                    t h e  -  " M O N S T E R "  -  c o m p o
; Ŀ  Ŀ   Ŀ       Ŀ        Ŀ
; ۳  ۳Ŀ۳    ۳
; ۳Ŀ۳۳    ۳
; ۳۳  Ŀ۳    Ŀ۳
; Ŀ  Ŀ            
;   ٱٱĿٱĿ
;   Ŀٳ
;         
;         H U G I  -  S I Z E  -  C O D I N G  -  C O M P O  -  # 1 1
;
;This program finds the shortest path through a maze using breadth-first search.
; Like the mythological Theseus this program navigates its way to the exit.
; Thankfully there is no Minotaur to contend with.
;
;The maze is the input file "MINO". The shortest path is marked and output as
; the file "TOUR".
;
;This version traces the path backwards from EXIT (03) to BEGIN (02).
;
;Assemble with:
; tasm /m entry
; tlink /t entry

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h
start:	dec	bp			;code doubles as I/O file names:
	imul	cx, [bp+4Fh], 5400h	; i.e: db 'MiNO', 0   ;inName
	dec	di			; i.e: db 'TOUr', 0   ;outName
	push	bp
	jc	$+2
outName	equ	0105h

	pop	di			;loc of Previous array = bp = 09xx-1
	xchg	si, ax			;initialize index for later; si:= 0
	xchg	dx, ax			;dx:= inName
	mov	ax, 3D3Fh		;function numbers to open and read file
	call	m90			;do common I/O code

;Initialize 'Previous' array with 02's (something to distinguish from +/-1, 100)
;assume cx=10000, dx=Maze, di=bp=09xx-1
	xchg	ax, dx			;al:= 02
	rep stosb			;es:[di++]:= al; cx:= 0

;Find EXIT (03) location in Maze array
;assume si=0
	xchg	bx, ax			;bx:= Maze array
m05:	inc	si			;first location is a WALL (00)
	cmp	[bx+si], bl		;does location contain EXIT (03)?
	jbe	m05			;loop until it does
					;si = index to EXIT location in Maze
	mov	ax, di			;Queue starts at end of 'Previous' array

;Do breadth-first search
;Register usage:
; ax = Queue empty pointer
; bx = Maze array
; cx = 0
; dx = direction (Dir: +1, -1, +100, -100)
; si = Base / Inx location in Maze
; di = Queue fill pointer
; bp = 'Previous' array

;assume ax<8000h
m10:	cwd				;for 4 directions: +1, -1, +100, -100...
	inc	dx			;dx:= 1

m15:	add	si, dx			;Inx:= Base + Dir

	cmp	[bp+si], bl		;if Prev(Inx) = 02 then loc not used yet
	jne	m18			;jump if location is already visited
	cmp	[bx+si], bl		;check Maze(Inx)
	jnp	m18			;jump if WALL (00) or EXIT (03)
	mov	[bp+si], dl		;Prev(Inx):= Dir; also indicates visited
	je	m30			;jump if BEGIN (02) location--exit loop

	xchg	ax, si			;Queue:= Inx; es:[di++]:= ax
	stosw				;Enqueue
	xchg	ax, si			;restore Queue empty pointer
m18:
	sub	si, dx			;restore Base location

	neg	dx			;next direction: 1, -1, +100, -100
	js	m15
	dec	dx			;test for +1
	mov	dl, 100			;next direction:= +100
	je	m15			;loop for 4 directions

	xchg	si, ax			;get Queue empty pointer
	lodsw				;Base:= Queue; ax:= ds:[si++]
	xchg	si, ax			;Dequeue
	jmp	m10			;loop until BEGIN (02) is found

;At this point the shortest path has been found. Mark it with 90h's.
m20:	mov	[bx+si], bh		;Maze(Base):= 90h
m30:	mov	al, [bp+si]		;Base:= Prev(Base)
	cbw				;previous base:= Base - Dir
	sub	si, ax
	cmp	[bx+si], bl
	jbe	m20			;loop until EXIT (03) is found

;Write Maze solution to output file.  (Thanx go to Sniper who hinted that I&O
; could be done in 28 bytes cuz they were almost identical.)
;assume cx=0 = no file attributes = normal
	mov	dx, offset outName	;dx:= output file name
	mov	ax, 3C40h		;function numbers to create & write file
m90:	xchg	bh, al			;the ol' switcheroo
	int	21h			;ax:= file handle
	mov	dx, offset Maze		;memory array to read/write
	mov	cx, 10000		;number of bytes to read/write
	xchg	ax, bx			;ah:= function number; bx:= handle
	int	21h
	ret

	org	0A00h			;worst case (+1) for bp = 09xxh -1
;These labels are for documentation purposes only--the actual locations vary
Previous db	10000 dup (?)		;contains direction from previous loc
Queue	 dw	10000 dup (?)		;contains Maze locations (Inx)
QEnd	equ	$			;must be <= 8000h for cwd instruction

	org	9002h			;a very useful number
Maze	db	10000 dup (?)		;100x100 maze array

cseg	ends
	end	start
