
; MAZE by Aphex
; compile:      tasm /m maze
;               tlink /x/t maze
; this is my first entry in Hugi's compo
; so hope you don't mind i used Fabled's sample program as a basis

p286
model tiny
codeseg
startupcode

	; equals for loading the offsets using only the low byte - we're a small com!
maze_short      equ     offset maze - 100h
save_short      equ     offset save - 100h
prev_delta	equ	- (offset maze - 30000)
mark		equ	90h - 1

start:
init:
	mov     di, offset queue        ; di -> queue
	push	di
	mov     ch, 40000 / 256 + 1     ; cx = 40192 in debug / 40447 in run-time - some extra bytes are filled but no consequences
	mov     ax, 3d00h		; ah = 0x3d = open file cmd, al = 0 = fill data
	rep     stosb                   ; fill the queue and prev arrays
read:
	mov     dx, offset load         ; dx -> "MINO"
	mov     bh, 3fh
	call	file_io_call
solve:
	mov     di, dx                  ; di -> maze
	mov     al, 2
	repne   scasb                   ; look for start position
	dec     di
	mov	cx, di
	pop	di
	mov	bp, di
	mov	si, prev_delta

	; bfs: bp - head, di - tail
bfs:
	mov	ax, -199
additem:
	add	al, 99			; next direction (-100, -1, 1, 100)
	jnc	$+4			; sign changed?
	aad	97			; adjust
	add 	ax, cx
	mov	bx, ax

	cmp	byte ptr [bx], 0
	je      additemover             ; wall?

	add     bx, bx
	add	bx, si          	; bx -> prev
	cmp     word ptr [bx], 0
	jne     additemover             ; not initialized?

	mov     [bx], cx                ; add it in prev array
	stosw                           ; write in queue
additemover:
	sub	ax, cx

	cmp	al, 100
	jne	additem
	mov	cx, [bp]                ; read from queue
	inc	bp
	inc 	bp

	mov	bx, cx
	cmp	byte ptr [bx], 3
	jne	bfs   			; exit reached?

find:                                   ; the way back
	add     bx, bx
	mov	bx, [bx + si]
	add	byte ptr [bx], mark     ; mark the path
	jp      find
done:
	sub	byte ptr [bx], mark
write:
	xor     cx, cx
	mov     ah, 3ch
	mov     dl, save_short          ; dx -> "TOUR"
	mov     bh, 40h
file_io_call:
	int     21h                     ; open / create the file
	xchg	bx, ax 			; bx = handle
	mov     cx, 10000
	mov     dl, maze_short          ; dx -> maze
	int     21h                     ; read / write the maze
exit:					; files are not closed as terminating the program causes all files to close

	ret

load    db      'MINO',0
save    db      'TOUR'			; 1 cell wall border = 0
maze    db      10000 dup(?)
queue   dw      10000 dup(?)
prev    dw      10000 dup(?)

end
