;
;                                 LBM-READ
;                                
; This is a demonstration how to depack a 256 color LBM-file.
; The main-routine is called 'depack_LBM' !
; You can use this piece of code freely.......
; This routine is made to depack pictures with a resolution of 320*200 pixel.
;
;                                                      Capella/Escape
;

ideal
model large
p386n
stack 256

assume cs:coding

segment  coding

start:        mov ax,pcxdata
              mov ds,ax
              assume ds:pcxdata
               
              mov ax,0a000h
              mov es,ax
              assume es:0a000h

              mov ax,0013h
              int 10h

;
;                        LOADROUTINE FOR THE PICTURE
;

              mov ax,3d02h
              mov dx,offset file
              int 21h
              jc error
              mov bx,ax

              mov ah,3fh
              mov dx,offset puffer
              mov cx,0ffffh
              int 21h
              jc error
              mov [ds:file_length],ax

              mov ah,3eh
              int 21h
              jc error

              call depack_lbm

              call set_colors
              
warte:        in al,60h
              cmp al,01h
              jne warte

              mov ax,0003h
              int 10h
              mov ax,4c00h
              int 21h

error:        mov ax,0003h
              int 10h
              mov dx,offset etxt
              mov ah,09h
              int 21h
              jmp warte

;
;                          THE LBM-DEPACK-ROUTINE
;

depack_lbm:   mov si,offset puffer
              push si

              mov cx,[ds:file_length]
              mov ebx,"PAMC"          ; searching for CMAP-signature
search_col:   mov eax,[ds:si]
              cmp eax,ebx
              je colors_found
              inc si
              dec cx
              jnz search_col

              pop si

              mov ax,0003h
              int 10h
              
              mov ah,09h
              mov dx,offset no_col
              int 21h
              jmp warte

colors_found: add si,8
              mov [ds:color_table],si

              pop si

              mov cx,[ds:file_length]
              mov ebx,"YDOB"           ; searching for BODY-signature
search_gfx:   mov eax,[ds:si]
              cmp eax,ebx
              je bitmap_found
              inc si
              dec cx
              jnz search_gfx

              mov ax,0003h
              int 10h
              mov ah,09h
              mov dx,offset no_gfx
              int 21h
              jmp warte

bitmap_found: add si,8
              mov [ds:bitmap_table],si
              xor di,di

check_byte:   mov al,[ds:si]
              mov ah,al
              cmp di,64000
              jae bitmap_end
              and al,10000000b
              cmp al,80h
              je byte_row
              
single_bytes: mov cl,ah
              xor ch,ch
              inc cx
              inc si

copy_bytes1:  mov al,[ds:si]
              mov [es:di],al
              inc si
              inc di
              dec cx
              jnz copy_bytes1

              jmp check_byte

byte_row:     mov cl,ah
              xor ch,ch
              dec cx
              inc si
              
copy_bytes2:  mov al,[ds:si]
              mov [es:di],al
              inc di
              inc cx
              cmp cx,0100h
              jne copy_bytes2
              inc si
              jmp check_byte

bitmap_end:   ret
;
;                      SET THE COLORTABLE OF THE PCX FILE
;

set_colors:   mov si,[ds:color_table]
              mov dx,03c8h
              xor al,al
              out dx,al
              inc dx
              mov cx,256
copy_colors:  mov al,[ds:si]
              shr al,2
              out dx,al
              mov al,[ds:si+1]
              shr al,2
              out dx,al
              mov al,[ds:si+2]
              shr al,2
              out dx,al
              add si,3
              dec cx
              jnz copy_colors
              ret


ends  coding

segment  pcxdata

file           db "testgfx.lbm",0
etxt           db "error appears.....$"
no_col         db "No colortable found....$"
no_gfx         db "No bitmap found....$"

file_length    dw ?
bitmap_table   dw ?
color_table    dw ?

puffer         db 64000 dup (?)

ends  pcxdata

end start


