{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}
{ *** SBMusicDemo.PAS *** }
{ program demostruje uycie SBMULTI,UNIDSP }

Program SBMultiDemo;

Uses sbmulti, unidsp, crt;

Const
  max = 8192; {dugo prbki z sinusoid}
  notetable: Array [1..12] Of Word =     {gama C-DUR}
  (8363, 8865, 9397, 9960, 10558, 11192,
  11863, 12575, 13329, 14129, 14576, 15875);
  chartable: String [64] =             {klawisze}
  'Z S X D C V G B H N J M ,QL2.W;3' +
  '/ER 5 T 6 Y 7 U I 9 O 0 P [ = ] ';
  music: String [64] = 't+q++r+yt+q++t+reertq+w+e+++++++' +
  't+q++r+yt+q++t+reertq+w+q+++++++';
  nuty: String [24] = 'C-C#D-D#E-F-F#G-G#A-A#H-';
  
Var
  channel: Byte;
  
Procedure PlayNote (oct, note: Byte);
Var frq: Word;                   {odtwarza nut}
Begin                            {oct-oktawa}
  frq := notetable [note];       {note-nuta(1-12)}
  If oct = 2 Then frq := frq * 2;
  If oct = 3 Then frq := frq * 4;
  playsample (channel, 1, frq, 64, 0);
  Inc (channel);
  If channel = 4 Then channel := 0;
End;

Var
  p: pointer;
  i: Word;
  f: File;
  CH: Char;
  b, oct, note: Byte;
  playing: Boolean;
  nuta: String;
  
Begin
  playing := False;
  ClrScr;
  WriteLn ('*** Multi-Channel Keyboard ***');
  WriteLn;
  WriteLn ('klawisze muzyczne -> jak na Scream Tracker');
  WriteLn ('ESC -> koniec');
  WriteLn ('ENTER -> przykladowa muzyka');
  GetMem (p, max);
  For i := 0 To max - 1 Do Begin
    b := Round ( (Sin (i / 10) + Sin (i / 20) +
    Sin (i/2) ) / 3 * ( (100/max) * (max-i-1) ) + 128);
    mem [Seg (p^): Ofs (p^) + i] := b;
  End;                  {tworzenie sampla}
  makesample (p, 1, max, False, 0, 0);
  setport (dspsb, $220);    {Sound Blaster}
  InitializeDSP;
  mixerstart (12000);     {Rozpoczcie miksowanie}
  b := 1;       { |- czstotliwo miksowania}
  Repeat
    If KeyPressed Then
      CH := UpCase (ReadKey)
    Else
      CH := #0;
    If playing And (unitimer = 0) And (CH = #0) Then Begin
      CH := UpCase (music [b] );
      Inc (b);
      unitimer := 4;  { <- odstp midzy nutami }
      If b > Length (music) Then b := 1;
    End;
    For i := 1 To 32 Do
      If (chartable [ (i - 1) * 2 + 1] = CH)
         Or (chartable [ (i - 1) * 2 + 2] = CH)
      Then Begin
        oct := (i - 1) Div 12 + 1;
        note := (i - 1) Mod 12 + 1;
        playnote (oct, note);
        Str (oct, nuta);
        nuta := Copy (nuty, (note - 1) * 2 + 1, 2) + nuta;
        GotoXY (1, 7);
        ClrEol;
        Write (nuta);
      End;
    If CH = #13 Then If playing Then
      playing := False 
    Else playing := True;
  Until CH = #27;
End.
