/*
   Mauslibrary in Quick C                  Copyright (C) 1996 by The Real Adok

   Wer diese Routinen in seine eigene Programme einbauen will, wendet sich
   bitte an:

		  The Real Adok
		  Claus-Dieter Volko
		  Hungereckstrae 60/2
		  A-1230 Wien
*/

#include <stdio.h>  // STDIO.H wird nur fr das Demoprogramm bentigt!
#include <graph.h>  // GRAPH.H wird nur fr das Demoprogramm bentigt!
#include <dos.h>

union REGS reg;                        // Speicherung der Register
unsigned char  mouseleftbutton,        // linke Maustaste
	       mouserightbutton;       // rechte Maustaste
unsigned short mousex,                 // X-Koo. der Maus
	       mousey;                 // Y-Koo. der Maus

void screen(char nr);
void initmouse(void);
void showmouse(void);
void hidemouse(void);

void screen(char nr)
{
  reg.x.ax=nr;                // In Bildschirmmodus 'nr' wechseln
  int86(0x10,&reg,&reg);
}

void initmouse(void)
{
  reg.x.ax=0x0;               // Maustreiber initialisieren
  int86(0x33,&reg,&reg);
}

void showmouse(void)
{
  reg.x.ax=0x1;               // Mauscursor anzeigen
  int86(0x33,&reg,&reg);
}

void hidemouse(void)
{
  reg.x.ax=0x2;               // Mauscursor verstecken
  int86(0x33,&reg,&reg);
}

void getmousestatus(void)
{
  reg.x.ax=0x3;               // Mausstatus ermitteln
  int86(0x33,&reg,&reg);
  mousex=reg.x.cx;
  mousey=reg.x.dx;
  switch(reg.x.bx)
  {
    case 0: mouseleftbutton=mouserightbutton=0; break;
    case 1: mouseleftbutton=1; mouserightbutton=0; break;
    case 2: mouseleftbutton=0; mouserightbutton=1; break;
    case 3: mouseleftbutton=mouserightbutton=1; break;
  }
}

// ********** DEMOPROGRAMM **********

main()
{
  screen(0x12);               // Bildschirmmodus 12
  initmouse();                // Maustreiber initialisieren
  showmouse();                // Mauscursor anzeigen

  // Meldung auf dem Bildschirm ausgeben

  printf("Mauslibrary in Quick C\n");
  printf("Copyright (C) 1996 by The Real Adok\n\n");

  /*
     Schleife wird solange ausgefhrt, bis beide Maustasten gleichzeitig
     gedrckt werden
  */

  while(getmousestatus(), mouseleftbutton!=1 || mouserightbutton!=1)
  {
    _settextposition(4,1);
    printf("X-Koordinate: %u   \n",mousex);
    printf("Y-Koordinate: %u   \n",mousey);
    printf("Linke Taste : %u   \n",mouseleftbutton);
    printf("Rechte Taste: %u   \n",mouserightbutton);
  }

  hidemouse();                // Mauscursor verstecken
  screen(0x2);                // Textmodus
}
