/**************************************************************************
 $Module: dltpack               $Filename: dlt.c

 $Revision 1.2$             $State$

 $Author: helmut gaberschek$
 $Date$

 $Description
	A small module to delta-compress 16 bit integer data.

	Remove the main part, if you want to use it as module.

	Use defines instead of functions for dltGetElement and
	dltSetElement to gain some more performance.
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "dlt.h"

#define  DLT_COMPRESSION_HEADER         ((unsigned int) (1L<<16 - 1))

struct dltControl
{
   unsigned long   ul_DataCount;
   
   unsigned int  * pui_Source;
   unsigned int  * pui_Dest;
  
   unsigned int    ui_Minimum;          /* minimal count of same values to start compression */
   
   unsigned long   ul_OutputSize;
};
   
struct dltControl dlt;

/* a small test function */
void main(void)
{
   unsigned int s[30] = {1,2,3,4,5,5,5,1,6,6,6,6,7,8,8,8,8,8,8};
   unsigned int d[30];
   unsigned long i;

   dltInit(19, s, d, 4);
   
   dltPack();

   for (i = 0; i < 19; i++)
      fprintf(stdout, " %d ", dlt.pui_Dest[i]);
   
   i = dltDone();
   
   fprintf(stdout, "\n Output size : %ld", i);
}   

void dltInit(unsigned long count, unsigned int *source, unsigned int *dest, unsigned int minimum)
{
   dlt.ul_DataCount = count;
   
   dlt.pui_Source   = source;
   dlt.pui_Dest     = dest;
   
   dlt.ui_Minimum   = minimum;
}   

unsigned int dltGetElement(unsigned long index)
{
   return dlt.pui_Source[index];
}

void dltSetElement(unsigned long index, unsigned int value)
{
   dlt.pui_Dest[index] = value;
}

int dltCheckNElements(unsigned long start, unsigned long range)
{
   unsigned long i;
   unsigned long end = start + range;
   int           result = 0;
      
   if (end <= dlt.ul_DataCount)
   {
      for (i = start; (i < end - 1) && 
		      (dltGetElement(i) ==  dltGetElement(i+1));  i++);
		      
      if (i == (end -1))
	 result = 1;
   }
   
   return result;
}

void dltPack(void)
{
   unsigned long i;
   unsigned long leftIndex = 0;
   unsigned long destIndex = 0;
   unsigned long rightIndex = leftIndex + dlt.ui_Minimum - 1;
   
   while(leftIndex < dlt.ul_DataCount) /* so that all elements are written to the output! */
   {
      if (dltCheckNElements(leftIndex, dlt.ui_Minimum))
      {
	 i = leftIndex + dlt.ui_Minimum - 1;      
      
	 while ((i < dlt.ul_DataCount - 1) && 
		(dltGetElement(i) == dltGetElement(i+1)))
		i++;
		
	 dltSetElement(destIndex++, DLT_COMPRESSION_HEADER);
	 dltSetElement(destIndex++, i - leftIndex + 1);
	 dltSetElement(destIndex++, dltGetElement(leftIndex));
	 
	 leftIndex = i+1;
      }
      else
      {
	 dltSetElement(destIndex++, dltGetElement(leftIndex));
      
	 leftIndex++;
      }
   }
   
   dlt.ul_OutputSize = destIndex;   
}

unsigned long dltDone(void)
{
   return dlt.ul_OutputSize;
}
