//***************************************************************************
//*  (K) Kopyright 1997-1998 K!Prod, DefCoN Mag Video Librairy, by ArraKiS  *
//*  Feel free to use but do distribute the complete package (V0.30)       *
//*                                                                         *
//*  Thanks to EgoN/K!Prod for all the Info about VESA 2.0                  *
//*  Thanks to Babylon/Revelation for his VESA LIBRARY SOURCE V2.0          *
//*  Now, my ChkVesa and ChkVesaMode are clean and structured!              *
//*  Created (DefCoN #1) : 15/06/97  (V0.1)                                *
//*  Complete Rewrite    : 25/09/97  (V0.2)                                *
//*  Last Update         : 25/06/98  (V0.30)                               * 
//***************************************************************************
#include <fcntl.h>
#include "K!Video.h"

char *error_message[]={"< NO ERRORS >",
                       "< DOS memory allocation failed >",
                       "< DOS interrupt failed >",
                       "< VESA not supported >",
                       "< DOS memory deallocation failed >",
                       "< Requested video mode not found >",
                       "< Wrong VESA mode >",
                       "< Cannot map memory >",
                       "< Bank switching not really available >",
                       "< Bad window A attributes >",
                       "< Can't unmap memory >",
                       "< No mode have been selected >"};

static byte WP[768];

VideoBuffer GetVideoBuffer( word X, word Y, word BPP)
{ int Taille;
  VideoBuffer enreg;

  Taille=(X*Y*BPP)>>3;              // X*Y*(Bpp/8)
  enreg.Address =(char *)malloc(Taille);
  enreg.X=X;
  enreg.Y=Y;
  enreg.BPP=BPP;
  return enreg;
}

void FreeVideoBuffer(VideoBuffer enreg)
{ free(enreg.Address);
  enreg.Address=(char *)0;
  enreg.X=0;
  enreg.Y=0;
  enreg.BPP=0;
}

// SelectMode renvoie le numero de l'erreur... donc si SelectMode est vrai
// il y a eu une erreur... sinon tout va bien ...
int SelectMode(int X, int Y, int BPP)
{ if (!VESAChecked) ChkVESA();// recupere toute les caracteristiques de la carte video
   ChkVESAMode(X,Y,BPP);                     // cherche le mode VESA/VESAX.
  if (ReturnCode==5 || ReturnCode==6)        // mode introuvable ou VGA !!!
//   if (IsVGA())                              // La carte est VGA au moins ?
    if (X==320 && Y==200 && BPP==8) InitMode13h();            // mode VGA ?
    else ChkModeX(X,Y,BPP);                            // ModeX peut etre ?
  return ReturnCode;                         // bah, je connais pas alors !
}

// Pas Tres Joliment programmer
// Mais evite de demander plusieurs moi les infos a la carte video
// Dans le cas de mode VESA LFB, on evite ainsi de mapper et demapper
// la video en RAM a tout va ...
int SearchMode(word X, word Y, word BPP)
{ word nbmode;
  if (!VESAChecked) ChkVESA(); 
// On cherche parmi les mode VESA de la carte
  nbmode=0; 
  while (nbmode<VESA_NbMode)
  { if ( X==VESA_ModeList[0+5*nbmode]
      && Y==VESA_ModeList[1+5*nbmode]
    && BPP==VESA_ModeList[2+5*nbmode]) return(1);
    nbmode++;
  } 

// puis parmi les Mode VESAX
nbmode=0;
if (X==640)                         // 640x???x??b
  while (nbmode<VESA_NbMode)
  { if (VESA_ModeList[0+5*nbmode]==640 && VESA_ModeList[1+5*nbmode]==480)
     if (BPP==VESA_ModeList[2+5*nbmode])
      if (Y==200 || Y==240 || Y==256 || Y==350 ||
          Y==400 || Y==512 || Y==564 || Y==600) return(1);
    nbmode++;
  } 

if (X==320)                         // 320x???x??b
  while (nbmode<VESA_NbMode)
  { if (VESA_ModeList[0+5*nbmode]==320 && VESA_ModeList[1+5*nbmode]==200)
     if (BPP==VESA_ModeList[2+5*nbmode])
      if (Y==240 || Y==256 || Y==400 || Y==480 || Y==512) return(1);
    nbmode++;
  } 

// ModeX !!
if (X==320 || X==360 || X==400)
 if (Y==200 || Y==224 || Y==240 || Y==256 || Y==270 || Y==282 ||
     Y==300 || Y==360 || Y==400 || Y==448 || Y==480 || Y==512 ||
     Y==540 || Y==564 || Y==600) return(1);

return(0); // pas trouve !!
}

void Copy2Screen(char* Address)
{   if (ModeX_Engaged) VSwpscrM_X(Address);
    else if (VESA_LFB) VSwpscrLFB(Address);
    else VSwpscrBAN(Address);
}

void ClrScr(void)
{ if (ModeX_Engaged) ClsM_X();
  else if (VESA_LFB) ClsLFB();
  else ClsBAN();
}

void BlackPal(void)
{ int i; for(i=0; i<256; i++) SetColor(i,0,0,0); }

void SetPal(byte *WPt)
{ int i;
  for (i=0; i<256; i++) SetColor(i, WPt[(i*3)], WPt[(i*3)+1], WPt[(i*3)+2]);
}

void SetZPal(byte *WPt, byte deb, byte fin)
{ int i;
  for (i=deb; i<fin; i++) SetColor(i, WPt[(i*3)], WPt[(i*3)+1], WPt[(i*3)+2]);
}

void FadeP1ToP2(byte P1[], byte P2[], int frames)
{ int i, j, k;

  for (k=0; k<=frames; k++)
   { for(i=0; i<=255; i++)
     { j=i*3; 
       WP[j]   = ( (P1[j]  *(frames-k)) + (P2[j]  *k) )/frames;
       WP[1+j] = ( (P1[1+j]*(frames-k)) + (P2[1+j]*k) )/frames;
       WP[2+j] = ( (P1[2+j]*(frames-k)) + (P2[2+j]*k) )/frames;
     } WaitVbl();
     SetPal (WP);
   }
}

void FadePal2Black (byte PaletteIn[], int frames)
{ int i,j,Intensity;

  for(Intensity=frames;  Intensity>=0; Intensity--)
   { for (i=0; i<=255; i++)
     { j=i*3;
       WP[j]   = (PaletteIn[j]   * Intensity) /frames;
       WP[1+j] = (PaletteIn[1+j] * Intensity) /frames;
       WP[2+j] = (PaletteIn[2+j] * Intensity) /frames;
     } WaitVbl();
     SetPal (WP);
   }
}

void FadeNow2Black (int frames)
{ byte PalIn[768];
  int i,j,Intensity;

  GetPal(PalIn);
  for(Intensity=frames;  Intensity>=0; Intensity--)
   { for (i=0; i<=255; i++)
     { j=i*3;
       WP[j]   = (PalIn[j]   * Intensity) /frames;
       WP[1+j] = (PalIn[1+j] * Intensity) /frames;
       WP[2+j] = (PalIn[2+j] * Intensity) /frames;
     } WaitVbl();
     SetPal (WP);
   }
}

void FadePalFromBlack (byte PaletteIn[], int frames)
{ int i,j,Intensity;

  for(Intensity=1; Intensity<=frames; Intensity++)
   { for(i=0; i<=255; i++)
     { j=i*3;
       WP[j]   = (PaletteIn[j]   * Intensity) /frames;
       WP[1+j] = (PaletteIn[1+j] * Intensity) /frames;
       WP[2+j] = (PaletteIn[2+j] * Intensity) /frames;
     } WaitVbl();
     SetPal (WP);
   }
}

void FadePalZone2Black (byte PaletteIn[], int frames,byte deb, byte fin)
{ int i,j,Intensity;

  for(Intensity=frames;  Intensity>=0; Intensity--)
   { for (i=deb; i<=fin; i++)
     { j=i*3;
       WP[j]   = (PaletteIn[j]   * Intensity) /frames;
       WP[1+j] = (PaletteIn[1+j] * Intensity) /frames;
       WP[2+j] = (PaletteIn[2+j] * Intensity) /frames;
     } WaitVbl();
     SetZPal (WP,deb,fin);
   }
}

void MakeFadePal(byte cstart, byte r1, byte g1, byte b1,
                 byte cend,   byte r2, byte g2, byte b2)
{ static int i;
  int rval,gval,bval;
  int rt,gt,bt, tt;

  tt=cend-cstart;
  rt=((r2-r1)<<8)/tt;   gt=((g2-g1)<<8)/tt;   bt=((b2-b1)<<8)/tt; 

  rval=r1<<8;        gval=g1<<8;       bval=b1<<8;

  for(i=cstart;  i<=cend; i++)
   { SetColor(i,rval>>8,gval>>8,bval>>8);
     rval+=rt; gval+=gt; bval+=bt;
   }
}

void WriteModeInfo(void)
{ printf("\nMode Selected: 0x%X %dx%dx%dbpp (BPPHard:%dbits)\n",
                                                      VESA_SelectMode &0xBFFF,
                                                      VESA_SelectModeMaxX,
                                                      VESA_SelectModeMaxY,
                                                      VESA_SelectModeBPP,
                                                      VESA_SelectTrueBPP);
   if (VESA_SelectMode&0x4000) printf("Linear Frame Buffer Used\n");
   if ((VESA_SelectModeMaxX==640 && VESA_SelectModeMaxY==360) ||
       (VESA_SelectModeMaxX==320 && VESA_SelectModeMaxY==180))
    printf("Special 16/9 ");
   if (VESAX_Engaged) printf("VESAX Mode Used\n");
   if (ModeX_Engaged) printf("VGA ModeX Used\n");
   else if (VESA_SelectMode<0x100) printf("Mode VGA Standart Used\n");
}

void SwapPointer(char *_1st,char *_2nd)
{ char *t;
  t=_1st; _1st=_2nd; _2nd=t;
}

int readGIF(byte *nomfic,byte *dest,byte *pal)
{ struct { byte    sign[3];         // signature GIF
           byte    nuver[3];        // numero de version
           struct { word xscr;      // largeur de l'ecran
                    word yscr;      // hauteur de l'ecran
                    byte resflag;   // indicateur de resolution
                    byte coulfond;  // couleur de fond
                    byte par;       // pixel aspect ratio
                  } LSDB;          
           byte    GCM[768];        // Global color map (la palette kwa !)
           struct { byte ish;       // image separator header ',' (2Ch)
                    word xabs;      // abscisse x du coin sup gauche
                    word yabs;      // abscisse y du coin sup gauche
                    word imlar;     // largeur de l'image
                    word imhau;     // hauteur de l'image
                    byte flag;      // one morreuuu flageuuu
                  } IDB;            // image descriptor block
         } GIFHeader; 

        int i,fic,ficlong;
        char *buf;
        static byte *PalSrc;

        if((fic=open(nomfic,O_RDONLY|O_BINARY))==-1)   //si impossible d'ouvrir le fichier
          return(-1);                                                                                     // retourne -1

        ficlong=filelength(fic);                                                    // recupere la longueur du fichier
        buf=(byte*)malloc(ficlong);

        read(fic,buf,ficlong);
        MemCopy((char *)buf,(char *)&GIFHeader,791);   // puis on recupere l'entete

  PalSrc=GIFHeader.GCM;                // on convertit la palette 
  for(i=0;i<256;i++)
  {     *pal=*PalSrc>>2;
        *(pal+1)=*(PalSrc+1)>>2;
        *(pal+2)=*(PalSrc+2)>>2;
        pal+=3; PalSrc+=3;
  }

        lisgif(buf+791+1,dest);             // decompression dans [dest]

        close(fic);
        free(buf);
        return(0);
}


// Beta Unfinished and bugged read 32b TARGA (no reverse made)
void readTGAr32(char *fichier, char *buffer, int Size)
{ byte buf[18];
  int ficlen, fic;

    fic=open(fichier,0x0200);
    read(fic,buf,18);   // Il faudrait recuperer la taille bans le header
    lseek(fic,18+buf[0],0);
    read(fic,buffer,Size*4);
    close(fic);

}
