' BIN-HEX-OKT-DEZ-Wandler
' Umwandeln in verschiedene Zahlensysteme (begrenzt auf 32 Bit)
'
' PowerBasic3.2&PowerToolsII2.0
' Januar 1997
'
' Freeware 1997, Copyright Frank Groe, Alle Rechte vorbehalten
' VfB Hose, Frank Groe, Neuer Weg 6, 04617 Kriebitzsch
'
' Alle Dateien kopieren!

%mouse=1
$include "stdio.h"
$include "win_man.h"

on error resume next

screen 0
color ,6
cls

DIM tsum1(32) as shared string
DIM tsum2(32) as shared string

shared modus%,last%,operand$,dattyp%,zwi$,ope%,fehler%,vorzeichen%
shared uebertrag%,erg$

%HEX=1:%BIN=2:%DEZ=3:%OKT=4
%BYTE=11:%WORD=12:%DWORD=13

taschenrechner
rechnerinit
modus%=%DEZ

fprint 21,10,"Tastenkrzel"
fprint 23,10,"F1                  Modus Hexadezimal"
fprint 24,10,"F2                  Modus Binr"
fprint 25,10,"F3                  Modus Oktal"
fprint 26,10,"F4                  Modus Dezimal"
fprint 28,10,"F7                  Modus BYTE im Binrmodus"
fprint 29,10,"F8                  Modus WORD im Binrmodus"
fprint 30,10,"F9                  Modus DWORD im Binrmodus"
fprint 32,10,"F10                 Ende"
fprint 33,10,"ESCAPE              Rechner-Reset"
fprint 34,10,"BACKSPACE           Lscht letzte Ziffer (dient zur Korrektur)"
fprint 36,10,"-                   Negation an/aus"
fprint 37,10,"0-9                 Ziffern fr Zahlen"
fprint 38,10,"A-F                 Buchstaben fr Hexadezimalzahlen"
fprint 42,10,"Zur Bearbeitung negativer Binrzahlen unbedingt die Hinweise"
fprint 43,10,"im Anleitungs-Text-File beachten, da sonst Fehler in der Be-"
fprint 44,10,"arbeitung nicht ausgeschlossen sind."

do

 fehlermeldung

 if modus%=%BIN then
  select case dattyp%
   case %BYTE: fprint 12,55,"Modus:  BYTE"
   case %WORD: fprint 12,55,"Modus:  WORD"
   case %DWORD: fprint 12,55,"Modus: DWORD"
  end select
 else
  fprint 12,55,"            "
 end if

 if len(operand$)>32 then fehler%=5:fehlermeldung
 operand$=left$(operand$,32)
 if modus%=%BIN then
  fprint 5,10,str$(len(operand$))
 else
  fprint 5,10,"      "
 end if

 operand#=val(operand$)
 if modus%=%DEZ then
  if vorzeichen%=0 then
   if operand#>4294967295 then
   fehler%=1:fehlermeldung
   end if
  end if
  if vorzeichen%=1 then
   if operand#<-2147483648 then
   fehler%=4:fehlermeldung
   end if
  end if
 end if
 if modus%=%OKT then
  if operand#>37777777777 then
  fehler%=2:fehlermeldung
  end if
 end if
 if modus%=%HEX then
  if len(operand$)>8 then
  fehler%=3:fehlermeldung
  operand$=left$(operand$,8)
  end if
 end if

 a$=operand$

 a$=space$(32-len(a$))+a$
 printf 5,35,a$,15

 eingabe%=mkinp%(maus%)
 b%=(eingabe% and 255)
 tas%=b% or 32

 select case eingabe%
  case %ESC: rechnerinit
  case %F1: last%=modus%:modus%=%HEX:if operand$<>"" then modiumwandlung
  case %F2: last%=modus%:modus%=%BIN:if operand$<>"" then modiumwandlung
  case %F3: last%=modus%:modus%=%OKT:if operand$<>"" then modiumwandlung
  case %F4: last%=modus%:modus%=%DEZ:if operand$<>"" then modiumwandlung
  case %F7: dattyp%=%BYTE
  case %F8: dattyp%=%WORD
  case %F9: dattyp%=%DWORD
  case %F10: end
  case %BACK: operand$=left$(operand$,len(operand$)-1)
  case else
           select case tas%
            case 45: operandenbilden(16)
            case 48: operandenbilden(0)
            case 49: operandenbilden(1)
            case 50: operandenbilden(2)
            case 51: operandenbilden(3)
            case 52: operandenbilden(4)
            case 53: operandenbilden(5)
            case 54: operandenbilden(6)
            case 55: operandenbilden(7)
            case 56: operandenbilden(8)
            case 57: operandenbilden(9)
            case 97: operandenbilden(10)
            case 98: operandenbilden(11)
            case 99: operandenbilden(12)
            case 100: operandenbilden(13)
            case 101: operandenbilden(14)
            case 102: operandenbilden(15)
           end select
 end select

loop

mkillaction maus%
end

sub modiumwandlung
if vorzeichen%=1 then
 if last%=%DEZ and modus%=%BIN then NEGDEZtoBIN
 if last%=%BIN and modus%=%DEZ then NEGBINtoDEZ
end if
if vorzeichen%=0 then
 if last%=%DEZ and modus%=%BIN then DEZtoBIN
 if last%=%BIN and modus%=%DEZ then BINtoDEZ
end if
if last%=%DEZ and modus%=%HEX then DEZtoBIN:BINtoHEX
if last%=%DEZ and modus%=%OKT then DEZtoOKT
if last%=%HEX and modus%=%DEZ then HEXtoDEZ
if last%=%HEX and modus%=%BIN then HEXtoBIN
if last%=%HEX and modus%=%OKT then HEXtoDEZ:DEZtoOKT
if last%=%BIN and modus%=%HEX then BINtoHEX
if last%=%BIN and modus%=%OKT then BINtoDEZ:DEZtoOKT
if last%=%OKT and modus%=%DEZ then OKTtoDEZ
if last%=%OKT and modus%=%HEX then
 OKTtoDEZ
 DEZtoBIN
 BINtoHEX
end if
if last%=%OKT and modus%=%BIN then OKTtoDEZ:DEZtoBIN

 if modus%=%bin then
  select case dattyp%
   case %BYTE: for n%=1 to 8-len(operand$):operand$="0"+operand$:next n%
   case %WORD: for n%=1 to 16-len(operand$):operand$="0"+operand$:next n%
   case %DWORD: for n%=1 to 32-len(operand$):operand$="0"+operand$:next n%
  end select
 end if

end sub

sub negbintodez
if left$(operand$,1)<>"1" then fehler%=6:fehlermeldung
if left$(operand$,1)="1" then
 select case dattyp%
  case %BYTE
             sum2$="00000001"
             for n%=8 to 1 step -1
              tsum1(n%)=mid$(operand$,n%,1)
              tsum2(n%)=mid$(sum2$,n%,1)
             next n%
             for n%=8 to 1 step -1
              subtrahiere tsum1(n%),tsum2(n%)
             next n%
             for n%=len(erg$) to 1 step -1
              z$=mid$(erg$,n%,1):ergebnis$=ergebnis$+z$
             next n%
             operand$=ergebnis$
             for n%=1 to 8
              zwi$=mid$(operand$,n%,1)
              invertiere(zwi$)
              zahlnot$=zahlnot$+zwi$
             next n%
             operand$=zahlnot$
             bintodez
             operand#=val(operand$):operand#=0-operand#:operand$=str$(operand#)
  case %WORD
             sum2$="0000000000000001"
             for n%=16 to 1 step -1
              tsum1(n%)=mid$(operand$,n%,1)
              tsum2(n%)=mid$(sum2$,n%,1)
             next n%
             for n%=16 to 1 step -1
              subtrahiere tsum1(n%),tsum2(n%)
             next n%
             for n%=len(erg$) to 1 step -1
              z$=mid$(erg$,n%,1):ergebnis$=ergebnis$+z$
             next n%
             operand$=ergebnis$
             for n%=1 to 16
              zwi$=mid$(operand$,n%,1)
              invertiere(zwi$)
              zahlnot$=zahlnot$+zwi$
             next n%
             operand$=zahlnot$
             bintodez
             operand#=val(operand$):operand#=0-operand#:operand$=str$(operand#)
  case %DWORD
              sum2$="00000000000000000000000000000001"
              for n%=32 to 1 step -1
               tsum1(n%)=mid$(operand$,n%,1)
               tsum2(n%)=mid$(sum2$,n%,1)
              next n%
              for n%=32 to 1 step -1
               subtrahiere tsum1(n%),tsum2(n%)
              next n%
              for n%=len(erg$) to 1 step -1
               z$=mid$(erg$,n%,1):ergebnis$=ergebnis$+z$
              next n%
              operand$=ergebnis$
              for n%=1 to 32
               zwi$=mid$(operand$,n%,1)
               invertiere(zwi$)
               zahlnot$=zahlnot$+zwi$
              next n%
              operand$=zahlnot$
              bintodez
              operand#=val(operand$):operand#=0-operand#:operand$=str$(operand#)
 end select
end if
end sub

sub subtrahiere(z1$,z2$)
' Binre Subtraktion zweier Ausdrcke
if z1$ = z2$ and z1$ = "1" then
 if uebertrag% = 1 then
  erg$ = erg$ + "1": uebertrag% = 0
 else
  erg$ = erg$ + "0": uebertrag% = 0
 end if
end if
if z1$ = z2$ and z1$ = "0" then
 if uebertrag% = 1 then
  erg$ = erg$ + "1": uebertrag% = 1
 else
  erg$ = erg$ + "0": uebertrag% = 0
 end if
end if
if z1$ <> z2$ and z1$ = "1" then
 if uebertrag% = 1 then
  erg$ = erg$ + "0": uebertrag% = 0
 else
  erg$ = erg$ + "1": uebertrag% = 0
 end if
end if
if z1$ <> z2$ and z1$ = "0" then
 if uebertrag% = 1 then
  erg$ = erg$ + "0": uebertrag% = 0
 else
  erg$ = erg$ + "1": uebertrag% = 1
 end if
end if
end sub

sub negdeztobin
operand$=right$(operand$,len(operand$)-1)
deztobin
for n%=1 to 32-len(operand$)
 operand$="0"+operand$
next n%
for n%=1 to 32
 zwi$=mid$(operand$,n%,1)
 invertiere(zwi$)
 zahlnot$=zahlnot$+zwi$
next n%
operand$=zahlnot$
sum2$="00000000000000000000000000000001"
for n%=32 to 1 step -1
 tsum1(n%)=mid$(operand$,n%,1)
 tsum2(n%)=mid$(sum2$,n%,1)
next n%
for n%=32 to 1 step -1
 addiere tsum1(n%),tsum2(n%)
next n%
if uebertrag% then erg$=erg$+"1"
for n%=len(erg$) to 1 step -1
z$=mid$(erg$,n%,1):ergebnis$=ergebnis$+z$
next n%
operand$=ergebnis$
end sub

sub addiere (z1$,z2$)
' Binre Addition zweier Ausdrcke
if z1$ = z2$ and z1$ = "1" then
 if uebertrag% = 1 then
  erg$ = erg$ + "1": uebertrag% = 1
 else
  erg$ = erg$ + "0": uebertrag% = 1
 end if
end if
if z1$ = z2$ and z1$ = "0" then
 if uebertrag% = 1 then
  erg$ = erg$ + "1": uebertrag% = 0
 else
  erg$ = erg$ + "0": uebertrag% = 0
 end if
end if
if z1$ <> z2$ then
 if uebertrag% = 1 then
  erg$ = erg$ + "0": uebertrag% = 1
 else
  erg$ = erg$ + "1": uebertrag% = 0
 end if
end if
end sub

sub invertiere(zeichen$)
if zeichen$="0" then
 zwi$="1"
else
 zwi$="0"
end if
end sub

sub okttodez
for n%=len(operand$) to 1 step -1
 zwi$=mid$(operand$,n%,1)
 ope%=val(zwi$)
 erg#=ope%*8^pot%:incr pot%
 ergebnis#=ergebnis#+erg#
next n%
operand$=str$(ergebnis#)
end sub

sub bintodez
for n%=len(operand$) to 1 step -1
 zwi$=mid$(operand$,n%,1)
 ope%=val(zwi$)
 erg#=ope%*2^pot%:incr pot%
 ergebnis#=ergebnis#+erg#
next n%
operand$=str$(ergebnis#)
end sub

sub hextobin
for n%=1 to len(operand$)
 teil$=mid$(operand$,n%,1)
 select case teil$
 case "0": bi$="0000"
 case "1": bi$="0001"
 case "2": bi$="0010"
 case "3": bi$="0011"
 case "4": bi$="0100"
 case "5": bi$="0101"
 case "6": bi$="0110"
 case "7": bi$="0111"
 case "8": bi$="1000"
 case "9": bi$="1001"
 case "A": bi$="1010"
 case "B": bi$="1011"
 case "C": bi$="1100"
 case "D": bi$="1101"
 case "E": bi$="1110"
 case "F": bi$="1111"
 end select
 ges$=ges$+bi$
next n%
operand$=ges$
ges$="":bi$="":teil$=""
end sub

sub deztookt
zl#=val(operand$)
while zl#<>0
 teiler#=zl#/8
 teiler#=fix(teiler#)        'schneidet die Nachkommastellen ab
 if teiler#<1 then teiler#=0
 st#=zl#-(teiler#*8)
 s$=str$(st#)
 zl#=teiler#
 erge$=erge$+s$
wend
for n%=len(erge$) to 1 step -1
 z$=mid$(erge$,n%,1):if z$<>" " then real$=real$+z$
next n%
operand$=real$
end sub

sub hextodez
for n%=len(operand$) to 1 step -1
 zwi$=mid$(operand$,n%,1)
 dezzahl(zwi$)
 erg#=ope%*16^pot%:incr pot%
 ergebnis#=ergebnis#+erg#
next n%
operand$=str$(ergebnis#)
end sub

sub dezzahl(zeichen$)
select case zeichen$
 case "0": ope%=0
 case "1": ope%=1
 case "2": ope%=2
 case "3": ope%=3
 case "4": ope%=4
 case "5": ope%=5
 case "6": ope%=6
 case "7": ope%=7
 case "8": ope%=8
 case "9": ope%=9
 case "A": ope%=10
 case "B": ope%=11
 case "C": ope%=12
 case "D": ope%=13
 case "E": ope%=14
 case "F": ope%=15
end select
end sub

sub bintohex
bi$=operand$
for n%=1 to 32-len(bi$)
 bi$="0"+bi$
next n%
for n%=1 to 8
 zwi$=""
 select case n%
  case 1
  	for m%=1 to 4: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 2
        for m%=5 to 8: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 3
        for m%=9 to 12: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 4
        for m%=13 to 16: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 5
        for m%=17 to 20: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 6
        for m%=21 to 24: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 7
        for m%=25 to 28: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
        next m%: hexzahl(zwi$)
  case 8
  	for m%=29 to 32: zei$=mid$(bi$,m%,1):zwi$=zwi$+zei$
	next m%: hexzahl(zwi$)
 end select
 erg$=erg$+zwi$: if erg$="0" then erg$=""
next n%
operand$=erg$
erg$="":bi$="":zwi$=""
end sub

sub hexzahl(zeichen$)
select case zeichen$
 case "0000": zwi$ = "0"
 case "0001": zwi$ = "1"
 case "0010": zwi$ = "2"
 case "0011": zwi$ = "3"
 case "0100": zwi$ = "4"
 case "0101": zwi$ = "5"
 case "0110": zwi$ = "6"
 case "0111": zwi$ = "7"
 case "1000": zwi$ = "8"
 case "1001": zwi$ = "9"
 case "1010": zwi$ = "A"
 case "1011": zwi$ = "B"
 case "1100": zwi$ = "C"
 case "1101": zwi$ = "D"
 case "1110": zwi$ = "E"
 case "1111": zwi$ = "F"
end select
end sub

sub deztobin
zl#=val(operand$)
while zl#<>0
 teiler#=zl#/2:teil$=str$(teiler#)
 for n%=1 to len(teil$)
  st$=mid$(teil$,n%,1):if st$="." then k%=1
  if k%=0 then rest$=rest$+st$
 next n%
 zl#=val(rest$)
 if k%=1 then s$="1" else s$="0"
 erge$=erge$+s$:k%=0:rest$=""
wend
for n%=len(erge$) to 1 step -1
 z$=mid$(erge$,n%,1):real$=real$+z$
next n%
operand$=real$
end sub

sub operandenbilden (zahl%)
select case zahl%
 case 0: operand$=operand$+"0"
 case 1: operand$=operand$+"1"
 case 2: if modus%<>%BIN then operand$=operand$+"2"
 case 3: if modus%<>%BIN then operand$=operand$+"3"
 case 4: if modus%<>%BIN then operand$=operand$+"4"
 case 5: if modus%<>%BIN then operand$=operand$+"5"
 case 6: if modus%<>%BIN then operand$=operand$+"6"
 case 7: if modus%<>%BIN then operand$=operand$+"7"
 case 8: if modus%<>%BIN then operand$=operand$+"8"
 case 9: if modus%<>%BIN then operand$=operand$+"9"
 case 10: if modus%=%HEX then operand$=operand$+"A"
 case 11: if modus%=%HEX then operand$=operand$+"B"
 case 12: if modus%=%HEX then operand$=operand$+"C"
 case 13: if modus%=%HEX then operand$=operand$+"D"
 case 14: if modus%=%HEX then operand$=operand$+"E"
 case 15: if modus%=%HEX then operand$=operand$+"F"
 case 16
          if modus%=%DEZ then
           operand#=val(operand$)
            if sgn(operand#)=-1 then
             operand#=abs(operand#):vorzeichen%=0
            else
             operand#=0-operand#:vorzeichen%=1
            end if
          operand$=str$(operand#)
          end if
          if modus%=%BIN then
           if vorzeichen%=1 then
            vorzeichen%=0
           else
            vorzeichen%=1
           end if
          end if
end select
end sub

sub rechnerinit
dattyp%=%BYTE:operand$="":fehler%=0:vorzeichen%=0
last%=0:zwi$="":ope%=0:uebertrag%=0:erg$=""
DIM tsum1(32) as shared string
DIM tsum2(32) as shared string
end sub

sub taschenrechner
openwindow 3,7,15,67,30,2,2
wbox 4,9,3,62,5,2,0,1
mboxattr%=15
mbox 8,10,"HEX",%F1:maus%=1
mbox 8,18,"BIN",%F2:maus%=2
mbox 8,26,"OKT",%F3:maus%=3
mbox 8,34,"DEZ",%F4:maus%=4
mbox 8,50,"BYT",%F7:maus%=5
mbox 8,58,"WOR",%F8:maus%=6
mbox 8,66,"DWO",%F9:maus%=7
mbox 10,10," A ",97:maus%=8
mbox 10,18," B ",98:maus%=9
mbox 10,26," C ",99:maus%=10
mbox 10,34," D ",100:maus%=11
mbox 10,42," E ",101:maus%=12
mbox 10,50," F ",102:maus%=13
mbox 10,66," - ",45:maus%=14
mbox 12,10," 1 ",49:maus%=15
mbox 12,18," 2 ",50:maus%=16
mbox 12,26," 3 ",51:maus%=17
mbox 12,34," 4 ",52:maus%=18
mbox 12,42," 5 ",53:maus%=19
mbox 14,10," 6 ",54:maus%=20
mbox 14,18," 7 ",55:maus%=21
mbox 14,26," 8 ",56:maus%=22
mbox 14,34," 9 ",57:maus%=23
mbox 14,42," 0 ",48:maus%=24
mbox 14,50,"  ",%BACK:maus%=25
mbox 14,58,"CEC",%ESC:maus%=26
mbox 14,66,"OFF",%F10:maus%=27
end sub

sub fehlermeldung
statusline 1," Keine Fehlermeldung",112,116

' Statuszeile

select case modus%
 case %HEX
            statusline 0," HEX-Modus                        "+_
            "                   Converter by VfB Hose 1997",112,116
 case %BIN
            if vorzeichen%=0 then
             statusline 0," BIN-Modus                        "+_
             "                   Converter by VfB Hose 1997",112,116
	    else
             statusline 0," BIN-Modus          Negativzeichen"+_
             " aktiviert         Converter by VfB Hose 1997",112,116
            end if
 case %DEZ
            if vorzeichen%=0 then
             statusline 0," DEZ-Modus                        "+_
             "                   Converter by VfB Hose 1997",112,116
            else
             statusline 0," DEZ-Modus          Negativzeichen"+_
             " aktiviert         Converter by VfB Hose 1997",112,116
            end if
 case %OKT
            statusline 0," OKT-Modus                        "+_
            "                   Converter by VfB Hose 1997",112,116
end select

'Auswertung der einzelnen Fehler in der Fehlerzeile

select case fehler%
 case 1
        statusline 1," Auerhalb des 32-Bit-Bereiches      "+_
        "Dezimalzahl nicht grer als 4.294.967.295",0,0
 case 2
	statusline 1," Auerhalb des 32-Bit-Bereiches      "+_
        " Oktalzahl nicht grer als 37.777.777.777",0,0
 case 3
	statusline 1," Auerhalb des 32-Bit-Bereiches      "+_
	"    Hexadezzahl nicht grer als FFFF FFFF",0,0
 case 4
 	statusline 1," Auerhalb des 32-Bit-Bereiches   "+_
        " Dezimalzahl nicht kleiner als -2.147.483.648",0,0

 case 5
        statusline 1," Rechner-Display-berlauf            "+_
        "      Maximal 32 (Bit) Ziffern darstellbar",0,0
 case 6
 	statusline 1," Negativ-Bit ungleich 1              "+_
        "       Bitte negative Binrzahl berprfen",0,0
end select
end sub