Program ChangePath;
Uses DOS, Crt;

type BytePtr = ^byte;                           { Pointer auf ein BYTE }
     Bereich = array[0..1000] of byte;  { ein Bereich, irgendwo im RAM }
     BerPtr  = ^Bereich;                   { Pointer auf einen Bereich }
     MCB     = record                       { ein Memory-Control-Block }
                 IdCode  : char;{ "M" = es folgt ein Block, "Z" = Ende }
                 PSP     : word;  { Segmentadresse des zugehrigen PSP }
                 Abstand : word;          { Anzahl der Paragraphen - 1 }
               end;
     MCBPtr  = ^MCB;                           { Pointer auf einen MCB }
     MCBPtr2 = ^MCBPtr;                     { Pointer auf einen MCBPtr }
     HexStr  = string[4];     { nimmt einen 4 ziffrigen Hex-String auf }

var  OldDir,
     NewDir,
     NewPath,
     CurPath   : String;
     Laenge,
     Position  : Integer;
     CvHStr    : HexStr;        { nimmt den umgewandelten Hex-String auf }

{**********************************************************************}
{* FirstMCB: Liefert einen Zeiger auf den ersten MCB.                 *}
{* Eingabe : keine                                                    *}
{* Ausgabe : Zeiger auf den ersten MCB.                               *}
{**********************************************************************}

function FirstMCB : MCBPtr;

var Regs : Registers;                { nimmt die Prozessorregister auf }

begin
  Regs.ah := $52;          { Fkt.nr.: Adresse des DOS-Info-Block holen }
  MsDos( Regs );                          { DOS-Interrupt $21 aufrufen }

{*-- ES:(BX-4) zeigt auf den ersten MCB, Pointer erstellen ---------*}

  FirstMCB := MCBPtr2( ptr( Regs.ES-1, Regs.BX+12 ) )^;
end;

{**********************************************************************}
{* GetMCB: verfolgt die Liste der MCBs.                               *}
{* Eingabe : keine                                                    *}
{* Ausgabe : keine                                                    *}
{**********************************************************************}

procedure GetMCB;

const ComSpec : array[0..7] of char = 'COMSPEC=';
      Config  : array[0..6] of char = 'CONFIG=';

var  AktMCB  : MCBPtr;
     Ende    : boolean;
     Env     : boolean;
     Taste   : char;
     NrMCB,                       { Nummer des gerade untersuchten MCB }
     I,
     StrPosit,
     StrLaenge,
     Z : integer;                              { Schleifenzhler }
     MemPtr  : BerPtr;
     EnvPar  : Array[1..50] of String;

begin
  Ende  := false;
  NrMCB := 1;                       { der erste MCB trgt die Nummer 1 }
  AktMCB := FirstMCB;                { Zeiger auf den ersten MCB holen }
  repeat                                { die Kette der MCBs verfolgen }
    if AktMCB^.IdCode = 'Z' then Ende := true; { letzten MCB erreicht? }

    Env  := false;

    {*-- handelt es sich um ein Environment? -------------------------*}

    Z := 0;                { mit dem Vergleich im ersten Byte anfangen }
    MemPtr := BerPtr(ptr(Seg(AktMCB^)+1, 0));         { Pointer in RAM }
    while ( (Z<=7) and (ord(ComSpec[Z]) = MemPtr^[Z]) ) do
    Inc(Z);                         { Z auf das nchste Zeichen setzen }
    If Z <=7 then
    begin
          Z := 0;
          while ( (Z<=6) and (ord(Config[Z]) = MemPtr^[Z]) ) do
          Inc(Z);                   { Z auf das nchste Zeichen setzen }
          if  Z > 6 then Env := true;
          end
    else  Env := true;

    if Env then
      begin                  { Ja, es handelt sich um ein Environment! }
        for I := 1 to 50 do EnvPar[I] := '';
        MemPtr := BerPtr(ptr(Seg(AktMCB^)+1, 0));
        if Lo(DosVersion) >= 3 then      { DOS Version 3.0 oder hher? }

          begin                          { Ja, Programmnamen ermitteln }
            Z := 0;                      { mit dem ersten Byte beginnen }
            while not( (MemPtr^[Z]=0) and (MemPtr^[Z+1]=0) ) do
              Inc( Z );                            { Leerstring suchen }
            if ( MemPtr^[Z+2]<>1 ) OR ( MemPtr^[Z+3]<>0 ) then
            begin                        { Programmname nicht entdeckt }
 {            clrscr;
             writeln('MCB-Nummer    = ', NrMCB);
             writeln('Gre         = ', AktMCB^.Abstand, ' Paragraphen ',
                     '( ', longint(AktMCB^.Abstand) shl 4, ' Bytes )');
             write('Inhalt        = ');
             writeln('Environment');
             write('Programmname  = ');
             writeln('unbekannt'); }
             end
            else Env := false;
          end;

       {*-- die Environment-Strings ausgeben ------------------------*}

        If Env then
        begin
          Z := 0;  { mit dem ersten Byte im allokierten Bereich beginnen }
          I := 0;                         {Nummer des Strings}
          while MemPtr^[Z]<>0 do          { wiederholen, bis Leer-String }
          begin
            Inc(I);
            repeat                             { einen String ausgeben }
              EnvPar[I] := EnvPar[I] + chr(MemPtr^[Z]);
              Inc( Z );               { das nchste Zeichen bearbeiten }
            until MemPtr^[Z]=0;                   { bis zum Stringende }
            Inc( Z );      { auf den Anfang des nchsten String setzen }
          end;
          for I := 1 to EnvCount do {Stimmen die Variablen ueberein?}
          begin
              if  EnvPar[I] <> EnvStr(I) then
              begin
                   Env := false;
                   break;
              end;
              if EnvPar[I] = CurPath then EnvPar[I] := NewPath;
          end;
        end;
        If Env then
        begin
              Z := 0;
              for I := 1 to EnvCount do
              begin
                     StrLaenge := Length(EnvPar[I]);
                     for  StrPosit := 1 to StrLaenge do
                     begin
                          MemPtr^[Z] := Ord(EnvPar[I,StrPosit]);
                          Inc(Z);
                     end;
                     MemPtr^[Z] := 0;
                     Inc(Z);
              end;
              MemPtr^[Z] := 0;
              Inc(Z);
         end;
    end;

    if ( not Ende ) then
     begin                       { Pointer auf den nchsten MCB setzen }
       AktMCB := MCBPtr(ptr(seg(AktMCB^) + AktMCB^.Abstand + 1, 0));
       Inc(NrMCB);                 { die Nummer des MCB inkrementieren }
     end;
  until ( Ende );      { wiederholen, bis der letzte MCB bearbeitet ist }
end;

{ Hauptprogramm }

BEGIN
      OldDir     := ParamStr(1);
      NewDir    := ParamStr(2);

      CurPath   := GetEnv('PATH');
      CurPath   := 'PATH=' + CurPath;

      Laenge    := Length(OldDir);

      Position  := Pos(OldDir,CurPath);

      If  (Position  <>  0) AND (Laenge > 0)  AND (EnvCount < 51) then
      begin
            NewPath := CurPath;
            Delete(NewPath,Position,Laenge);
            Insert(NewDir,NewPath,Position);
            GetMCB;
      end;

END.