{
   Loesung der Aufgabenstellung aus Cream 2:

   Acht-Damen-Problem: wie koennen auf einem Schachbrett
   8 Damen so untergebracht werden, dass sie sich weder
   horizontal noch diagonal noch vertikal schlagen knnen?

   HINWEIS: In der Aufgabenstellung ist ein Fehler! Den, wenn
   die Spalten von links nach rechts mit A bis H und die Reihen
   von unten nach oben von 1 bis 8 gekennzeichnet werden, so ist
   A2 ueber und nicht rechts neben A1!

   Loesungsansatz:

   Die 8 Damen koennen sich nur dann nicht horizontal oder vertikal
   schlagen, wenn jede in einer eigenen Reihe und in einer eigenen
   Spalte sitzt, d.h., es muss auch jede Reihe und Spalte besetzt sein!
   Somit habe ich zum setzen der 1. Dame nur mehr 8 Moeglichkeiten von
   A1 - A8. Da die 1. Dame der 2. Dame in Spalte B bereits 2 bzw. 3
   Moeglichkeiten wegnimmt, so hat diese dann nur noch 6 bzw. 5
   Stellmoeglichkeiten usw. Sptestens die letzte Dame in Spalte H kann
   kann dann nur noch 0 oder 1 Moeglichkeit haben!

   Die Verarbeitung erfolgt spaltenweise. Die erste Dame hat 8
   Moeglichkeiten in Spalte A. Alle pro Moeglichkeit gesperrten Felder
   werden in der Loesungstabelle markiert. Die Loesungstabelle ist 3-
   dimensional, damit bei den Rekursionen fuer die Spalten B bis G beim
   Wiedereintritt in die hoehere Ebene der alte Zustand wiederhergestellt
   werden kann.

   Die Spalten B bis G werden rekursiv abgearbeitet, pro moeglichem Feld
   werden die Folgespalten wiederum rekursiv aufgerufen (Sperrfeldermittl.).
   Nach Bearbeitung von Spalte G wird entschieden, ob es noch eine Loesung
   fuer Spalte H gibt. Diese wird gegebenenfalls ausgegeben und Schleifen
   sowie Rekursionen sofort beendet. Mit Aufrufparameter ALL werden alle
   Loesungen ausgegeben!



   Erstellt mit BP 7.0 in 08/97

   L I C H T S C H W E R T
}
Program AchtDamen;
Uses Crt;                                           {wg. ClrScr}

var   I, J, K   : Byte;                             {Laufzaehler}
      Treffer   : Integer;                          {Anzahl der Treffer}
      OLines,                                       {Anzahl Ausgabezeilen}
      Erste,                                        {Reihe fuer erste Dame}
      Reihe,                                        {aktuelle Reihe}
      Spalte,                                       {aktuelle Spalte}
      Tiefe     : Byte;                             {aktuelle Spaltentiefe}
      Option    : String;                           {Aufrufoption}
      Loesung   : Array[1..8,1..8,1..7] of Boolean; {Loesungsmatrix}

const SpalteA   : Byte = 1;                         {Konstanten der Spalten}
      SpalteB   : Byte = 2;
      SpalteC   : Byte = 3;
      SpalteD   : Byte = 4;
      SpalteE   : Byte = 5;
      SpalteF   : Byte = 6;
      SpalteG   : Byte = 7;
      SpalteH   : Byte = 8;

{Ueberschrift ausgeben/Seitenwechsel vornehmen}
Procedure Header;
begin
      ClrScr;                               {Bildschirm loeschen}

      WriteLn('Das 8-Damen-Problem');       {Ueberschrift ausgeben}
      WriteLn('');
      WriteLn(' ');
      WriteLn(' ');
      OLines := 4;                          {Zeilenzaehler}

      If Option <> 'ALL' then               {Hinweis auf alle Loesungen}
      begin
            OLines := 6;                    {Zeielenzaehler}
            WriteLn('Mit Aufruf "8DAMEN ALL" werden alle Loesungen gezeigt!');
            WriteLn(' ');
      end;
end;

{Tiefe 7: Pruefen, ob Treffer in Spalte H existiert (muss eindeutig sein!)}
Procedure PruefeTreffer;
var   AnzTreffer   : String[3];
      TrefferText,
      Zeichen      : String;
      ZSpalte      : Byte;

begin
      {alle Zeilen in Spalte H (Level 7) durchsuchen}
      For     I := 1       to 8       do
          {Treffer}
          If Loesung[I, SpalteH, 7] then
          begin
                {Anzahl Treffer erhoehen}
                Inc(Treffer);

                {Ausgabe vorbereiten - ev. Seitenwechsel bei Option ALL}
                Inc(OLines);

                If OLines > 22 then
                begin
                      WriteLn(' ');
                      WriteLn('Bitte Taste druecken!');
                      ReadKey;
                      ClrScr;               {Bildschirm loeschen}
                      Olines := 1;          {Zeilenzaehler}
                end;

                {Loesungstext aufbereiten und Loesung ausgeben}
                Str(I,Zeichen);
                TrefferText := 'H' + Zeichen;

                For     J := SpalteG DownTo SpalteA do     {uebrige Spalten}
                    For K := 1       to 8       do         {alle Zeilen}
                        If Loesung[K, J, 7] then
                        begin
                              Str(K, Zeichen);
                              TrefferText := Zeichen + ' ' + TrefferText;
                              Zeichen := CHR(J+$40);
                              TrefferText := Zeichen + TrefferText;
                              BREAK;                       {Spalte fertig}
                        end;

                {Loesung mit Zaehler ausgeben}
                TrefferText := 'Loesung: ' + TrefferText;
                Str(Treffer, AnzTreffer);
                While Length(AnzTreffer) < 3 do AnzTreffer := ' ' + AnzTreffer;

                TrefferText := AnzTreffer + '.' + ' ' + TrefferText;
                WriteLn(TrefferText);

                {Schleife verlassen}
                BREAK;
          end;
end;

{Bedrohte Schlagfelder sperren (alle linksspalt. Felder sind bereit gesperrt}
Procedure MarkiereSchlagfelder(PReihe, PSpalte, PTiefe: Byte);
var DReihe,
    DSpalte : Byte;
begin
     {vertikale Sperrung nach rechts}
     For I := PSpalte + 1 to 8 do
         Loesung[PReihe, I, PTiefe] := false;

     {horizontale Sperrung nach oben und unten!}
     For I := 1 to 8 do
         If I <> PReihe then Loesung[I, PSpalte, PTiefe] := false;

     {diagonale Sperrung nach rechts oben}
     DReihe  := PReihe + 1;
     DSpalte := PSpalte + 1;

     While (DReihe < 9) AND (DSpalte < 9) DO
     begin
           Loesung[DReihe, DSpalte, PTiefe] := false;
           Inc(DReihe);
           Inc(DSpalte);
     end;

     {diagonale Sperrung nach rechts unten}
     DReihe  := PReihe - 1;
     DSpalte := PSpalte + 1;

     While (DReihe > 0) AND (DSpalte < 9) DO
     begin
           Loesung[DReihe, DSpalte, PTiefe] := false;
           Dec(DReihe);
           Inc(DSpalte);
     end;
end;

{Naechste Dame unterbringen in freien Restfeldern}
Procedure NaechsteSpalte;
var   LBReihe,                              {Laufzaehler bearbeitete Reihe}
      LReihe,                               {lokaler Reihenzaehler}
      LSpalte : Byte;                       {lokaler Spaltenzaehler}
begin
      Inc(Tiefe);                           {Spaltentiefe erhoehen}

      For  LBReihe := 1 to 8 do             {Schleife ueber alle Reihen}
           If Loesung[LBReihe, Tiefe, Tiefe-1] then  {noch moeglich?}
           begin
                 {Reset Loesungstabelle auf bekannte Informationen}
                 For     LReihe  := 1       to 8       do
                     For LSpalte := SpalteA to SpalteH do
                         Loesung[LReihe, LSpalte, Tiefe]
                                := Loesung[LReihe, LSpalte, Tiefe - 1];
                 {Bedrohte Felder sperren}
                 MarkiereSchlagfelder(LBReihe, Tiefe, Tiefe);

                 {Rekursion auf naechste Spalte}
                 If Tiefe < 7 then NaechsteSpalte {Rekursion naechste Dame}
                              else PruefeTreffer; {Trefferausgabe pruefen}

                 {Schleife bei Loesung verlassen - ausser bei ALL}
                 If (Treffer > 0) AND (Option <> 'ALL') then BREAK;
           end;

      Dec(Tiefe);                           {Spaltentiefe wieder erniedrigen}
end;

{Hauptprogramm}

BEGIN
      Treffer := 0;                         {noch kein Treffer}
      Tiefe   := SpalteA;                   {1. Spaltentiefe}
      Option  := ParamStr(1);               {Aufrufoption}

      For I     := 1 to Length(Option) do   {Umsetzen der Aufrufoption in}
          Option[I] := UpCase(Option[I]);   {Grossbuchstaben}

      Header;                               {Ueberschrift ausgeben}

     For Erste := 1 to 8 do                {1. Dame auf A1 bis A8 moeglich}
      begin
            For Reihe := 1 to 8 do          {Initialisierung Spaltentiefe A}
            begin
                 {Spalte A}
                 If Reihe = Erste then Loesung[Reihe, SpalteA, Tiefe] := true
                                  else Loesung[Reihe, SpalteA, Tiefe] := false;
                 {Spalten B - H}
                 For Spalte := SpalteB to SpalteH do
                     Loesung[Reihe, Spalte, Tiefe] := True;
            end;

            {Bedrohte Felder sperren}
            MarkiereSchlagfelder(Erste, SpalteA, Tiefe);

            {Naechste Dame unterbringen}
            NaechsteSpalte;

            {Loesung gefunden - aufhoeren, wenn nicht alle Loesungen gewuenscht}
            If (Treffer > 0) AND (Option <> 'ALL') then BREAK;
      end;
END.