
Unit VGrafik;

Interface

Uses Crt, Dos, Graph;

Type
  Typ1_2   = 1..2;
  Vektor   = Array[1..3] of Integer; {stinknormaler Vektor}
  BVektor  = Array[1..2] of Integer; {Bildschirmvektor}

Procedure Let(Var vec: Vektor; x1, x2, x3: Integer);
{Weist einem Vektor drei Koordinaten zu}

Procedure AddVec(vec1, vec2: Vektor; Var Ergebnis: Vektor);
{Die Vektoraddition}

Procedure SM(vec: Vektor; k: Integer; Var Ergebnis: Vektor);
{Multiplikation eines Vektors mit einer Zahl}

Procedure V2B(vec: Vektor; Var bvec: BVektor);
{Umrechnung eines Vektors in Bildschirmkoordinaten}

Procedure Plot_Hi(vec: Vektor; Farbe: Word);
{** Durch einen Vektor festgelegten Punkt **}
{** im Modus 640*480/16 Farben setzen     **}

Procedure Plot_256(vec: Vektor; Farbe: Byte);
{** Durch einen Vektor festgelegten Punkt **}
{** im Modus 320*200/256 Farben setzen    **}

Procedure Line_Hi(vec1, vec2: Vektor; Farbe: Word);
{** Zeichnet eine Linie zwischen zwei Vektorpunkten **}
{** im Modus 640*480/16 Farben **}

Procedure Line_256(vec1, vec2: Vektor; Farbe: Word);
{****** Linie im Modus 320*200/256 Farben ******}

Procedure SetGFX(Modus: Typ1_2);
{****** Initialisiert den Grafikbildschirm ******}

Procedure VecBall_Hi(Mittelpunkt: Vektor; Radius: Integer; Farbe: Byte);
{*** Vektorball im Modus 640*480/16 Farben ***}

Procedure VecBall_256(Mittelpunkt: Vektor; Radius: Integer; Farbe: Byte);
{*** Vektorball im Modus 320*200/256 Farben ***}




Implementation


Const
  x_256=320;
  y_256=200;
  Video=$A000;


Procedure Let(Var vec: Vektor; x1, x2, x3: Integer);
Begin
  vec[1]:=x1;
  vec[2]:=x2;
  vec[3]:=x3;
End;


Procedure AddVec(vec1, vec2: Vektor; Var Ergebnis: Vektor);
Begin
  Ergebnis[1]:=vec1[1]+vec2[1];
  Ergebnis[2]:=vec1[2]+vec2[2];
  Ergebnis[3]:=vec1[3]+vec2[3];
End;


Procedure SM(vec: Vektor; k: Integer; Var Ergebnis: Vektor);
Begin
  Ergebnis[1]:=k*vec[1];
  Ergebnis[2]:=k*vec[2];
  Ergebnis[3]:=k*vec[3];
End;


Procedure V2B(vec: Vektor; Var bvec: BVektor);
{Umrechnung eines Vektors in Bildschirmkoordinaten}
Var
  x, y, z: Integer;
Begin
  x:=vec[1];
  y:=vec[2];
  z:=vec[3];
  bvec[1]:=x-(z div 2);
  bvec[2]:=y-(z div 2);
End;


Procedure Plot_Hi(vec: Vektor; Farbe: Word);
{** Durch einen Vektor festgelegten Punkt **}
{** im Modus 640*480/16 Farben setzen     **}
Var
  xb, yb: Integer;
  b: BVektor;
Begin
  V2B(vec, b);
  xb:=b[1]+319;
  yb:=240-b[2];
  PutPixel(xb, yb, Farbe);
End;


Procedure Plot_256(vec: Vektor; Farbe: Byte);
{** Durch einen Vektor festgelegten Punkt **}
{** im Modus 320*200/256 Farben setzen    **}
Var
  xb, yb: Integer;
  b: BVektor;
  Adr: Word;
Begin
  V2B(vec, b);
  xb:=b[1]+159;
  yb:=100-b[2];
  ASM
    MOV AX,Video
    MOV ES,AX
    MOV AX,x_256
    MUL  yb
    MOV  DI,AX
    ADD  DI,xb
    MOV  AH,Farbe
    XCHG ES:[DI],AH
  End;
End;


Procedure Line_256(vec1, vec2: Vektor; Farbe: Word);
{** Zeichnet eine Linie zwischen zwei Vektorpunkten **}
{** im Modus 320*256/256 Farben **}

  Procedure Line_low(x1,y1,x2,y2,col:Integer);
  { ** Linie in 320x200/256 in Pascal }
  var x,y,kriterium,dx,dy,stepx,stepy:integer;
  begin
    dx:=(x2-x1);
    dy:=(y2-y1);
    if dx<0 then dx:=-dx;
    if dy<0 then dy:=-dy;
    if dx=0 then kriterium:=0 else kriterium:=round(-dx/2);
    if x2>x1 then stepx:=1 else stepx:=-1;
    if y2>y1 then stepy:=1 else stepy:=-1;
    x:=x1;y:=y1;mem[$a000:x+y*320]:=col;
    while not ((x=x2)and(y=y2)) do begin
      if kriterium<0 then begin
        x:=x+stepx;kriterium:=kriterium+dy;
      end;
      if (kriterium>=0)and(y<>y2) then begin
        y:=y+stepy;kriterium:=kriterium-dx;
      end;
      mem[$a000:x+y*320]:=col;
    end;
  end;

Var
  b1, b2: BVektor;
  xb1, yb1, xb2, yb2: Integer;
Begin
  V2B(vec1, b1);
  V2B(vec2, b2);
  xb1:=b1[1]+319;
  yb1:=240-b1[2];
  xb2:=b2[1]+319;
  yb2:=240-b2[2];
  Line_low(xb1, yb1, xb2, yb2, Farbe);
End;

Procedure Line_Hi(vec1, vec2: Vektor; Farbe: Word);
{** Zeichnet eine Linie zwischen zwei Vektorpunkten **}
{** im Modus 640*480/16 Farben **}
Var
  b1, b2: BVektor;
  xb1, yb1, xb2, yb2: Integer;
Begin
  V2B(vec1, b1);
  V2B(vec2, b2);
  xb1:=b1[1]+319;
  yb1:=240-b1[2];
  xb2:=b2[1]+319;
  yb2:=240-b2[2];
  SetColor(Farbe);
  Line(xb1, yb1, xb2, yb2);
End;


Procedure SetGFX(Modus: Typ1_2);
{****** Initialisiert den Grafikbildschirm ******}
Var
  Driver, Mode: Integer;
Begin
  DetectGraph(Driver, Mode);
  If Driver = VGA then
  Begin
    If Modus = 1 then InitGraph(Driver, Mode, ''); {** 640*480, 16 Farben  **}
    If Modus = 2 then                              {** 320*200, 256 Farben **}
    ASM
      mov ax, $13
      int $10
    End;
  End
  Else
  Begin
    writeln('Sorry, dieses Programm bentigt eine VGA-Karte');
    Halt;
  End;
End;


Procedure VecBall_Hi(Mittelpunkt: Vektor; Radius: Integer; Farbe: Byte);
{*** Vektorball im Modus 640*480/16 Farben ***}
Var
  xp, yp, zp , xp1, yp1, zp1: Integer;
  Vec1, Vec2 : Vektor;
  s1, s2, step, step1, fak: Real;
Begin
  s1:=0;
  step:=pi/40;
  step1:=pi/20;
  {********************* Gitter 1 ****************************************}
  repeat
    yp:=round(radius*sin(s1))+mittelpunkt[2];
    yp1:=-round(radius*sin(s1))+mittelpunkt[2];
    s2:=0;
    fak:=radius*cos(s1);
    repeat
      xp:=round(sin(s2)*fak)+Mittelpunkt[1];
      zp:=round(cos(s2)*fak)+Mittelpunkt[3];
      Let(Vec1, xp, yp, zp);
      xp1:=round(sin(s2+step1)*fak)+Mittelpunkt[1];
      zp1:=round(cos(s2+step1)*fak)+Mittelpunkt[3];
      Let(Vec2, xp1, yp, zp1);
      Line_hi(vec1, vec2, farbe);
      Let(Vec1, xp, yp1, zp);
      Let(Vec2, xp1, yp1, zp1);
      Line_hi(vec1, vec2, farbe);
      s2:=s2+step1;
    until s2>=pi*2;
    s1:=s1+step;
  until s1>=pi/2;
  {********************* Gitter 2 **************************************}
  s1:=0;
  repeat
    xp:=round(radius*sin(s1))+mittelpunkt[1];
    xp1:=-round(radius*sin(s1))+mittelpunkt[1];
    s2:=0;
    fak:=radius*cos(s1);
    repeat
      yp:=round(sin(s2)*fak)+Mittelpunkt[2];
      zp:=round(cos(s2)*fak)+Mittelpunkt[3];
      Let(Vec1, xp, yp, zp);
      yp1:=round(sin(s2+step1)*fak)+Mittelpunkt[2];
      zp1:=round(cos(s2+step1)*fak)+Mittelpunkt[3];
      Let(Vec2, xp, yp1, zp1);
      Line_hi(vec1, vec2, farbe);
      Let(Vec1, xp1, yp, zp);
      Let(Vec2, xp1, yp1, zp1);
      Line_hi(vec1, vec2, farbe);
      s2:=s2+step1;
    until s2>pi*2;
    s1:=s1+step;
  until s1>=pi/2;
  {************************* Gitter 3 **********************************}
  s1:=0;
  repeat
    zp:=round(radius*sin(s1))+mittelpunkt[3];
    zp1:=-round(radius*sin(s1))+mittelpunkt[3];
    s2:=0;
    fak:=radius*cos(s1);
    repeat
      xp:=round(cos(s2)*fak)+Mittelpunkt[1];
      yp:=round(sin(s2)*fak)+Mittelpunkt[2];
      Let(Vec1, xp, yp, zp);
      xp1:=round(cos(s2+step1)*fak)+Mittelpunkt[1];
      yp1:=round(sin(s2+step1)*fak)+Mittelpunkt[2];
      Let(Vec2, xp1, yp1, zp);
      Line_hi(vec1, vec2, farbe);
      Let(Vec1, xp, yp, zp1);
      Let(Vec2, xp1, yp1, zp1);
      Line_hi(vec1, vec2, farbe);
      s2:=s2+step1;
    until s2>pi*2;
    s1:=s1+step;
  until s1>=pi/2;
End;


Procedure VecBall_256(Mittelpunkt: Vektor; Radius: Integer; Farbe: Byte);
{*** Vektorball im Modus 320*200/256 Farben ***}
Var
  xp, yp, zp , xp1, yp1, zp1: Integer;
  Vec1, Vec2 : Vektor;
  s1, s2, step, step1, fak: Real;
Begin
  s1:=0;
  step:=pi/40;
  step1:=pi/20;
  {********************* Gitter 1 ****************************************}
  repeat
    yp:=round(radius*sin(s1))+mittelpunkt[2];
    yp1:=-round(radius*sin(s1))+mittelpunkt[2];
    s2:=0;
    fak:=radius*cos(s1);
    repeat
      xp:=round(sin(s2)*fak)+Mittelpunkt[1];
      zp:=round(cos(s2)*fak)+Mittelpunkt[3];
      Let(Vec1, xp, yp, zp);
      xp1:=round(sin(s2+step1)*fak)+Mittelpunkt[1];
      zp1:=round(cos(s2+step1)*fak)+Mittelpunkt[3];
      Let(Vec2, xp1, yp, zp1);
      line_256(vec1, vec2, farbe);
      Let(Vec1, xp, yp1, zp);
      Let(Vec2, xp1, yp1, zp1);
      line_256(vec1, vec2, farbe);
      s2:=s2+step1;
    until s2>=pi*2;
    s1:=s1+step;
  until s1>=pi/2;
  {********************* Gitter 2 **************************************}
  s1:=0;
  repeat
    xp:=round(radius*sin(s1))+mittelpunkt[1];
    xp1:=-round(radius*sin(s1))+mittelpunkt[1];
    s2:=0;
    fak:=radius*cos(s1);
    repeat
      yp:=round(sin(s2)*fak)+Mittelpunkt[2];
      zp:=round(cos(s2)*fak)+Mittelpunkt[3];
      Let(Vec1, xp, yp, zp);
      yp1:=round(sin(s2+step1)*fak)+Mittelpunkt[2];
      zp1:=round(cos(s2+step1)*fak)+Mittelpunkt[3];
      Let(Vec2, xp, yp1, zp1);
      line_256(vec1, vec2, farbe);
      Let(Vec1, xp1, yp, zp);
      Let(Vec2, xp1, yp1, zp1);
      line_256(vec1, vec2, farbe);
      s2:=s2+step1;
    until s2>pi*2;
    s1:=s1+step;
  until s1>=pi/2;
  {************************* Gitter 3 **********************************}
  s1:=0;
  repeat
    zp:=round(radius*sin(s1))+mittelpunkt[3];
    zp1:=-round(radius*sin(s1))+mittelpunkt[3];
    s2:=0;
    fak:=radius*cos(s1);
    repeat
      xp:=round(cos(s2)*fak)+Mittelpunkt[1];
      yp:=round(sin(s2)*fak)+Mittelpunkt[2];
      Let(Vec1, xp, yp, zp);
      xp1:=round(cos(s2+step1)*fak)+Mittelpunkt[1];
      yp1:=round(sin(s2+step1)*fak)+Mittelpunkt[2];
      Let(Vec2, xp1, yp1, zp);
      line_256(vec1, vec2, farbe);
      Let(Vec1, xp, yp, zp1);
      Let(Vec2, xp1, yp1, zp1);
      line_256(vec1, vec2, farbe);
      s2:=s2+step1;
    until s2>pi*2;
    s1:=s1+step;
  until s1>=pi/2;
End;


End.