/*
 * Decompiled with CFR 0.152.
 */
package fullscreen;

import fullscreen.FullScreenBase;
import fullscreen.GLDrawableHelper;
import fullscreen.GLTextureUpdateHelper;
import japplemenubar.JAppleMenuBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import processing.core.PApplet;

public class SoftFullScreen
extends FullScreenBase {
    Frame fsFrame;
    GraphicsDevice fsDevice;
    boolean fsIsInitialized;
    PApplet dad;

    public SoftFullScreen(PApplet dad) {
        this(dad, 0);
    }

    public SoftFullScreen(PApplet dad, int screenNr) {
        super(dad);
        this.dad = dad;
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (screenNr >= devices.length) {
            System.err.println("FullScreen API: You requested to use screen nr. " + screenNr + ", ");
            System.err.println("however, there are only " + devices.length + " screens in your environment. ");
            System.err.println("Continuing with screen nr. 0");
            screenNr = 0;
        }
        this.fsDevice = devices[screenNr];
        WindowAdapter listener = new WindowAdapter(){

            public void windowDeiconified(WindowEvent w) {
                if (SoftFullScreen.this.isFullScreen() && PApplet.platform == 2) {
                    new JAppleMenuBar().setVisible(false);
                }
            }
        };
        this.fsFrame = new Frame(this.fsDevice.getDefaultConfiguration());
        this.fsFrame.addWindowListener(listener);
        this.fsFrame.setTitle(dad.frame == null ? "" : dad.frame.getTitle());
        this.fsFrame.setIconImage(dad.frame.getIconImage());
        this.fsFrame.setUndecorated(true);
        this.fsFrame.setBackground(Color.black);
        this.fsFrame.setLayout(null);
        this.fsFrame.setSize(Math.max(this.fsDevice.getDisplayMode().getWidth(), dad.width), Math.max(this.fsDevice.getDisplayMode().getHeight(), dad.height));
        this.registerFrame(this.fsFrame);
    }

    public boolean isFullScreen() {
        return this.fsFrame.isVisible();
    }

    public void minimize() {
        if (this.isFullScreen()) {
            if (PApplet.platform == 2) {
                new JAppleMenuBar().setVisible(true);
            }
            this.fsFrame.setState(1);
        } else {
            this.dad.frame.setState(1);
        }
    }

    public void restore() {
        if (this.isFullScreen()) {
            this.fsFrame.setState(0);
            if (PApplet.platform == 2) {
                new JAppleMenuBar().setVisible(false);
            }
        } else {
            this.dad.frame.setState(0);
        }
    }

    public boolean available() {
        return this.dad.frame != null;
    }

    public void setFullScreen(final boolean fullScreen) {
        new FullScreenBase.DelayedAction(2){

            public void action() {
                SoftFullScreen.this.setFullScreenImpl(fullScreen);
            }
        };
    }

    private void setFullScreenImpl(boolean fullScreen) {
        if (fullScreen == this.isFullScreen()) {
            return;
        }
        if (fullScreen) {
            if (this.available()) {
                this.dad.frame.setVisible(false);
                this.fsFrame.add((Component)this.dad);
                if (PApplet.platform == 2) {
                    new JAppleMenuBar().setVisible(false);
                }
                this.fsFrame.setVisible(true);
                this.fsFrame.setLocation(this.fsDevice.getDefaultConfiguration().getBounds().getLocation());
                boolean usesEntireScreen = this.fsDevice.getDefaultConfiguration().getBounds().getSize().equals(new Dimension(this.dad.width, this.dad.height));
                int appleDriversSuck = PApplet.platform == 2 && usesEntireScreen ? 1 : 0;
                this.dad.setLocation((this.fsFrame.getWidth() - this.dad.width) / 2, (this.fsFrame.getHeight() - this.dad.height) / 2 - appleDriversSuck);
                this.fsFrame.setExtendedState(6);
                GLDrawableHelper.reAllocate(this);
                GLTextureUpdateHelper.update(this);
                this.requestFocus();
                SoftFullScreen.notifySketch(this.dad);
                return;
            }
            System.err.println("FullScreen API: Fullscreen mode not available");
            return;
        }
        this.fsFrame.setVisible(false);
        this.fsFrame.removeAll();
        this.dad.frame.add((Component)this.dad);
        this.dad.setLocation(this.dad.frame.insets().left, this.dad.frame.insets().top);
        if (PApplet.platform == 2) {
            new JAppleMenuBar().setVisible(true);
        }
        this.dad.frame.setVisible(true);
        GLDrawableHelper.reAllocate(this);
        GLTextureUpdateHelper.update(this);
        this.requestFocus();
        SoftFullScreen.notifySketch(this.dad);
    }

    public void setResolution(int xRes, int yRes) {
        System.err.println("Changing resolution is not supported in SoftFullScreen mode. ");
        System.err.println("Use the normal FullScreen mode to make use of that functionality.  ");
    }
}

