/*
 * Decompiled with CFR 0.152.
 */
package fullscreen;

import fullscreen.FullScreenBase;
import java.lang.reflect.Field;
import processing.core.PGraphics;
import processing.core.PGraphics3D;
import processing.core.PImage;

public class GLTextureUpdateHelper {
    public static void update(FullScreenBase fs) {
        if (fs.isGL()) {
            try {
                PGraphics g = fs.getSketch().g;
                Field field = PGraphics3D.class.getDeclaredField("textures");
                field.setAccessible(true);
                PImage[] textures = (PImage[])field.get(g);
                for (int i = 0; i < textures.length; ++i) {
                    if (textures[i] == null) continue;
                    textures[i].updatePixels();
                }
            }
            catch (SecurityException e) {
                System.err.println("FullScreen-API: Unknown error: " + e.getMessage());
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                System.err.println("FullScreen-API: Couldn't find any field 'textures' in processing.core.PGraphics3D");
                System.err.println("Seems your processing version doesn't match this version of the fullscreen api");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                System.err.println("FullScreen-API: Unknown error: " + e.getMessage());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("FullScreen-API: Unknown error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

