/*
 * Decompiled with CFR 0.152.
 */
package fullscreen;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import processing.core.PApplet;

public abstract class FullScreenBase {
    private final PApplet dad;
    static final int fsControlKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private boolean enableKeyEvents = true;
    static KeyEvent lastEvent = null;
    private boolean isGL;

    public FullScreenBase(PApplet dad) {
        this.dad = dad;
        dad.registerKeyEvent((Object)this);
        for (Class<?> clazz = dad.g.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().equals("processing.opengl.PGraphicsOpenGL")) continue;
            this.isGL = true;
        }
        if (this.isGL) {
            System.err.println("FullScreen API: Warning, OPENGL Support is experimental! ");
            System.err.println("Keep checking http://www.superduper.org/processing/fullscreen_api/ for updates!");
        }
    }

    public abstract void setFullScreen(boolean var1);

    public abstract boolean isFullScreen();

    public abstract void setResolution(int var1, int var2);

    public void enter() {
        this.setFullScreen(true);
    }

    public void leave() {
        this.setFullScreen(false);
    }

    public void setShortcutsEnabled(boolean state) {
        this.enableKeyEvents = state;
    }

    protected void registerFrame(Frame f) {
        f.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FullScreenBase.this.keyEvent(e);
            }
        });
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FullScreenBase.this.dad.exit();
            }
        });
    }

    public void keyEvent(KeyEvent e) {
        if (e.equals(lastEvent) || !this.enableKeyEvents) {
            return;
        }
        lastEvent = e;
        if (e.getKeyCode() == 27) {
            if (this.isFullScreen() && e.getID() == 402) {
                this.setFullScreen(false);
            }
        } else if (e.getID() == 401 && (e.getKeyCode() == 70 && e.getModifiers() == fsControlKey || PApplet.platform == 1 && e.getKeyCode() == 10 && e.getModifiers() == 18)) {
            this.setFullScreen(!this.isFullScreen());
        }
    }

    protected static void notifySketch(PApplet dad) {
        try {
            Method m = dad.getClass().getMethod("displayChanged", new Class[0]);
            m.invoke((Object)dad, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestFocus() {
        this.getSketch().requestFocus();
        new DelayedAction(2){

            public void action() {
                FullScreenBase.this.getSketch().requestFocus();
            }
        };
    }

    public boolean isGL() {
        return this.isGL;
    }

    public PApplet getSketch() {
        return this.dad;
    }

    public abstract class DelayedAction {
        private int skipFrames = 0;

        public DelayedAction(int skipFrames) {
            FullScreenBase.this.dad.registerPost((Object)this);
            this.skipFrames = skipFrames;
        }

        public void post() {
            --this.skipFrames;
            if (this.skipFrames <= 0) {
                this.action();
                FullScreenBase.this.dad.unregisterPost((Object)this);
            }
        }

        public abstract void action();
    }
}

