/*
 * Decompiled with CFR 0.152.
 */
package fullscreen;

import fullscreen.FullScreenBase;
import fullscreen.GLDrawableHelper;
import fullscreen.GLTextureUpdateHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import processing.core.PApplet;

public class FullScreen
extends FullScreenBase {
    GraphicsDevice fsDevice;
    int fsResolutionX;
    int fsResolutionY;
    boolean fsIsInitialized;
    private PApplet dad;
    private int refreshRate;
    private Frame fsFrame;

    public FullScreen(PApplet dad, int screenNr) {
        super(dad);
        this.dad = dad;
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (screenNr >= devices.length) {
            System.err.println("FullScreen API: You requested to use screen nr. " + screenNr + ", ");
            System.err.println("however, there are only " + devices.length + " screens in your environment. ");
            System.err.println("Continuing with screen nr. 0");
            screenNr = 0;
        }
        this.fsDevice = devices[screenNr];
        this.fsFrame = new Frame(dad.frame == null ? "" : dad.frame.getTitle());
        this.fsFrame.setTitle(dad.frame.getTitle());
        this.fsFrame.setUndecorated(true);
        this.fsFrame.setBackground(Color.black);
        this.fsFrame.setIgnoreRepaint(true);
        if (dad.width > 0) {
            this.setResolution(dad.width, dad.height);
        }
    }

    public FullScreen(PApplet dad) {
        this(dad, 0);
    }

    public boolean isFullScreen() {
        return this.fsDevice.getFullScreenWindow() == this.fsFrame;
    }

    public boolean available() {
        return this.dad.frame != null;
    }

    public void setFullScreen(final boolean fullScreen) {
        new FullScreenBase.DelayedAction(2){

            public void action() {
                FullScreen.this.setFullScreenImpl(fullScreen);
            }
        };
    }

    private void setFullScreenImpl(boolean fullScreen) {
        if (fullScreen == this.isFullScreen()) {
            return;
        }
        if (fullScreen) {
            if (this.available()) {
                this.dad.frame.setVisible(false);
                this.dad.frame.remove((Component)this.dad);
                this.fsFrame.setVisible(true);
                this.fsFrame.setLayout(null);
                this.fsFrame.setSize(this.dad.width, this.dad.height);
                this.fsFrame.add((Component)this.dad);
                this.fsDevice.setFullScreenWindow(this.fsFrame);
                this.setResolution(0, 0);
                this.fsFrame.setExtendedState(6);
                this.dad.setLocation((this.fsFrame.getWidth() - this.dad.width) / 2, (this.fsFrame.getHeight() - this.dad.height) / 2);
                GLDrawableHelper.reAllocate(this);
                GLTextureUpdateHelper.update(this);
                this.requestFocus();
                FullScreen.notifySketch(this.getSketch());
            } else {
                System.err.println("FullScreen API: Not available in applets. ");
            }
        } else {
            this.fsDevice.setFullScreenWindow(null);
            this.fsFrame.setVisible(false);
            this.fsFrame.remove((Component)this.dad);
            this.dad.frame.add((Component)this.dad);
            this.dad.frame.setVisible(true);
            this.dad.setLocation(this.dad.frame.insets().left, this.dad.frame.insets().top);
            GLDrawableHelper.reAllocate(this);
            GLTextureUpdateHelper.update(this);
            this.requestFocus();
            FullScreen.notifySketch(this.getSketch());
        }
    }

    public void setResolution(int xRes, int yRes) {
        if (xRes > 0 && yRes > 0) {
            this.fsResolutionX = xRes;
            this.fsResolutionY = yRes;
        }
        if (!this.isFullScreen()) {
            return;
        }
        if (this.fsResolutionX <= 0 || this.fsResolutionY <= 0) {
            return;
        }
        DisplayMode[] modes = this.fsDevice.getDisplayModes();
        DisplayMode theMode = null;
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getWidth() != this.fsResolutionX || modes[i].getHeight() != this.fsResolutionY || this.refreshRate != 0 && this.refreshRate != modes[i].getRefreshRate()) continue;
            theMode = modes[i];
        }
        if (theMode == null) {
            System.err.println("FullScreen API: Display mode not supported: " + this.fsResolutionX + "x" + this.fsResolutionY);
            return;
        }
        try {
            this.fsDevice.setDisplayMode(theMode);
            this.fsFrame.setSize(this.fsResolutionX, this.fsResolutionY);
        }
        catch (Exception e) {
            System.err.println("FullScreen API: Failed to go to fullScreen mode");
            e.printStackTrace();
            return;
        }
        this.dad.setLocation((this.fsDevice.getDisplayMode().getWidth() - this.dad.width) / 2, (this.fsDevice.getDisplayMode().getHeight() - this.dad.height) / 2);
    }

    public int getRefreshRate() {
        return this.fsDevice.getDisplayMode().getRefreshRate();
    }

    public void setRefreshRate(int rate) {
        this.refreshRate = rate;
    }

    public Dimension[] getResolutions() {
        return FullScreen.getResolutions(this.fsDevice);
    }

    public static Dimension[] getResolutions(GraphicsDevice device) {
        DisplayMode[] modes = device.getDisplayModes();
        int found = 0;
        Dimension[] resultTemp = new Dimension[modes.length];
        block0: for (int i = 0; i < modes.length; ++i) {
            for (int j = i; j < modes.length; ++j) {
                if (modes[i].getWidth() == modes[j].getWidth() || modes[i].getHeight() == modes[j].getHeight() || modes[i].getBitDepth() == 8 || modes[i].getBitDepth() == 16) continue;
                resultTemp[found] = new Dimension(modes[i].getWidth(), modes[i].getHeight());
                ++found;
                continue block0;
            }
        }
        Dimension[] result = new Dimension[found];
        System.arraycopy(resultTemp, 0, result, 0, found);
        return result;
    }

    public static Dimension[] getResolutions(int screenNr) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (screenNr >= devices.length) {
            System.err.println("FullScreen API: You requested the resolutions of screen nr. " + screenNr + ", ");
            System.err.println("however, there are only " + devices.length + " screens in your environment. ");
            System.err.println("Continuing with screen nr. 0");
            screenNr = 0;
        }
        return FullScreen.getResolutions(devices[screenNr]);
    }

    public int[] getRefreshRates(int xRes, int yRes) {
        DisplayMode[] modes = this.fsDevice.getDisplayModes();
        int[] resultTemp = new int[modes.length];
        int found = 0;
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getWidth() != xRes || modes[i].getHeight() != yRes || modes[i].getBitDepth() == 8 || modes[i].getBitDepth() == 16) continue;
            resultTemp[found] = modes[i].getRefreshRate();
            ++found;
        }
        int[] result = new int[found];
        System.arraycopy(resultTemp, 0, result, 0, found);
        return result;
    }
}

