#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libcd.h>
#include <kernel.h>
#include "main.h"
#include "util.h"


void PrintFix(int f)
{
  if (f<0)
  {
    f=-f;
    printf("-");
  } else
    printf(" ");

  int r=(f&4095)*10000/4096;
  printf("%d.%04d", f>>12, r);
}


int rnd(int n)
{
  return ((n*(n*n*15731+789221)+1376312589)&0x7FFFFFFF);
}

void LoadTIM(void *address)
{
  TIM_IMAGE dummy;
  LoadTIM(address, &dummy);
}

void LoadTIM(void *address, TIM_IMAGE *img)
{
  RECT rect;
  if (OpenTIM((unsigned long*)address))
  {
    printf("OpenTIM failed.\n");
    return;
  }
  if (!ReadTIM(img))
  {
    printf("ReadTIM failed!\n");
    return;
  }

#ifdef DEBUG
  printf("%dx%d@%d.%d\n", img->prect->w, img->prect->h, img->prect->x, img->prect->y);
#endif

  rect.x=img->prect->x;
  rect.y=img->prect->y;
  rect.w=img->prect->w;
  rect.h=img->prect->h;
  LoadImage(&rect, img->paddr);

  if ((img->mode>>3)&0x01) // has CLUT
  {
    rect.x=img->crect->x;
    rect.y=img->crect->y;
    rect.w=img->crect->w;
    rect.h=img->crect->h;
    LoadImage(&rect, img->caddr);
  }
  DrawSync(0);  // wait until it's loaded.. :)
}

void Blit(POLY_FT4 *pft4, int u, int v, int w, int h, int x, int y, int clut, int ctype, int rgb)
{
  setPolyFT4(pft4);

  pft4->r0=rgb&0xFF;
  pft4->g0=(rgb>>8)&0xFF;
  pft4->b0=(rgb>>16)&0xFF;

  pft4->clut=clut;

  int tpu=u&~63, tpv=v&~255;
  u-=tpu;
  v-=tpv;

  pft4->tpage=getTPage(ctype, 0, tpu, tpv);

  pft4->x0=x;
  pft4->y0=y;

  pft4->x1=x+w;
  pft4->y1=y;

  pft4->x2=x;
  pft4->y2=y+h;

  pft4->x3=x+w;
  pft4->y3=y+h;

  w--;
  h--;

  pft4->u0=u;
  pft4->v0=v;

  pft4->u1=u+w;
  pft4->v1=v;

  pft4->u2=u;
  pft4->v2=v+h;

  pft4->u3=u+w;
  pft4->v3=v+h;
}

void introShowPicture(int u, int v, int clut, int ctype, int rgb)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

//  Blit(pft4, u, v, 252, 240, 0, 0, clut, ctype, rgb);
  Blit(pft4, u, v, 256, 240, 0, 0, clut, ctype, rgb);
  addPrim(ot, pft4);
  pft4++;

//  Blit(pft4, u+252/(ctype?2:4), v, 320-252, 240, 252, 0, clut, ctype, rgb);
  Blit(pft4, u+256/(ctype?2:4), v, 320-256, 240, 256, 0, clut, ctype, rgb);
  addPrim(ot, pft4);
  pft4++;

  _curdisplayp->wspacepos += (char *)pft4 - startp;
}
