/*
 * Decompiled with CFR 0.152.
 */
package util;

import algebra.Algebra;
import algebra.Base;
import algebra.Vector3f;
import algebra.Vector4f;
import java.util.Random;

public class RandomVectors {
    private final Random random;

    public RandomVectors(long seed) {
        this.random = new Random(seed);
    }

    public Vector4f nextUnit4f() {
        float z;
        float y;
        float x;
        while ((x = this.random.nextFloat() * 2.0f - 1.0f) * x + (y = this.random.nextFloat() * 2.0f - 1.0f) * y + (z = this.random.nextFloat() * 2.0f - 1.0f) * z >= 1.0f) {
        }
        return Algebra.unit(new Vector4f(x, y, z));
    }

    public Vector3f nextUnit3f() {
        float z;
        float y;
        float x;
        while ((x = this.random.nextFloat() * 2.0f - 1.0f) * x + (y = this.random.nextFloat() * 2.0f - 1.0f) * y + (z = this.random.nextFloat() * 2.0f - 1.0f) * z >= 1.0f) {
        }
        return Algebra.unit(new Vector3f(x, y, z));
    }

    public Vector4f nextGauss4f() {
        float x = (float)this.random.nextGaussian();
        float y = (float)this.random.nextGaussian();
        float z = (float)this.random.nextGaussian();
        return new Vector4f(x, y, z);
    }

    public Vector3f nextGauss3f() {
        float x = (float)this.random.nextGaussian();
        float y = (float)this.random.nextGaussian();
        float z = (float)this.random.nextGaussian();
        return new Vector3f(x, y, z);
    }

    public Vector3f nextGauss3f(Vector3f n) {
        Vector3f up = Vector3f.J;
        Base base = new Base(n, up);
        return Algebra.sum(Algebra.scalar(base.u, (float)this.random.nextGaussian()), Algebra.scalar(base.v, (float)this.random.nextGaussian()));
    }

    public Vector3f nextCircle3f(Vector3f n) {
        float y;
        float x;
        Vector3f up = Vector3f.J;
        Base base = new Base(n, up);
        while ((x = this.random.nextFloat() * 2.0f - 1.0f) * x + (y = this.random.nextFloat() * 2.0f - 1.0f) * y >= 1.0f) {
        }
        return Algebra.sum(Algebra.scalar(base.u, x), Algebra.scalar(base.v, y));
    }

    public Vector3f next3f() {
        float x = this.random.nextFloat() * 2.0f - 1.0f;
        float y = this.random.nextFloat() * 2.0f - 1.0f;
        float z = this.random.nextFloat() * 2.0f - 1.0f;
        return new Vector3f(x, y, z);
    }
}

