/*
 * Decompiled with CFR 0.152.
 */
package scene.graph;

import algebra.Matrix4f;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import scene.graph.SceneGraphPart;
import scene.model.Model;

public class SceneLeaf
extends SceneGraphPart {
    private final Collection<Model> models;

    public SceneLeaf(Matrix4f matrix, Model ... models) {
        this(matrix, Arrays.asList(models));
    }

    public SceneLeaf(Matrix4f matrix, Collection<Model> models) {
        super(matrix);
        this.models = new ArrayList<Model>(models);
    }

    @Override
    public RayResult intersect(Ray ray) {
        Ray transRay = ray.cloneTransformed(this.matrix);
        RayResult returnResult = null;
        for (Model i : this.models) {
            RayResult iResult = i.intersect(transRay);
            if (returnResult != null && (iResult == null || !(returnResult.t > iResult.t))) continue;
            if (iResult != null) {
                iResult.setMaterial(i.getMaterial());
            }
            returnResult = iResult;
        }
        if (returnResult != null) {
            returnResult.addMatrix(this.matrixT, this.matrixInv);
        }
        return returnResult;
    }
}

