/*
 * Decompiled with CFR 0.152.
 */
package io;

import algebra.Color3f;
import geometry.ray.RayResult;
import io.CgPanel;
import io.TracerPanel;
import io.TracerThreadManager;
import io.scenes.XMas;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import scene.Scene;
import tracer.AA4Tracer;
import tracer.ClickTracer;
import tracer.RayTracer;

public class WindowPanel
implements MouseListener,
TracerPanel {
    private JFrame frame;
    private CgPanel panel;
    private RayTracer tracer;
    private ClickTracer clickTracer;
    private long startTime;

    public static void main(String[] args) throws InterruptedException {
        WindowPanel simple = new WindowPanel();
        simple.setup();
        simple.start();
    }

    public WindowPanel() throws InterruptedException {
        int width = 640;
        int height = 720;
        this.panel = new CgPanel(1000);
        this.panel.addMouseListener(this);
        this.panel.setPreferredSize(new Dimension(640, 720));
        this.frame = new JFrame();
        this.frame.setSize(640, 720);
        this.frame.getContentPane().add(this.panel);
        this.frame.getContentPane().setSize(640, 720);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
        while (this.panel.rgbpixelsLength() < 1) {
            Thread.yield();
        }
        this.panel.repaint();
        this.panel.flush();
    }

    private void setup() {
        Scene scene = XMas.tree(this.getWidth(), this.getHeight());
        this.tracer = new AA4Tracer(scene);
        this.clickTracer = new ClickTracer(scene);
        System.gc();
    }

    public void start() {
        this.panel.clear(0.2f);
        TracerThreadManager manager = new TracerThreadManager(this, this.tracer);
        this.startTime = System.currentTimeMillis();
        manager.start(8);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            RayResult click = this.clickTracer.click(e.getX(), e.getY());
            System.out.println(click.getWorldLocation());
        } else {
            this.panel.repaint();
            this.panel.flush();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public int getHeight() {
        return this.panel.getHeight();
    }

    @Override
    public int getWidth() {
        return this.panel.getWidth();
    }

    @Override
    public void drawPixel(int x, int y, Color3f c) {
        this.panel.drawPixel(x, y, c);
    }

    @Override
    public void finished() {
        int seconds = (int)((float)(System.currentTimeMillis() - this.startTime) * 0.001f);
        float minutes = (float)seconds / 60.0f;
        System.out.println("Trace stop. " + seconds + "s = " + minutes + "m");
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void repaint() {
        this.panel.repaint();
    }
}

