/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.TracerPanel;
import tracer.RayTracer;

public class TracerThreadManager {
    private final int totalLines;
    private final TracerPanel panel;
    private final RayTracer tracer;
    private int assignedLines;
    private int finishedLines;

    public TracerThreadManager(TracerPanel panel, RayTracer tracer) {
        this.totalLines = panel.getHeight();
        this.panel = panel;
        this.tracer = tracer;
    }

    public void start(int threads) {
        this.assignedLines = threads;
        this.finishedLines = 0;
        System.out.println("Making " + threads + " threads for " + this.totalLines + " lines.");
        int i = 0;
        while (i < threads) {
            new Thread(new TracerThread(this, this.panel, this.tracer, i)).start();
            ++i;
        }
    }

    public synchronized int lineDone() {
        ++this.finishedLines;
        this.panel.repaint();
        if (this.finishedLines >= this.totalLines) {
            this.panel.finished();
        }
        if (this.assignedLines >= this.totalLines) {
            return -1;
        }
        return this.assignedLines++;
    }

    private class TracerThread
    implements Runnable {
        private final TracerThreadManager manager;
        private final TracerPanel panel;
        private final RayTracer tracer;
        private int line;

        public TracerThread(TracerThreadManager manager, TracerPanel panel, RayTracer tracer, int line) {
            this.manager = manager;
            this.panel = panel;
            this.tracer = tracer;
            this.line = line;
        }

        @Override
        public void run() {
            while (this.line >= 0 && this.line < this.panel.getHeight()) {
                int x = 0;
                while (x < this.panel.getWidth()) {
                    this.panel.drawPixel(x, this.line, this.tracer.trace(x, this.line).cap());
                    Thread.yield();
                    ++x;
                }
                this.line = this.manager.lineDone();
            }
        }
    }
}

