/*
 * Decompiled with CFR 0.152.
 */
package io;

import algebra.Color3f;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class CgPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -5903884695494369937L;
    private final int sleepTime;
    private int[] rgbpixels;
    private Image image;
    private MemoryImageSource mis;

    public CgPanel(int sleepTime) {
        this.sleepTime = sleepTime;
        this.addComponentListener(this);
        this.componentResized(new ComponentEvent(this, 101));
    }

    public void drawPixel(int x, int y, float r, float g, float b) {
        if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            this.rgbpixels[x + this.getWidth() * y] = this.calculateColor(r, g, b);
        }
    }

    public void drawPixel(int x, int y, Color3f c) {
        if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            this.rgbpixels[x + this.getWidth() * y] = this.calculateColor(c.x, c.y, c.z);
        }
    }

    public int getPixel(int x, int y) {
        return this.rgbpixels[x + this.getWidth() * y];
    }

    public int calculateColor(float r, float g, float b) {
        return 0xFF000000 | (int)(255.0f * r) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * b);
    }

    public void clear() {
        this.clear(0.0f, 0.0f, 0.0f);
    }

    public void clear(float r, float g, float b) {
        int color = 0xFF000000 | (int)(255.0f * r) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * b);
        int i = 0;
        while (i < this.getWidth() * this.getHeight()) {
            this.rgbpixels[i] = color;
            ++i;
        }
    }

    public void clear(float g) {
        this.clear(g, g, g);
    }

    public int rgbpixelsLength() {
        return this.rgbpixels.length;
    }

    public void flush() {
        RepaintManager.currentManager(this).paintDirtyRegions();
    }

    public void saveImage(String file) {
        this.mis.newPixels();
        try {
            BufferedImage buf = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g2 = buf.createGraphics();
            g2.drawImage(this.image, null, null);
            ImageIO.write((RenderedImage)buf, "png", new File(file));
            System.out.println("Saving of image to " + file + " succeeded.");
        }
        catch (Exception e) {
            System.out.println("Saving of image to " + file + " failed.");
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        this.mis.newPixels();
        g.drawImage(this.image, 0, 0, this);
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void componentResized(ComponentEvent e) {
        this.rgbpixels = new int[this.getWidth() * this.getHeight()];
        int i = 0;
        while (i < this.getWidth() * this.getHeight()) {
            this.rgbpixels[i] = -16777216;
            ++i;
        }
        this.mis = new MemoryImageSource(this.getWidth(), this.getHeight(), this.rgbpixels, 0, this.getWidth());
        this.mis.setAnimated(true);
        this.image = this.createImage(this.mis);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

