/*
 * Decompiled with CFR 0.152.
 */
package geometry.ray;

import algebra.Algebra;
import algebra.Matrix4f;
import algebra.TexCoord2f;
import algebra.Vector3f;
import algebra.transform.Transform;
import geometry.Geometry;
import geometry.ray.Ray;
import scene.material.Material;

public abstract class RayResult {
    private final Ray ray;
    public final float t;
    public final Geometry hit;
    protected Ray worldRay = null;
    protected Vector3f worldLocation = null;
    protected Vector3f objectLocation = null;
    protected Vector3f normal = null;
    protected TexCoord2f texCoord = null;
    protected Material material = null;
    private Matrix4f matrixT = Transform.identity();
    private Matrix4f matrixInv = Transform.identity();

    public RayResult(Ray ray, float t, Geometry hit) {
        this.t = t;
        this.hit = hit;
        this.worldRay = this.ray = ray;
    }

    public final Vector3f getWorldLocation() {
        if (this.worldLocation == null) {
            this.worldLocation = this.calcWorldLocation();
        }
        return this.worldLocation;
    }

    private Vector3f calcWorldLocation() {
        if (this.matrixInv != null) {
            return Algebra.multPoint(this.matrixInv, this.getObjectLocation());
        }
        return this.getObjectLocation();
    }

    public final Vector3f getObjectLocation() {
        if (this.objectLocation == null) {
            this.objectLocation = this.calcObjectLocation();
        }
        return this.objectLocation;
    }

    private Vector3f calcObjectLocation() {
        return Algebra.sum(this.ray.e, Algebra.scalar(this.ray.d, this.t));
    }

    public final Vector3f getNormal() {
        if (this.normal == null) {
            this.normal = this.calcNormal();
            if (this.matrixT != null) {
                this.normal = Algebra.multArrow(this.matrixT, this.normal);
            }
        }
        return Algebra.unit(this.normal);
    }

    protected abstract Vector3f calcNormal();

    public final TexCoord2f getTexCoord() {
        if (this.texCoord == null) {
            this.texCoord = this.calcTexCoord();
        }
        return this.texCoord;
    }

    protected abstract TexCoord2f calcTexCoord();

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        assert (this.material == null) : "Material set twice.";
        this.material = material;
    }

    public void addMatrix(Matrix4f matrixT, Matrix4f matrixInv) {
        this.matrixT = Algebra.multMatrix(matrixT, this.matrixT);
        this.matrixInv = Algebra.multMatrix(matrixInv, this.matrixInv);
    }

    public void setWorldRay(Ray ray) {
        assert (this.worldRay == this.ray) : "WorldRay set twice.";
        this.worldRay = ray;
    }

    public Ray getWorldRay() {
        return this.worldRay;
    }
}

