/*
 * Decompiled with CFR 0.152.
 */
package geometry.bounding;

import geometry.Geometry;
import geometry.bounding.KDBox;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.Collection;

public class KDLeafBox
extends KDBox {
    private final Geometry[] objects;

    public KDLeafBox(Collection<Geometry> objects, int lowerBound, int depth) {
        super(objects, lowerBound, depth);
        this.objects = objects.toArray(new Geometry[objects.size()]);
    }

    @Override
    public RayResult searchBox(Ray ray) {
        if (!this.hitBox(ray)) {
            return null;
        }
        RayResult returnResult = null;
        Geometry[] geometryArray = this.objects;
        int n = this.objects.length;
        int n2 = 0;
        while (n2 < n) {
            Geometry i = geometryArray[n2];
            RayResult iResult = i.intersect(ray);
            if (returnResult == null || iResult != null && returnResult.t > iResult.t) {
                returnResult = iResult;
            }
            ++n2;
        }
        if (returnResult != null) {
            return returnResult;
        }
        return null;
    }
}

