/*
 * Decompiled with CFR 0.152.
 */
package algebra;

import algebra.FloatUtil;
import algebra.Matrix4f;
import algebra.SingularMatrixException;
import algebra.Vector3f;
import algebra.Vector4f;

public abstract class Algebra {
    @Deprecated
    public static Vector4f multVector4f(Matrix4f m, Vector4f v) {
        Vector4f[] rows = new Vector4f[4];
        int i = 0;
        while (i < rows.length) {
            rows[i] = m.getRowVector(i);
            ++i;
        }
        float[] results = new float[4];
        int x = 0;
        while (x < rows.length) {
            results[x] = Algebra.doth(v, rows[x]);
            ++x;
        }
        return new Vector4f(results);
    }

    public static Vector3f multPoint(Matrix4f m, Vector3f v3) {
        if (m.isIdentity()) {
            return v3;
        }
        float x = v3.x * m.m00 + v3.y * m.m01 + v3.z * m.m02 + m.m03;
        float y = v3.x * m.m10 + v3.y * m.m11 + v3.z * m.m12 + m.m13;
        float z = v3.x * m.m20 + v3.y * m.m21 + v3.z * m.m22 + m.m23;
        float w = v3.x * m.m30 + v3.y * m.m31 + v3.z * m.m32 + m.m33;
        if (w != 1.0f) {
            float invW = 1.0f / w;
            return new Vector3f(x * invW, y * invW, z * invW);
        }
        return new Vector3f(x, y, z);
    }

    public static Vector3f multArrow(Matrix4f m, Vector3f v3) {
        if (m.isIdentity()) {
            return v3;
        }
        float x = v3.x * m.m00 + v3.y * m.m01 + v3.z * m.m02;
        float y = v3.x * m.m10 + v3.y * m.m11 + v3.z * m.m12;
        float z = v3.x * m.m20 + v3.y * m.m21 + v3.z * m.m22;
        return new Vector3f(x, y, z);
    }

    public static Matrix4f multMatrix(Matrix4f a, Matrix4f b) {
        if (a.isIdentity()) {
            return b;
        }
        if (b.isIdentity()) {
            return a;
        }
        float m00 = a.m00 * b.m00 + a.m01 * b.m10 + a.m02 * b.m20 + a.m03 * b.m30;
        float m01 = a.m00 * b.m01 + a.m01 * b.m11 + a.m02 * b.m21 + a.m03 * b.m31;
        float m02 = a.m00 * b.m02 + a.m01 * b.m12 + a.m02 * b.m22 + a.m03 * b.m32;
        float m03 = a.m00 * b.m03 + a.m01 * b.m13 + a.m02 * b.m23 + a.m03 * b.m33;
        float m10 = a.m10 * b.m00 + a.m11 * b.m10 + a.m12 * b.m20 + a.m13 * b.m30;
        float m11 = a.m10 * b.m01 + a.m11 * b.m11 + a.m12 * b.m21 + a.m13 * b.m31;
        float m12 = a.m10 * b.m02 + a.m11 * b.m12 + a.m12 * b.m22 + a.m13 * b.m32;
        float m13 = a.m10 * b.m03 + a.m11 * b.m13 + a.m12 * b.m23 + a.m13 * b.m33;
        float m20 = a.m20 * b.m00 + a.m21 * b.m10 + a.m22 * b.m20 + a.m23 * b.m30;
        float m21 = a.m20 * b.m01 + a.m21 * b.m11 + a.m22 * b.m21 + a.m23 * b.m31;
        float m22 = a.m20 * b.m02 + a.m21 * b.m12 + a.m22 * b.m22 + a.m23 * b.m32;
        float m23 = a.m20 * b.m03 + a.m21 * b.m13 + a.m22 * b.m23 + a.m23 * b.m33;
        float m30 = a.m30 * b.m00 + a.m31 * b.m10 + a.m32 * b.m20 + a.m33 * b.m30;
        float m31 = a.m30 * b.m01 + a.m31 * b.m11 + a.m32 * b.m21 + a.m33 * b.m31;
        float m32 = a.m30 * b.m02 + a.m31 * b.m12 + a.m32 * b.m22 + a.m33 * b.m32;
        float m33 = a.m30 * b.m03 + a.m31 * b.m13 + a.m32 * b.m23 + a.m33 * b.m33;
        return new Matrix4f(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public static Matrix4f transpose(Matrix4f a) {
        if (a.isIdentity()) {
            return a;
        }
        return new Matrix4f(a.m00, a.m10, a.m20, a.m30, a.m01, a.m11, a.m21, a.m31, a.m02, a.m12, a.m22, a.m32, a.m03, a.m13, a.m23, a.m33);
    }

    public static Matrix4f inverse(Matrix4f m) {
        if (m.isIdentity()) {
            return m;
        }
        float s0 = m.m00 * m.m11 - m.m10 * m.m01;
        float c5 = m.m22 * m.m33 - m.m32 * m.m23;
        float s1 = m.m00 * m.m12 - m.m10 * m.m02;
        float c4 = m.m21 * m.m33 - m.m31 * m.m23;
        float s2 = m.m00 * m.m13 - m.m10 * m.m03;
        float c3 = m.m21 * m.m32 - m.m31 * m.m22;
        float s3 = m.m01 * m.m12 - m.m11 * m.m02;
        float c2 = m.m20 * m.m33 - m.m30 * m.m23;
        float s4 = m.m01 * m.m13 - m.m11 * m.m03;
        float c1 = m.m20 * m.m32 - m.m30 * m.m22;
        float s5 = m.m02 * m.m13 - m.m12 * m.m03;
        float c0 = m.m20 * m.m31 - m.m30 * m.m21;
        float det = s0 * c5 - s1 * c4 + s2 * c3 + s3 * c2 - s4 * c1 + s5 * c0;
        if (det == 0.0f) {
            throw new SingularMatrixException();
        }
        float invDet = 1.0f / det;
        return new Matrix4f((m.m11 * c5 - m.m12 * c4 + m.m13 * c3) * invDet, (-m.m01 * c5 + m.m02 * c4 - m.m03 * c3) * invDet, (m.m31 * s5 - m.m32 * s4 + m.m33 * s3) * invDet, (-m.m21 * s5 + m.m22 * s4 - m.m23 * s3) * invDet, (-m.m10 * c5 + m.m12 * c2 - m.m13 * c1) * invDet, (m.m00 * c5 - m.m02 * c2 + m.m03 * c1) * invDet, (-m.m30 * s5 + m.m32 * s2 - m.m33 * s1) * invDet, (m.m20 * s5 - m.m22 * s2 + m.m23 * s1) * invDet, (m.m10 * c4 - m.m11 * c2 + m.m13 * c0) * invDet, (-m.m00 * c4 + m.m01 * c2 - m.m03 * c0) * invDet, (m.m30 * s4 - m.m31 * s2 + m.m33 * s0) * invDet, (-m.m20 * s4 + m.m21 * s2 - m.m23 * s0) * invDet, (-m.m10 * c3 + m.m11 * c1 - m.m12 * c0) * invDet, (m.m00 * c3 - m.m01 * c1 + m.m02 * c0) * invDet, (-m.m30 * s3 + m.m31 * s1 - m.m32 * s0) * invDet, (m.m20 * s3 - m.m21 * s1 + m.m22 * s0) * invDet);
    }

    public static float doth(Vector4f a, Vector4f b) {
        return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
    }

    public static float dot(Vector4f a, Vector4f b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static float dot(Vector3f a, Vector3f b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static float dot1(Vector4f a) {
        return Algebra.dot(a, a);
    }

    public static float dot1(Vector3f a) {
        return Algebra.dot(a, a);
    }

    public static Vector4f cross(Vector4f a, Vector4f b) {
        return new Vector4f(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static Vector3f cross(Vector3f a, Vector3f b) {
        return new Vector3f(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static Vector4f sum(Vector4f a, Vector4f b) {
        return new Vector4f(a.x + b.x, a.y + b.y, a.z + b.z, 1.0f);
    }

    public static Vector3f sum(Vector3f a, Vector3f b) {
        return new Vector3f(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector4f substract(Vector4f a, Vector4f b) {
        return new Vector4f(a.x - b.x, a.y - b.y, a.z - b.z, 1.0f);
    }

    public static Vector3f substract(Vector3f a, Vector3f b) {
        return new Vector3f(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector4f neg(Vector4f a) {
        return new Vector4f(-a.x, -a.y, -a.z);
    }

    public static Vector3f neg(Vector3f a) {
        return new Vector3f(-a.x, -a.y, -a.z);
    }

    public static Vector4f scalar(Vector4f a, float s) {
        return new Vector4f(s * a.x, s * a.y, s * a.z);
    }

    public static Vector3f scalar(Vector3f a, float s) {
        return new Vector3f(s * a.x, s * a.y, s * a.z);
    }

    public static float length(Vector4f a) {
        return (float)Math.sqrt(Algebra.dot1(a));
    }

    public static float length(Vector3f a) {
        if (a.isUnit()) {
            return 1.0f;
        }
        return (float)Math.sqrt(Algebra.dot1(a));
    }

    public static float cosAngle(Vector4f a, Vector4f b) {
        return (float)((double)Algebra.dot(a, b) / Math.sqrt(Algebra.dot1(a) * Algebra.dot1(b)));
    }

    public static float cosAngle(Vector3f a, Vector3f b) {
        return (float)((double)Algebra.dot(a, b) / Math.sqrt(Algebra.dot1(a) * Algebra.dot1(b)));
    }

    public static float angle(Vector4f a, Vector4f b) {
        return (float)Math.acos(Algebra.cosAngle(a, b));
    }

    public static Vector4f unit(Vector4f a) {
        return Algebra.scalar(a, 1.0f / Algebra.length(a));
    }

    public static Vector3f unit(Vector3f a) {
        if (a.isUnit()) {
            return a;
        }
        return new Vector3f(Algebra.scalar(a, 1.0f / Algebra.length(a)), true);
    }

    public static boolean isUnit(Vector4f a) {
        return FloatUtil.equalFloat(1.0f, Algebra.dot1(a));
    }

    public static boolean isUnit(Vector3f a) {
        return a.isUnit() || FloatUtil.equalFloat(1.0f, Algebra.dot1(a));
    }

    public static Vector4f perturb(Vector4f a, Vector4f d, float epsilon) {
        return Algebra.sum(a, Algebra.scalar(d, epsilon));
    }

    public static Vector3f perturb(Vector3f a, Vector3f d, float epsilon) {
        return Algebra.sum(a, Algebra.scalar(d, epsilon));
    }

    public static Vector4f abs(Vector4f a) {
        return new Vector4f(Math.abs(a.x), Math.abs(a.y), Math.abs(a.z));
    }

    public static Vector4f min(Vector4f a, Vector4f b) {
        return new Vector4f(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z));
    }

    public static Vector3f min(Vector3f a, Vector3f b) {
        return new Vector3f(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z));
    }

    public static Vector4f max(Vector4f a, Vector4f b) {
        return new Vector4f(Math.max(a.x, b.x), Math.max(a.y, b.y), Math.max(a.z, b.z));
    }

    public static Vector3f max(Vector3f a, Vector3f b) {
        return new Vector3f(Math.max(a.x, b.x), Math.max(a.y, b.y), Math.max(a.z, b.z));
    }

    public static Vector3f mirror(Vector3f i, Vector3f n) {
        return Algebra.substract(i, Algebra.scalar(n, 2.0f * Algebra.dot(i, n)));
    }
}

