#version 130
uniform bool horizontal;
uniform sampler2D textureMap;

void main (void)
{
  const float gauss[7] = float[7](0.00038771,0.01330373,0.11098164,0.22508352,0.11098164,0.01330373,0.00038771);
  vec2 size = 1.0 / textureSize(textureMap,0);
  vec2 texCoord = gl_FragCoord.xy * size;

  vec4 color;
  vec4 final_color = vec4(0.0);

  int i;
  if (horizontal)
  {
	  for(i=-3; i<= 3; i++)
	  {
		color = texture2D(textureMap, texCoord + vec2(i*size.x,0.0) );
		final_color += color * gauss[i+3];
	  }
  }
  else
  {
	  for(i=-3; i<= 3; i++)
	  {
		color = texture2D(textureMap, texCoord + vec2(0.0,i*size.y) );
		final_color += color * gauss[i+3];
	  }
  }
  gl_FragColor = final_color * 2.1;
}
