kernel void particle3(global float4 *in)
{
	int i = get_global_id(0);

	float4 v1 = (float4)(86.6f,-50.0,0,0) - in[i];
	float4 v2 = (float4)(-86.6f,-50.0,0,0) - in[i];
	float4 v3 = (float4)( 0,100,0,0) - in[i];
	
	float len1 = length(v1)*length(v1) - 1000.0f;
	float len2 = length(v2)*length(v2) - 1000.0f;
	float len3 = length(v3)*length(v3) - 1000.0f;

	float force = len1*len2*len3 / 1e13f;
	
	float4 dir = (normalize(v1) + normalize(v2) + normalize(v3)) * force;
	in[i] += dir;
}