#pragma once

struct Vector2
{
	float x,y;
	Vector2() {};
	Vector2(float X, float Y) {x=X;y=Y;};
	
	float Magnitude() const {return (float)sqrt(x*x+y*y);};
	float MagnitudeSq() const  {return (float)(x*x+y*y);};
	void Normalise() {float l=Magnitude();if (l!=0) {l=1.f/l;x*=l;y*=l;} else {x=1;y=0;};};
	float operator*(const Vector2 &a) const  {return x*a.x+y*a.y;};
	Vector2 operator*(const float a) const {return Vector2(x*a,y*a);};
	Vector2 operator+(const Vector2 &a) const  {return Vector2(x+a.x,y+a.y);};
	Vector2 operator-(const Vector2 &a) const {return Vector2(x-a.x,y-a.y);};
	float operator^(const Vector2 &a) const {return x*a.y-y*a.x;};
	void operator*=(const float a) {x*=a;y*=a;};
	void operator+=(const Vector2 &a) {x+=a.x;y+=a.y;};
	void operator-=(const Vector2 &a) {x-=a.x;y-=a.y;};
	int operator==(const Vector2 &a) const {return (x==a.x && y==a.y);}
	bool operator<(const Vector2 &a) const {if (x!=a.x) return x<a.x; return y<a.y;}
	

};


	

struct F
{
	int a,b,c;
	float alpha;
};

typedef Vector2 V;
int CalcDelaunay(v3 *pnt, int numpoints, F *tri);


