#include	"StdAfx.h"
#include	<D3DX8.h>

//using namespace BS3;

//namespace BS3
//{
	typedef float mat44[4][4];
	
	Matrix44::Matrix44(const Matrix44& m)
	{
		for ( int i=0; i<4; i++ )
		{
			m44[i][0] = m.m44[i][0];
			m44[i][1] = m.m44[i][1];
			m44[i][2] = m.m44[i][2];
			m44[i][3] = m.m44[i][3];
		}
	}
	
	
	Matrix44 Matrix44::operator + (const Matrix44& right) const
	{
		Matrix44 r;
		const mat44& m = right.m44;
		
		for ( int i=0; i<4; i++ )
		{
			r.m44[i][0] = m44[i][0] + m[i][0];
			r.m44[i][1] = m44[i][1] + m[i][1];
			r.m44[i][2] = m44[i][2] + m[i][2];
			r.m44[i][3] = m44[i][3] + m[i][3];
		}
		return r;
	}
	
	
	Matrix44 Matrix44::operator - (const Matrix44& right) const
	{
		Matrix44 r;
		const mat44& m = right.m44;
		
		for ( int i=0; i<4; i++ )
		{
			r.m44[i][0] = m44[i][0] - m[i][0];
			r.m44[i][1] = m44[i][1] - m[i][1];
			r.m44[i][2] = m44[i][2] - m[i][2];
			r.m44[i][3] = m44[i][3] - m[i][3];
		}
		return r;
	}
	
	
	Matrix44 Matrix44::operator * (const Matrix44& right) const
	{
		Matrix44 r;
		const mat44& m = right.m44;
		
		for ( int i=0; i<4; i++ )
		{
			const float* v = m16 + i*4;
			r.m44[i][0] = v[0]*m[0][0] + v[1]*m[1][0] + v[2]*m[2][0] + v[3]*m[3][0];
			r.m44[i][1] = v[0]*m[0][1] + v[1]*m[1][1] + v[2]*m[2][1] + v[3]*m[3][1];
			r.m44[i][2] = v[0]*m[0][2] + v[1]*m[1][2] + v[2]*m[2][2] + v[3]*m[3][2];
			r.m44[i][3] = v[0]*m[0][3] + v[1]*m[1][3] + v[2]*m[2][3] + v[3]*m[3][3];
		}
		return r;
	}
	
	Matrix44 Matrix44::operator * (const float right) const
	{
		Matrix44 r;
		for (int j=0;j<16;j++) r.m16[j]=m16[j]*right;
		return r;
	}
	
	Matrix44 &Matrix44::operator *= (const float right) 
	{
		for (int j=0;j<16;j++) m16[j]*=right;
		return (*this);
	}
	
	
	Matrix44& Matrix44::operator += (const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			m44[i][0] += m[i][0];
			m44[i][1] += m[i][1];
			m44[i][2] += m[i][2];
			m44[i][3] += m[i][3];
		}
		return *this;
	}
	
	
	Matrix44& Matrix44::operator -= (const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			m44[i][0] -= m[i][0];
			m44[i][1] -= m[i][1];
			m44[i][2] -= m[i][2];
			m44[i][3] -= m[i][3];
		}
		return *this;
	}
	
	
	Matrix44& Matrix44::operator *= (const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			float v[4];
			v[0] = m44[i][0];
			v[1] = m44[i][1];
			v[2] = m44[i][2];
			v[3] = m44[i][3];
			m44[i][0] = v[0]*m[0][0] + v[1]*m[1][0] + v[2]*m[2][0] + v[3]*m[3][0];
			m44[i][1] = v[0]*m[0][1] + v[1]*m[1][1] + v[2]*m[2][1] + v[3]*m[3][1];
			m44[i][2] = v[0]*m[0][2] + v[1]*m[1][2] + v[2]*m[2][2] + v[3]*m[3][2];
			m44[i][3] = v[0]*m[0][3] + v[1]*m[1][3] + v[2]*m[2][3] + v[3]*m[3][3];
		}
		return *this;
	}
	
	
	void Matrix44::operator = (const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			m44[i][0] = m[i][0];
			m44[i][1] = m[i][1];
			m44[i][2] = m[i][2];
			m44[i][3] = m[i][3];
		}
	}
	
	
	
	float Matrix44::GetDeterminant() const
	{
	/*
	return
	m44[0][0] * m44[1][1] * m44[2][2] +
	m44[0][1] * m44[1][2] * m44[2][0] +
	m44[0][2] * m44[1][0] * m44[2][1] -
	m44[0][2] * m44[1][1] * m44[2][0] -
	m44[0][1] * m44[1][0] * m44[2][2] -
	m44[0][0] * m44[1][2] * m44[2][1];
		*/
		return D3DXMatrixfDeterminant((D3DXMATRIX*)this);
	}
	
	
	
	void Matrix44::Identity()
	{
		m44[0][0] = 1; m44[0][1] = 0; m44[0][2] = 0; m44[0][3] = 0;
		m44[1][0] = 0; m44[1][1] = 1; m44[1][2] = 0; m44[1][3] = 0;
		m44[2][0] = 0; m44[2][1] = 0; m44[2][2] = 1; m44[2][3] = 0;
		m44[3][0] = 0; m44[3][1] = 0; m44[3][2] = 0; m44[3][3] = 1;
	}
	
	
	void Matrix44::Scale(float x, float y, float z)
	{
		m44[0][0] = x; m44[0][1] = 0; m44[0][2] = 0; m44[0][3] = 0;
		m44[1][0] = 0; m44[1][1] = y; m44[1][2] = 0; m44[1][3] = 0;
		m44[2][0] = 0; m44[2][1] = 0; m44[2][2] = z; m44[2][3] = 0;
		m44[3][0] = 0; m44[3][1] = 0; m44[3][2] = 0; m44[3][3] = 1;
	}
	
	
	void Matrix44::Translate(float x, float y, float z)
	{
		m44[0][0] = 1; m44[0][1] = 0; m44[0][2] = 0; m44[0][3] = 0;
		m44[1][0] = 0; m44[1][1] = 1; m44[1][2] = 0; m44[1][3] = 0;
		m44[2][0] = 0; m44[2][1] = 0; m44[2][2] = 1; m44[2][3] = 0;
		m44[3][0] = x; m44[3][1] = y; m44[3][2] = z; m44[3][3] = 1;
	}
	
	void Matrix44::RotateX(float angle)
	{
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		
		m44[0][0] = 1; m44[0][1] = 0; m44[0][2] = 0; m44[0][3] = 0;
		m44[1][0] = 0; m44[1][1] = c; m44[1][2] = s; m44[1][3] = 0;
		m44[2][0] = 0; m44[2][1] =-s; m44[2][2] = c; m44[2][3] = 0;
		m44[3][0] = 0; m44[3][1] = 0; m44[3][2] = 0; m44[3][3] = 1;
	}
	
	
	void Matrix44::RotateY(float angle)
	{
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		
		m44[0][0] = c; m44[0][1] = 0; m44[0][2] =-s; m44[0][3] = 0;
		m44[1][0] = 0; m44[1][1] = 1; m44[1][2] = 0; m44[1][3] = 0;
		m44[2][0] = s; m44[2][1] = 0; m44[2][2] = c; m44[2][3] = 0;
		m44[3][0] = 0; m44[3][1] = 0; m44[3][2] = 0; m44[3][3] = 1;
	}
	
	
	void Matrix44::RotateZ(float angle)
	{
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		
		m44[0][0] = c; m44[0][1] = s; m44[0][2] = 0; m44[0][3] = 0;
		m44[1][0] =-s; m44[1][1] = c; m44[1][2] = 0; m44[1][3] = 0;
		m44[2][0] = 0; m44[2][1] = 0; m44[2][2] = 1; m44[2][3] = 0;
		m44[3][0] = 0; m44[3][1] = 0; m44[3][2] = 0; m44[3][3] = 1;
	}
	
	
	void Matrix44::RotateXYZ(float yaw, float pitch, float roll)
	{
		float sy = (float)sin( yaw );
		float cy = (float)cos( yaw );
		float sp = (float)sin( pitch );
		float cp = (float)cos( pitch );
		float sr = (float)cos( roll );
		float cr = (float)sin( roll );
		float spsy = sp * sy;
		float spcy = sp * cy;
		
		m44[0][0] = sr * cp;
		m44[0][1] = cr * cp;
		m44[0][2] = -sp;
		m44[0][3] = 0;
		m44[1][0] = sr * spsy - cr * cy;
		m44[1][1] = cr * spsy + sr * cy;
		m44[1][2] = cp * sy;
		m44[1][3] = 0;
		m44[2][0] = sr * spcy + cr * sy;
		m44[2][1] = cr * spcy - sr * sy;
		m44[2][2] = cp * cy;
		m44[2][3] = 0;
		m44[3][0] = 0;
		m44[3][1] = 0;
		m44[3][2] = 0;
		m44[3][3] = 1;
	}
	
	
	void Matrix44::RotateAngleAxis(float angle, const Vector3& axis)
	{
		if ( !LengthSquared(axis) )
		{
			Identity();
			return;
		}
		
		Vector3 n = Normalize(axis);
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		float k = 1 - c;
		
		float xx = n.x * n.x * k + c;
		float yy = n.y * n.y * k + c;
		float zz = n.z * n.z * k + c;
		float xy = n.x * n.y * k;
		float yz = n.y * n.z * k;
		float zx = n.z * n.x * k;
		float xs = n.x * s;
		float ys = n.y * s;
		float zs = n.z * s;
		
		m44[0][0] = xx;
		m44[0][1] = xy + zs;
		m44[0][2] = zx - ys;
		m44[0][3] = 0;
		m44[1][0] = xy - zs;
		m44[1][1] = yy;
		m44[1][2] = yz + xs;
		m44[1][3] = 0;
		m44[2][0] = zx + ys;
		m44[2][1] = yz - xs;
		m44[2][2] = zz;
		m44[2][3] = 0;
		m44[3][0] = 0;
		m44[3][1] = 0;
		m44[3][2] = 0;
		m44[3][3] = 1;
	}
	
	
	void Matrix44::MultScale(float sx, float sy, float sz)
	{
		for ( int i=0; i<4; i++ )
		{
			m44[i][0] *= sx;
			m44[i][1] *= sy;
			m44[i][2] *= sz;
		}
	}
	
	
	void Matrix44::MultTranslate(float tx, float ty, float tz)
	{
		for ( int i=0; i<4; i++ )
		{
			float& e = m44[i][3];
			m44[i][0] += e * tx;
			m44[i][1] += e * ty;
			m44[i][2] += e * tz;
		}
	}
	
	
	void Matrix44::MultRotateX(float angle)
	{
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		
		for ( int i=0; i<4; i++ )
		{
			float y = m44[i][1];
			float z = m44[i][2];
			m44[i][1] = y * c - z * s;
			m44[i][2] = z * c + y * s;
		}
	}
	
	
	void Matrix44::MultRotateY(float angle)
	{
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		
		for ( int i=0; i<4; i++ )
		{
			float x = m44[i][0];
			float z = m44[i][2];
			m44[i][0] = x * c + z * s;
			m44[i][2] = z * c - x * s;
		}
	}
	
	
	void Matrix44::MultRotateZ(float angle)
	{
		float s = (float)sin( angle );
		float c = (float)cos( angle );
		
		for ( int i=0; i<4; i++ )
		{
			float x = m44[i][0];
			float y = m44[i][1];
			m44[i][0] = x * c - y * s;
			m44[i][1] = x * s + y * c;
		}
	}
	
	
	void Matrix44::MultRotateXYZ(float yaw, float pitch, float roll)
	{
		float sy = (float)sin( yaw );
		float cy = (float)cos( yaw );
		float sp = (float)sin( pitch );
		float cp = (float)cos( pitch );
		float sr = (float)cos( roll );
		float cr = (float)sin( roll );
		
		float m00 = sr * cp;
		float m01 = cr * cp;
		float m02 = -sp;
		float m10 = sp * sy - cr * cy;
		float m11 = cr * sp * sy + sr * cy;
		float m12 = cp * sy;
		float m20 = sr * sp * cy + cr * sy;
		float m21 = cr * sp * cy - sr * sy;
		float m22 = cp * cy;
		
		for ( int i=0; i<4; i++ )
		{
			float x = m44[i][0];
			float y = m44[i][1];
			float z = m44[i][2];
			m44[i][0] = x * m00 + y * m10 + z * m20;
			m44[i][1] = x * m01 + y * m11 + z * m21;
			m44[i][2] = x * m02 + y * m12 + z * m22;
		}
	}
	
	
	void Matrix44::MultMatrix44(const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			float v[4];
			v[0] = m44[i][0];
			v[1] = m44[i][1];
			v[2] = m44[i][2];
			v[3] = m44[i][3];
			m44[i][0] = v[0]*m[0][0] + v[1]*m[1][0] + v[2]*m[2][0] + v[3]*m[3][0];
			m44[i][1] = v[0]*m[0][1] + v[1]*m[1][1] + v[2]*m[2][1] + v[3]*m[3][1];
			m44[i][2] = v[0]*m[0][2] + v[1]*m[1][2] + v[2]*m[2][2] + v[3]*m[3][2];
			m44[i][3] = v[0]*m[0][3] + v[1]*m[1][3] + v[2]*m[2][3] + v[3]*m[3][3];
		}
	}
	
	
	void Matrix44::MultMatrix34(const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			float v[3];
			v[0] = m44[i][0];
			v[1] = m44[i][1];
			v[2] = m44[i][2];
			m44[i][0] = v[0]*m[0][0] + v[1]*m[1][0] + v[2]*m[2][0];
			m44[i][1] = v[0]*m[0][1] + v[1]*m[1][1] + v[2]*m[2][1];
			m44[i][2] = v[0]*m[0][2] + v[1]*m[1][2] + v[2]*m[2][2];
		}
		m44[3][0] += m[3][0];
		m44[3][1] += m[3][1];
		m44[3][2] += m[3][2];
	}
	
	
	void Matrix44::MultMatrix33(const Matrix44& right)
	{
		const mat44& m = right.m44;
		for ( int i=0; i<4; i++ )
		{
			float v[3];
			v[0] = m44[i][0];
			v[1] = m44[i][1];
			v[2] = m44[i][2];
			m44[i][0] = v[0]*m[0][0] + v[1]*m[1][0] + v[2]*m[2][0];
			m44[i][1] = v[0]*m[0][1] + v[1]*m[1][1] + v[2]*m[2][1];
			m44[i][2] = v[0]*m[0][2] + v[1]*m[1][2] + v[2]*m[2][2];
		}
	}
	
	
	void Matrix44::MultInverseMatrix33(const Matrix44& right)
	{
		float m00 = m44[0][0];
		float m01 = m44[0][1];
		float m02 = m44[0][2];
		float m10 = m44[1][0];
		float m11 = m44[1][1];
		float m12 = m44[1][2];
		float m20 = m44[2][0];
		float m21 = m44[2][1];
		float m22 = m44[2][2];
		
		for ( int i=0; i<4; i++ )
		{
			const float* v = right.m16 + i*4;
			m44[i][0] = v[0]*m00 + v[1]*m10 + v[2]*m20;
			m44[i][1] = v[0]*m01 + v[1]*m11 + v[2]*m21;
			m44[i][2] = v[0]*m02 + v[1]*m12 + v[2]*m22;
		}
	}
	
	
	void Matrix44::Transpose()
	{
		Matrix44 v;
		
		v.m44[0][0] = m44[0][0];
		v.m44[0][1] = m44[1][0];
		v.m44[0][2] = m44[2][0];
		v.m44[0][3] = m44[3][0];
		v.m44[1][0] = m44[0][1];
		v.m44[1][1] = m44[1][1];
		v.m44[1][2] = m44[2][1];
		v.m44[1][3] = m44[3][1];
		v.m44[2][0] = m44[0][2];
		v.m44[2][1] = m44[1][2];
		v.m44[2][2] = m44[2][2];
		v.m44[2][3] = m44[3][2];
		v.m44[3][0] = m44[0][3];
		v.m44[3][1] = m44[1][3];
		v.m44[3][2] = m44[2][3];
		v.m44[3][3] = m44[3][3];
		
		*this = v;
	}
	
	
	void Matrix44::Transpose(const Matrix44& m)
	{
		m44[0][0] = m.m44[0][0];
		m44[0][1] = m.m44[1][0];
		m44[0][2] = m.m44[2][0];
		m44[0][3] = m.m44[3][0];
		m44[1][0] = m.m44[0][1];
		m44[1][1] = m.m44[1][1];
		m44[1][2] = m.m44[2][1];
		m44[1][3] = m.m44[3][1];
		m44[2][0] = m.m44[0][2];
		m44[2][1] = m.m44[1][2];
		m44[2][2] = m.m44[2][2];
		m44[2][3] = m.m44[3][2];
		m44[3][0] = m.m44[0][3];
		m44[3][1] = m.m44[1][3];
		m44[3][2] = m.m44[2][3];
		m44[3][3] = m.m44[3][3];
	}
	
	
	void Matrix44::Adjoint()
	{
		mat44& m = m44;
		Matrix44 v;
		
		v.m44[0][0] = m[1][1]*m[2][2] - m[1][2]*m[2][1];
		v.m44[0][1] = m[2][1]*m[0][2] - m[2][2]*m[0][1];
		v.m44[0][2] = m[0][1]*m[1][2] - m[0][2]*m[1][1];
		v.m44[0][3] = m[0][3];
		v.m44[1][0] = m[1][2]*m[2][0] - m[1][0]*m[2][2];
		v.m44[1][1] = m[2][2]*m[0][0] - m[2][0]*m[0][2];
		v.m44[1][2] = m[0][2]*m[1][0] - m[0][0]*m[1][2];
		v.m44[1][3] = m[1][3];
		v.m44[2][0] = m[1][0]*m[2][1] - m[1][1]*m[2][0];
		v.m44[2][1] = m[2][0]*m[0][1] - m[2][1]*m[0][0];
		v.m44[2][2] = m[0][0]*m[1][1] - m[0][1]*m[1][0];
		v.m44[2][3] = m[2][3];
		v.m44[3][0] = -(m[0][0]*m[3][0] + m[1][0]*m[3][1] + m[2][0]*m[3][2]);
		v.m44[3][1] = -(m[0][1]*m[3][0] + m[1][1]*m[3][1] + m[2][1]*m[3][2]);
		v.m44[3][2] = -(m[0][2]*m[3][0] + m[1][2]*m[3][1] + m[2][2]*m[3][2]);
		v.m44[3][3] = m[3][3];
		
		*this = v;
	}
	
	
	void Matrix44::Adjoint(const Matrix44& a)
	{
		const mat44& m = a.m44;
		
		m44[0][0] = m[1][1]*m[2][2] - m[1][2]*m[2][1];
		m44[0][1] = m[2][1]*m[0][2] - m[2][2]*m[0][1];
		m44[0][2] = m[0][1]*m[1][2] - m[0][2]*m[1][1];
		m44[0][3] = m[0][3];
		m44[1][0] = m[1][2]*m[2][0] - m[1][0]*m[2][2];
		m44[1][1] = m[2][2]*m[0][0] - m[2][0]*m[0][2];
		m44[1][2] = m[0][2]*m[1][0] - m[0][0]*m[1][2];
		m44[1][3] = m[1][3];
		m44[2][0] = m[1][0]*m[2][1] - m[1][1]*m[2][0];
		m44[2][1] = m[2][0]*m[0][1] - m[2][1]*m[0][0];
		m44[2][2] = m[0][0]*m[1][1] - m[0][1]*m[1][0];
		m44[2][3] = m[2][3];
		m44[3][0] = -(m[0][0]*m[3][0] + m[1][0]*m[3][1] + m[2][0]*m[3][2]);
		m44[3][1] = -(m[0][1]*m[3][0] + m[1][1]*m[3][1] + m[2][1]*m[3][2]);
		m44[3][2] = -(m[0][2]*m[3][0] + m[1][2]*m[3][1] + m[2][2]*m[3][2]);
		m44[3][3] = m[3][3];
	}
	
	
	void Matrix44::Inverse()
	{	
		D3DXMatrixInverse((D3DXMATRIX*)this,NULL,(D3DXMATRIX*)this);
	}
	
	
	void Matrix44::Inverse(const Matrix44& i)
	{
		D3DXMatrixInverse((D3DXMATRIX*)this,NULL,(D3DXMATRIX*)&i);
	}
	
	
	
	void Matrix44::OrthoNormalize()
	{
		Vector3 x = GetX();
		Vector3 y = GetY();
		Vector3 z = GetZ();
		
		x = Normalize(x);
		y -= x * DotProduct(x,y);
		y = Normalize(y);
		z = CrossProduct(x,y);
		
		SetX( x );
		SetY( y );
		SetZ( z );
	}
	
	
	
	
	void Matrix44::LookAt_LH(const Vector3& target, const Vector3& view, const Vector3& up)
	{
		D3DXMatrixLookAtLH((D3DXMATRIX*)this,(D3DXVECTOR3*)&view,(D3DXVECTOR3*)&target, (D3DXVECTOR3*)&up);
	}
	
	void Matrix44::PerspectiveProjection_LH(float nearplane, float farplane, float fovh, float fovv)
	{
		float aspect=fovh/fovv;
		D3DXMatrixPerspectiveFovLH((D3DXMATRIX*)this,fovv,aspect,nearplane,farplane);
	}
	
	
	void Matrix44::LookAt_RH(const Vector3& target, const Vector3& view, const Vector3& up)
	{
		D3DXMatrixLookAtRH((D3DXMATRIX*)this,(D3DXVECTOR3*)&view,(D3DXVECTOR3*)&target, (D3DXVECTOR3*)&up);
	}
	
	void Matrix44::PerspectiveProjection_RH(float nearplane, float farplane, float fovh, float fovv)
	{
		float aspect=fovh/fovv;
		D3DXMatrixPerspectiveFovRH((D3DXMATRIX*)this,fovv,aspect,nearplane,farplane);
	}
	
	
	
	
//};



