// InfoView.cpp : implementation file
//

#include "stdafx.h"
#include "thing.h"
#include "InfoView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInfoView

IMPLEMENT_DYNCREATE(CInfoView, CView)
CInfoView *CInfoView::infoview=NULL;

CInfoView::CInfoView()
{
	infoview=this;

	font.CreateFont(-12,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,"Lucida Console");
}

CInfoView::~CInfoView()
{
	font.DeleteObject();

}


BEGIN_MESSAGE_MAP(CInfoView, CView)
	//{{AFX_MSG_MAP(CInfoView)
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInfoView drawing


extern int filmoutstarted;
extern int curframeidx;

char *formattime(char *out, int tt)
{
	tt/=1000;
	sprintf(out,"%d:%d.%d",tt/3600,(tt/60)%60,tt%60);
	return out;
}

void CInfoView::OnDraw(CDC* pDC)
{
	
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	pDC->SetTextColor(0);
	pDC->SetBkMode(TRANSPARENT);
	CFont *oldfont = pDC->SelectObject(&font);
	CString str;
	campos=cammat.GetT();
	str.Format("cam %d time %0.2f cam %0.2f,%0.2f,%0.2f fov %0.2f",camedit->curpath, thedoc->GetCurTime(),campos.x,campos.y,campos.z,camfov);
	pDC->TextOut(0,0,str);
	char buf1[64],buf2[64];
	int tt=GetTickCount();
	int totaltime = 0;
	if (curframeidx>1) totaltime = (MAXFRAME-curframeidx) * ((tt-filmoutstarted) / curframeidx);
	str.Format("frame %d / %d, time elapsed %s,\ntime remaining %s",curframeidx,MAXFRAME,formattime(buf1,tt-filmoutstarted),formattime(buf2,totaltime));
	if (!realtime) pDC->TextOut(0,15,str);
	pDC->SelectObject(oldfont);
}

/////////////////////////////////////////////////////////////////////////////
// CInfoView diagnostics

#ifdef _DEBUG
void CInfoView::AssertValid() const
{
	CView::AssertValid();
}

void CInfoView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CInfoView message handlers

BOOL CInfoView::OnEraseBkgnd(CDC* pDC) 
{
	CRect rr;
	GetClientRect(&rr);
	pDC->FillSolidRect(&rr,GetSysColor(COLOR_BTNFACE));
	return 0;
	//return CView::OnEraseBkgnd(pDC);
}
