#pragma once

#define NCX1 0
#define NCY1 0
#define NCX2 0
#define NCY2 0

class CMainFrame;
class CSliderWnd;

#define BKCOL 0
#define BKCOL2 0x552400

enum MOUSESTATE
{
	MS_NONE,
	MS_LMBDOWN,
	MS_RMBDOWN,
	MS_MULTIDRAG,
	MS_DRAGSEL,
	MS_BOXDRAG,
	MS_WIREIN2OUT,
	MS_WIREOUT2IN,
	MS_WIREVIA,
	MS_WIREVIAMOVE,
	MS_DRAGVIEW,
	MS_SCROLL,
	MS_CLICKATTACH,
};


class CAlexView : public CScrollView
{
protected: // create from serialization only
	CAlexView();
	DECLARE_DYNCREATE(CAlexView)

// Attributes
public:

	CDocument* GetDocument();
	
	HFONT font,boldfont;
	AlexDC *alexdc;
	CDC *xmemdc;
	
	virtual void	InitBMP(CDC *dc, int ww, int hh);

	virtual int GetBKCol()
	{
		return BKCOL;
	}
	
	int mb;
	int cx;
	int cy;
	int mx,my;		
	int w,h;

	virtual void Blt(CDC *dc, int x, int y, int w, int h)
	{
		CPoint p = GetDeviceScrollPosition();
		GdiFlush();	
		if (alexdc) dc->BitBlt(x+p.x,y+p.y,w,h,xmemdc,x+alexdc->ncx1,y+alexdc->ncy1,SRCCOPY);
	}

	virtual void CalcWndSize()
	{
		int ww,hh;
		RECT r;
		GetClientRect(&r);
		ww=r.right-r.left;
		hh=r.bottom-r.top;	
		if (ww!=w || hh!=h)
		{
			InitBMP(0,ww,hh);
		}
	}

	virtual CMainFrame *GetMainFrame()
	{
		return ((CMainFrame*)AfxGetApp()->GetMainWnd());
	}


	virtual void Redraw();

	public:
	virtual ~CAlexView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll = TRUE);
	//protected:
	virtual void OnInitialUpdate(); // called first time after construct
//protected:
	//{{AFX_MSG(CBs3View)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDestroy();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
