#ifndef SM_MATRIX4X4

#define SM_MATRIX4X4

struct Vector3D;
struct Vector4D;

struct Matrix4X4
{
  float m_11, m_12, m_13, m_14,
        m_21, m_22, m_23, m_24,
        m_31, m_32, m_33, m_34,
        m_41, m_42, m_43, m_44;

  static Matrix4X4 Identity;  

  static Matrix4X4* Mult     (Matrix4X4* pD, const Matrix4X4* pA, const Matrix4X4* pB);
  Vector3D*  Transform(Vector3D* pD, const Vector3D* pS, unsigned iVectors);
  Vector3D*  RotTransform(Vector3D* pD, const Vector3D* pS, unsigned iVectors);

  Vector4D*  Transform4D(Vector4D* pD, const Vector4D* pS, unsigned iVectors);
};


#endif