// Magic Software, Inc.
// http://www.magic-software.com
// Copyright (c) 2000, All Rights Reserved
//
// Source code from Magic Software is supplied under the terms of a license
// agreement and may not be copied or disclosed except in accordance with the
// terms of that agreement.  The various license agreements may be found at
// the Magic Software web site.  This file is subject to the license
//
// FREE SOURCE CODE
// http://www.magic-software.com/License/free.pdf

#ifndef MGCMULTIPLECURVE_H
#define MGCMULTIPLECURVE_H

#include "MgcCurve.h"


template <class Vector>
class MgcMultipleCurve : public MgcCurve<Vector>
{
public:
    // abstract base class
    MgcMultipleCurve (int iSegments, float* afTime);
    virtual ~MgcMultipleCurve ();

    int GetSegments () const;
    const float* GetTimes () const;

    virtual float GetLength (float fT0, float fT1) const;
    virtual float GetTime (float fLength, int iIterations = 32,
        float fTolerance = 1e-06) const;

    virtual float GetVariation (float fT0, float fT1,
        const Vector* pkP0 = 0, const Vector* pkP1 = 0) const;

protected:
    int m_iSegments;
    float* m_afTime;

    // These quantities are allocated by GetLength when they are needed the
    // first time.  The allocations occur in InitializeLength (called by
    // GetLength), so this member function must be 'const'. In order to
    // allocate the arrays in a 'const' function, they must be declared as
    // 'mutable'.
    mutable float* m_afLength;
    mutable float* m_afAccumLength;

    void GetKeyInfo (float fTime, int& riKey, float& rfDt) const;

    void InitializeLength () const;
    virtual float GetSpeed (int iKey, float fTime) const = 0;
    virtual float GetLength (int iKey, float fT0, float fT1) const = 0;
    virtual float GetVariation (int iKey, float fT0,
        float fT1, const Vector& rkA, const Vector& rkB) const = 0;

    static float GetSpeedWithData (float fTime, void* pvData);
};

#include "MgcMultipleCurve.inl"

#endif
